/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.card;

import com.sun.javacard.filemodels.ParseErrorHandler;
import com.sun.javacard.filemodels.XListModel;
import java.awt.EventQueue;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Condition;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.ExecutionService;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javacard.api.AntClasspathClosureProvider;
import org.netbeans.modules.javacard.api.RunMode;
import org.netbeans.modules.javacard.common.NodeRefresher;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.ri.card.CardProperties;
import org.netbeans.modules.javacard.ri.card.ConditionImpl;
import org.netbeans.modules.javacard.ri.platform.loader.CardChildren;
import org.netbeans.modules.javacard.spi.BaseCard;
import org.netbeans.modules.javacard.spi.CardState;
import org.netbeans.modules.javacard.spi.ICardCapability;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.capabilities.AntTarget;
import org.netbeans.modules.javacard.spi.capabilities.AntTargetInterceptor;
import org.netbeans.modules.javacard.spi.capabilities.CardContentsProvider;
import org.netbeans.modules.javacard.spi.capabilities.CardCustomizerProvider;
import org.netbeans.modules.javacard.spi.capabilities.CardInfo;
import org.netbeans.modules.javacard.spi.capabilities.ClearEpromCapability;
import org.netbeans.modules.javacard.spi.capabilities.ContactedProtocol;
import org.netbeans.modules.javacard.spi.capabilities.DebugCapability;
import org.netbeans.modules.javacard.spi.capabilities.DeleteCapability;
import org.netbeans.modules.javacard.spi.capabilities.EpromFileCapability;
import org.netbeans.modules.javacard.spi.capabilities.PortKind;
import org.netbeans.modules.javacard.spi.capabilities.PortProvider;
import org.netbeans.modules.javacard.spi.capabilities.ProfileCapability;
import org.netbeans.modules.javacard.spi.capabilities.ResumeCapability;
import org.netbeans.modules.javacard.spi.capabilities.StartCapability;
import org.netbeans.modules.javacard.spi.capabilities.StopCapability;
import org.netbeans.modules.javacard.spi.capabilities.UrlCapability;
import org.netbeans.modules.propdos.PropertiesAdapter;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class RICard
extends BaseCard<CardProperties> {
    protected Process serverProcess;
    protected Process debugProxyProcess;
    private final DataObject dob;

    public RICard(DataObject dob, JavacardPlatform platform, String sysId) {
        super(platform, sysId, CardProperties.class);
        this.dob = dob;
        this.log("Created a card for " + dob.getPrimaryFile().getPath() + " " + platform + " as " + sysId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearProcessReferences() {
        RICard rICard = this;
        synchronized (rICard) {
            this.serverProcess = null;
            this.debugProxyProcess = null;
        }
    }

    protected CardProperties loadData() {
        PropertiesAdapter adap = (PropertiesAdapter)this.dob.getLookup().lookup(PropertiesAdapter.class);
        assert (adap != null);
        CardProperties props = new CardProperties(adap);
        this.log("Init props " + props);
        return props;
    }

    public DeleteCapability createDeleteCapability(CardProperties t) {
        return new Delete();
    }

    protected UrlCapability createApduSupport(CardProperties t) {
        return new Apdu();
    }

    protected CardContentsProvider createCardContentProvider(CardProperties t) {
        return new Contents();
    }

    protected AntTargetInterceptor createAntTargetInterceptor(CardProperties t) {
        return new Interceptor();
    }

    protected PortProvider createPortProvider(CardProperties t) {
        return new Ports();
    }

    protected CardInfo createCardInfo(CardProperties t) {
        return new Info();
    }

    protected StopCapability createStopCapability(CardProperties t) {
        return new Stop();
    }

    protected ProfileCapability createProfileCapability(CardProperties t) {
        return new Profile();
    }

    protected DebugCapability createDebugCapability(CardProperties t) {
        return new Debug();
    }

    protected StartCapability createStartCapability(CardProperties t) {
        return new Start();
    }

    protected ClearEpromCapability createClearEpromCapability(CardProperties t) {
        return new ClearEprom();
    }

    protected EpromFileCapability createEpromCapability(CardProperties t) {
        return new Eprom();
    }

    protected ResumeCapability createResumeCapability(CardProperties t) {
        return new Resume();
    }

    protected CardCustomizerProvider createCardCustomizerProvider(CardProperties t) {
        Lookup lkp = Lookups.forPath((String)("org-netbeans-modules-javacard-spi/kinds/" + this.getPlatform().getPlatformKind()));
        return (CardCustomizerProvider)lkp.lookup(CardCustomizerProvider.class);
    }

    public boolean isValid() {
        return super.isValid() && this.dob.isValid();
    }

    private String[] getDebugProxyCommandLine(Project project) {
        CardProperties p = (CardProperties)this.getCapability(CardProperties.class);
        File jar = AntClasspathClosureProvider.getTargetArtifact((Project)project);
        String classpathClosure = AntClasspathClosureProvider.getClasspathClosure((Project)project);
        classpathClosure = classpathClosure != null && !"".equals(classpathClosure) ? classpathClosure + File.pathSeparator + jar.getAbsolutePath() : jar.getAbsolutePath();
        return p.getDebugProxyCommandLine(this.getPlatform().toProperties(), classpathClosure);
    }

    private String[] getStartCommandLine(RunMode mode) {
        CardProperties p = (CardProperties)this.getCapability(CardProperties.class);
        assert (p != null);
        boolean forDebug = mode.isDebug();
        boolean suspend = forDebug ? false : p.isSuspend();
        Properties props = this.getPlatform().toProperties();
        return p.getRunCommandLine(props, forDebug, suspend, false);
    }

    private String[] getResumeCommandLine(RunMode mode) {
        CardProperties p = (CardProperties)this.getCapability(CardProperties.class);
        boolean debug = mode.isDebug();
        boolean suspend = debug ? false : p.isSuspend();
        return p.getRunCommandLine(this.getPlatform().toProperties(), debug, suspend, true);
    }

    private String getDisplayName() {
        return ((CardInfo)this.getCapability(CardInfo.class)).getDisplayName();
    }

    protected void onStateChanged(CardState old, CardState nue) {
        super.onStateChanged(old, nue);
        NodeRefresher refresh = (NodeRefresher)this.dob.getLookup().lookup(NodeRefresher.class);
        if (refresh != null) {
            refresh.refreshNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killProcesses() {
        Process dProc;
        Process sProc;
        RICard rICard = this;
        synchronized (rICard) {
            sProc = this.serverProcess;
            dProc = this.debugProxyProcess;
        }
        this.kill(sProc);
        this.kill(dProc);
    }

    private void kill(Process p) {
        if (p != null) {
            try {
                p.destroy();
            }
            catch (Exception e) {
                Logger.getLogger(RICard.class.getName()).log(Level.WARNING, "Could not destroy " + p + " for " + this.getSystemId(), e);
            }
        }
    }

    public void log(String toLog) {
        super.log(toLog);
    }

    public String toString() {
        return super.toString() + "[" + this.getSystemId() + "]";
    }

    public boolean equals(Object o) {
        return o != null && o.getClass() == RICard.class && ((RICard)((Object)o)).dob.equals(this.dob);
    }

    public int hashCode() {
        return this.dob.hashCode();
    }

    private final class Delete
    implements DeleteCapability {
        private Delete() {
        }

        public void delete() throws IOException {
            RICard.this.dob.delete();
        }
    }

    private static final class Profile
    implements ProfileCapability {
        private Profile() {
        }
    }

    private static final class Debug
    implements DebugCapability {
        private Debug() {
        }
    }

    private final class Contents
    implements CardContentsProvider {
        private Contents() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public XListModel getContents() {
            block27: {
                String url;
                assert (!EventQueue.isDispatchThread()) : "May not be called on event thread";
                UrlCapability urlCap = (UrlCapability)RICard.this.getCapability(UrlCapability.class);
                if (urlCap != null && (url = urlCap.getListURL()) != null) {
                    XListModel mdl;
                    InputStream in;
                    block26: {
                        in = null;
                        URL connectTo = new URL(url);
                        in = connectTo.openStream();
                        if (!Thread.interrupted()) break block26;
                        XListModel xListModel = null;
                        in.close();
                        return xListModel;
                    }
                    XListModel xListModel = mdl = new XListModel(in, ParseErrorHandler.NULL);
                    in.close();
                    return xListModel;
                    {
                        catch (IOException ioe) {
                            try {
                                try {
                                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(CardChildren.class, (String)"MSG_LOAD_FAILED", (Object)url));
                                    Logger.getLogger(CardChildren.class.getName()).log(Level.INFO, "Could not load children from xlist command for " + url, ioe);
                                    break block27;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    in.close();
                                }
                            }
                            catch (IOException iOException) {
                                break block27;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        try {
                            if (in != null) {
                                in.close();
                            }
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return null;
        }
    }

    private final class Eprom
    implements EpromFileCapability {
        private Eprom() {
        }

        public FileObject getEpromFile() {
            FileObject result = null;
            FileObject fld = Utils.sfsFolderForDeviceEepromsForPlatformNamed((String)RICard.this.getPlatform().getSystemName(), (boolean)false);
            if (fld != null) {
                result = fld.getFileObject(RICard.this.getSystemId(), "eprom");
            }
            return result;
        }
    }

    private final class ProcessLaunch
    implements Callable<Process> {
        private final String[] cmdline;
        private final ConditionImpl condition;
        private final boolean isServerProcess;
        private final CardState targetState;

        ProcessLaunch(String[] cmdline, CardState targetState, ConditionImpl condition, boolean isServerProcess) {
            this.cmdline = cmdline;
            this.condition = condition;
            this.isServerProcess = isServerProcess;
            this.targetState = targetState;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Process call() throws Exception {
            try {
                ProcessBuilder pb = new ProcessBuilder(this.cmdline);
                pb.directory(new File(System.getProperty("user.home")));
                pb.redirectErrorStream();
                pb.redirectErrorStream(true);
                Process p = pb.start();
                RICard.this.registerProcess(p);
                Object object = RICard.this;
                synchronized (object) {
                    if (this.isServerProcess) {
                        RICard.this.serverProcess = p;
                    } else {
                        RICard.this.debugProxyProcess = p;
                    }
                }
                object = p;
                return object;
            }
            finally {
                this.condition.countdown();
                RICard.this.setState(this.targetState);
            }
        }
    }

    private static class Interceptor
    implements AntTargetInterceptor {
        private Interceptor() {
        }

        public boolean onBeforeInvokeTarget(Project p, AntTarget target, Properties antProperties) {
            return true;
        }

        public void onAfterInvokeTarget(Project p, AntTarget target) {
        }
    }

    private class ClearEprom
    implements ClearEpromCapability,
    Runnable {
        private ClearEprom() {
        }

        public void clear() {
            RICard.this.rp.post((Runnable)this);
            RICard.this.removeCapability((ICardCapability)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                try {
                    if (RICard.this.getState().isRunning()) {
                        StopCapability stop = (StopCapability)RICard.this.getCapability(StopCapability.class);
                        stop.stop().awaitUninterruptibly();
                    }
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(ClearEprom.class, (String)"MSG_DELETING_EPROM_FILE", (Object)RICard.this.getDisplayName()));
                    EpromFileCapability epromFileCap = (EpromFileCapability)RICard.this.getCapability(EpromFileCapability.class);
                    FileObject epromFile = epromFileCap.getEpromFile();
                    assert (epromFile != null) : "ClearEprom should not be able to be invoked if no eprom file exists";
                    epromFile.delete();
                    ClearEprom clearEprom = this;
                    synchronized (clearEprom) {
                        this.notifyAll();
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    if (RICard.this.getCapability(ClearEpromCapability.class) != null) break block7;
                    RICard.this.addCapability((ICardCapability)this);
                }
            }
        }
    }

    private class Info
    implements CardInfo {
        private Info() {
        }

        public String getSystemId() {
            return RICard.this.getSystemId();
        }

        public String getDisplayName() {
            return RICard.this.dob.getNodeDelegate().getDisplayName();
        }

        public Image getIcon() {
            return RICard.this.dob.getNodeDelegate().getIcon(1);
        }

        public String getDescription() {
            return RICard.this.dob.getNodeDelegate().getShortDescription();
        }
    }

    private class Apdu
    implements UrlCapability {
        private Apdu() {
        }

        public ContactedProtocol getContactedProtocol() {
            String p = ((CardProperties)RICard.this.getCapability(CardProperties.class)).getContactedProtocol();
            return p == null ? null : ContactedProtocol.forString((String)p);
        }

        public String getURL() {
            PortProvider p = (PortProvider)RICard.this.getCapability(PortProvider.class);
            if (p == null || p.getHost() == null || p.getPort(PortKind.HTTP) <= 0) {
                return null;
            }
            return "http://" + p.getHost() + ":" + p.getPort(PortKind.HTTP) + "/";
        }

        public String getManagerURL() {
            String url = this.getURL();
            if (url != null && !url.endsWith("/")) {
                url = url + '/';
            }
            return url == null ? null : url + "cardmanager";
        }

        public String getListURL() {
            String mgrUrl = this.getManagerURL();
            if (mgrUrl == null) {
                return null;
            }
            if (!mgrUrl.endsWith("/")) {
                mgrUrl = mgrUrl + '/';
            }
            return mgrUrl + "xlist";
        }
    }

    private class Ports
    implements PortProvider {
        private Ports() {
        }

        public Set<Integer> getClaimedPorts() {
            return ((CardProperties)RICard.this.getCapability(CardProperties.class)).getPorts();
        }

        public Set<Integer> getPortsInUse() {
            CardState state = RICard.this.getState();
            if (state == CardState.RUNNING || state == CardState.RUNNING_IN_DEBUG_MODE) {
                Set<Integer> result = this.getClaimedPorts();
                if (state != CardState.RUNNING_IN_DEBUG_MODE) {
                    result.remove(Integer.parseInt(((CardProperties)RICard.this.getCapability(CardProperties.class)).getProxy2idePort()));
                }
                return result;
            }
            return Collections.emptySet();
        }

        public String getHost() {
            return ((CardProperties)RICard.this.getCapability(CardProperties.class)).getHost();
        }

        public int getPort(PortKind kind) {
            String port;
            CardProperties p = (CardProperties)RICard.this.getCapability(CardProperties.class);
            assert (p != null);
            switch (kind) {
                case HTTP: {
                    port = p.getHttpPort();
                    break;
                }
                case CONTACTED: {
                    port = p.getContactedPort();
                    break;
                }
                case CONTACTLESS: {
                    port = p.getContactlessPort();
                    break;
                }
                case DEBUG_IDE_TO_RUNTIME_PROXY: {
                    port = p.getProxy2cjcrePort();
                    break;
                }
                case DEBUG_RUNTIME_TO_IDE_PROXY: {
                    port = p.getProxy2idePort();
                    break;
                }
                default: {
                    throw new AssertionError((Object)("" + kind));
                }
            }
            return port == null ? -1 : Integer.parseInt(port);
        }
    }

    private class Resume
    implements ResumeCapability {
        private Resume() {
        }

        public Condition resume(RunMode mode) {
            if (!RICard.this.getState().isNotRunning()) {
                return new ConditionImpl();
            }
            String[] cls = RICard.this.getResumeCommandLine(mode);
            if (cls == null || cls.length <= 0) {
                return new ConditionImpl();
            }
            RICard.this.setState(CardState.BEFORE_RESUMING);
            final ConditionImpl result = new ConditionImpl(1, RICard.this);
            final List<String> cmd = Arrays.asList(cls);
            ExecutionDescriptor ed = new ExecutionDescriptor().controllable(true).frontWindow(true).preExecution((Runnable)new StateChange(CardState.RESUMING)).postExecution((Runnable)new StateChange(CardState.NOT_RUNNING));
            ExecutionService server = ExecutionService.newService((Callable)new Callable<Process>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Process call() throws Exception {
                    try {
                        ProcessBuilder pb = new ProcessBuilder(cmd);
                        pb.directory(new File(System.getProperty("user.home")));
                        pb.redirectErrorStream(true);
                        Process p = pb.start();
                        RICard.this.registerProcess(RICard.this.serverProcess);
                        RICard rICard = RICard.this;
                        synchronized (rICard) {
                            RICard.this.serverProcess = p;
                        }
                        RICard.this.setState(CardState.RUNNING);
                        result.countdown();
                        return p;
                    }
                    catch (Exception e) {
                        Logger.getLogger(RICard.class.getName()).log(Level.SEVERE, "Exception resuming " + RICard.this.getSystemId(), e);
                        RICard.this.killProcesses();
                        return null;
                    }
                }
            }, (ExecutionDescriptor)ed, (String)RICard.this.getDisplayName());
            server.run();
            return result;
        }
    }

    private final class StateChange
    implements Runnable {
        private final CardState newState;

        StateChange(CardState newState) {
            this.newState = newState;
        }

        @Override
        public void run() {
            RICard.this.log("StateChange set state to " + this.newState);
            RICard.this.setState(this.newState);
        }
    }

    private class Stopper
    implements Runnable {
        private final Process sProc;
        private final Process dProc;
        private final ConditionImpl condition;

        Stopper(Process sProc, Process dProc, ConditionImpl condition) {
            this.sProc = sProc;
            this.dProc = dProc;
            this.condition = condition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            block27: {
                String msg;
                RICard.this.log("Stop Runnable for " + (Object)((Object)RICard.this) + " trying to stop process");
                RICard.this.setState(CardState.STOPPING);
                try {
                    if (this.sProc == null) break block27;
                    RICard.this.log("Destroy process " + this.sProc);
                    this.sProc.destroy();
                    RICard.this.log("Wait for exit of " + this.sProc);
                    this.sProc.waitFor();
                    RICard.this.log(this.sProc + " exited");
                    if (this.sProc.exitValue() != 0) {
                        msg = NbBundle.getMessage(RICard.class, (String)"MSG_DONE_WITH_EXIT_CODE", (Object)RICard.this.getDisplayName(), (Object)this.sProc.exitValue());
                        StatusDisplayer.getDefault().setStatusText(msg);
                    }
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    block28: {
                        this.condition.countdown();
                        try {
                            if (this.dProc == null) break block28;
                            RICard.this.log("Destroy debug process " + this.dProc);
                            this.dProc.destroy();
                            RICard.this.log("Debug process destroyed");
                            this.dProc.waitFor();
                            RICard.this.log("Debug process exited");
                            if (this.dProc.exitValue() != 0) {
                                msg = NbBundle.getMessage(RICard.class, (String)"MSG_DEBUG_DONE_WITH_EXIT_CODE", (Object)RICard.this.getDisplayName(), (Object)this.sProc.exitValue());
                                StatusDisplayer.getDefault().setStatusText(msg);
                            }
                        }
                        catch (Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        finally {
                            this.condition.countdown();
                        }
                    }
                }
            }
            CardState state = RICard.this.getState();
            RICard.this.log("Enter busywait for state change to NOT_RUNNING.  Current state " + state);
            while ((state = RICard.this.getState()) != CardState.NOT_RUNNING) {
                try {
                    Thread.sleep(60L);
                    RICard.this.log("Busywait loop, state " + state);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            RICard.this.log("Finishing stop - clearing process references " + this.sProc + " and " + this.dProc);
            RICard rICard = RICard.this;
            synchronized (rICard) {
                if (RICard.this.serverProcess == this.sProc) {
                    RICard.this.serverProcess = null;
                }
                if (RICard.this.debugProxyProcess == this.dProc) {
                    RICard.this.debugProxyProcess = null;
                }
            }
            RICard.this.log("Completing countdown to notify waiters");
            this.condition.countdown();
        }
    }

    private class Stop
    implements StopCapability {
        private Stop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Condition stop() {
            Process dProc;
            Process sProc;
            RICard.this.log((Object)((Object)RICard.this) + " stop");
            if (RICard.this.getState().isNotRunning()) {
                RICard.this.log("Not actually running, return dummy condition");
                return new ConditionImpl();
            }
            RICard.this.setState(CardState.BEFORE_STOPPING);
            RICard rICard = RICard.this;
            synchronized (rICard) {
                sProc = RICard.this.serverProcess;
                dProc = RICard.this.debugProxyProcess;
            }
            if (sProc == null && dProc == null) {
                RICard.this.setState(CardState.NOT_RUNNING);
                return new ConditionImpl();
            }
            int countdown = 1 + (sProc == null ? 1 : 0) + (dProc == null ? 1 : 0);
            ConditionImpl result = new ConditionImpl(countdown, RICard.this);
            Stopper stopRunnable = new Stopper(sProc, dProc, result);
            RICard.this.log("Posting stop runnable");
            RICard.this.rp.post((Runnable)stopRunnable, 0, 10);
            return result;
        }
    }

    private final class Starter
    implements Runnable {
        private final ConditionImpl c;
        private final RunMode mode;
        private final Project project;

        private Starter(ConditionImpl c, RunMode mode, Project project) {
            this.c = c;
            this.mode = mode;
            this.project = project;
        }

        @Override
        public void run() {
            RICard.this.setState(CardState.STARTING);
            try {
                boolean debug = this.mode.isDebug();
                String[] cls = RICard.this.getStartCommandLine(this.mode);
                RICard.this.log((Object)((Object)RICard.this) + " to start command " + Arrays.asList(cls));
                if (cls == null || cls.length <= 0) {
                    throw new IllegalStateException("0 length start command line for " + RICard.this.getSystemId());
                }
                ExecutionDescriptor ed = new ExecutionDescriptor().controllable(true).frontWindow(true).preExecution((Runnable)new StateChange(CardState.STARTING)).postExecution((Runnable)new StateChange(CardState.NOT_RUNNING));
                ProcessLaunch launcher = new ProcessLaunch(cls, debug ? CardState.RUNNING_IN_DEBUG_MODE : CardState.RUNNING, this.c, true);
                ExecutionService exeService = ExecutionService.newService((Callable)launcher, (ExecutionDescriptor)ed, (String)RICard.this.getDisplayName());
                RICard.this.log("Starting process for " + (Object)((Object)RICard.this));
                exeService.run();
                if (debug) {
                    String[] cmdLine = RICard.this.getDebugProxyCommandLine(this.project);
                    RICard.this.log("Will start debug process " + Arrays.asList(cmdLine));
                    if (cls.length <= 0) {
                        throw new IllegalStateException("Debug command line empty");
                    }
                    ed = new ExecutionDescriptor().controllable(true).frontWindow(true);
                    ProcessLaunch debugLaunch = new ProcessLaunch(cmdLine, CardState.RUNNING_IN_DEBUG_MODE, this.c, false);
                    ExecutionService debugService = ExecutionService.newService((Callable)debugLaunch, (ExecutionDescriptor)ed, (String)NbBundle.getMessage(RICard.class, (String)"DEBUG_TAB_NAME", (Object)RICard.this.getDisplayName()));
                    RICard.this.log("Starting debug process");
                    debugService.run();
                }
            }
            catch (Exception e) {
                Logger.getLogger(RICard.class.getName()).log(Level.SEVERE, "Problem starting " + RICard.this.getSystemId(), e);
                RICard.this.killProcesses();
                RICard.this.setState(CardState.NOT_RUNNING);
                this.c.signalAll();
            }
        }
    }

    private class Start
    implements StartCapability {
        private Start() {
        }

        public Condition start(RunMode mode, Project project) {
            boolean debug;
            RICard.this.log((Object)((Object)RICard.this) + " start " + mode);
            if (project == null && mode != RunMode.RUN) {
                throw new NullPointerException("Project parameter required for DEBUG/PROFILE run modes");
            }
            boolean bl = debug = mode == RunMode.DEBUG;
            if (!RICard.this.getState().isNotRunning()) {
                RICard.this.log("Already running, return dummy condition");
                return new ConditionImpl();
            }
            ConditionImpl c = new ConditionImpl(debug ? 2 : 1, RICard.this);
            RICard.this.setState(CardState.BEFORE_STARTING);
            RICard.this.rp.post((Runnable)new Starter(c, mode, project));
            return c;
        }
    }
}

