/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.rmi;

import java.rmi.AccessException;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class RegistryManager {
    public static Registry ensureRegistry(int port) throws RemoteException {
        Registry reg = RegistryManager.findRegistry(port);
        if (reg == null) {
            reg = LocateRegistry.createRegistry(port);
        }
        return reg;
    }

    public static Registry ensureRegistry() throws RemoteException {
        return RegistryManager.ensureRegistry(1099);
    }

    public static boolean registryAvailable(int port) throws RemoteException, AccessException {
        try {
            Registry reg = LocateRegistry.getRegistry(port);
            reg.list();
            return true;
        }
        catch (ConnectException e) {
            return false;
        }
    }

    public static boolean registryAvailable() throws RemoteException, AccessException {
        return RegistryManager.registryAvailable(1099);
    }

    public static Registry findRegistry(int port) throws RemoteException, AccessException {
        if (!RegistryManager.registryAvailable(port)) {
            return null;
        }
        return LocateRegistry.getRegistry(port);
    }

    public static Registry findRegistry() throws RemoteException, AccessException {
        return RegistryManager.findRegistry(1099);
    }
}

