/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler.jarfs;

import com.google.common.primitives.Longs;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001eBL\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0017\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ:\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00032\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00130\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u0018J*\u0010\u0019\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00130\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u001aJ2\u0010\u001b\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u0002H\u00130\b\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0007\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/LargeDynamicMappedBuffer;", "", "dataSize", "", "mapBuffer", "Lkotlin/Function2;", "Ljava/nio/MappedByteBuffer;", "unmapBuffer", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "defaultByteOrder", "Ljava/nio/ByteOrder;", "<init>", "(JLkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Ljava/nio/ByteOrder;)V", "currentMappedBuffer", "currentStart", "currentEnd", "withMappedRange", "R", "start", "end", "body", "Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/LargeDynamicMappedBuffer$Mapping;", "(JJLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withMappedTail", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "withMappedRangeFrom", "(JLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "unmap", "Mapping", "cli-base"})
public final class LargeDynamicMappedBuffer {
    private final long dataSize;
    @NotNull
    private final Function2<Long, Long, MappedByteBuffer> mapBuffer;
    @NotNull
    private final Function1<MappedByteBuffer, Unit> unmapBuffer;
    @NotNull
    private final ByteOrder defaultByteOrder;
    @Nullable
    private MappedByteBuffer currentMappedBuffer;
    private long currentStart;
    private long currentEnd;

    public LargeDynamicMappedBuffer(long dataSize, @NotNull Function2<? super Long, ? super Long, ? extends MappedByteBuffer> mapBuffer, @NotNull Function1<? super MappedByteBuffer, Unit> unmapBuffer, @NotNull ByteOrder defaultByteOrder) {
        Intrinsics.checkNotNullParameter(mapBuffer, "mapBuffer");
        Intrinsics.checkNotNullParameter(unmapBuffer, "unmapBuffer");
        Intrinsics.checkNotNullParameter(defaultByteOrder, "defaultByteOrder");
        this.dataSize = dataSize;
        this.mapBuffer = mapBuffer;
        this.unmapBuffer = unmapBuffer;
        this.defaultByteOrder = defaultByteOrder;
    }

    public /* synthetic */ LargeDynamicMappedBuffer(long l, Function2 function2, Function1 function1, ByteOrder byteOrder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            byteOrder = ByteOrder.nativeOrder();
        }
        this(l, function2, function1, byteOrder);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized <R> R withMappedRange(long start, long end, @NotNull Function1<? super Mapping, ? extends R> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        long l = start + 1L;
        if (!((end <= this.dataSize ? l <= end : false) && end - start <= Integer.MAX_VALUE)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        long currentSize = Integer.MAX_VALUE;
        if (this.currentMappedBuffer == null || this.currentStart > start || this.currentEnd < end) {
            void it;
            MappedByteBuffer mappedByteBuffer;
            if (this.dataSize <= Integer.MAX_VALUE) {
                this.currentStart = 0L;
                this.currentEnd = this.dataSize;
                currentSize = this.dataSize;
            } else if (start + (long)Integer.MAX_VALUE > this.dataSize) {
                this.currentStart = this.dataSize - (long)Integer.MAX_VALUE;
                this.currentEnd = this.dataSize;
            } else {
                this.currentStart = start;
                this.currentEnd = start + (long)Integer.MAX_VALUE;
            }
            this.unmap();
            MappedByteBuffer mappedByteBuffer2 = mappedByteBuffer = this.mapBuffer.invoke(this.currentStart, currentSize);
            LargeDynamicMappedBuffer largeDynamicMappedBuffer = this;
            boolean bl = false;
            it.order(this.defaultByteOrder);
            largeDynamicMappedBuffer.currentMappedBuffer = mappedByteBuffer;
        }
        MappedByteBuffer mappedByteBuffer = this.currentMappedBuffer;
        Intrinsics.checkNotNull(mappedByteBuffer);
        MappedByteBuffer buffer = mappedByteBuffer;
        if (!(this.currentStart <= start && this.currentEnd >= end && start - this.currentStart < Integer.MAX_VALUE)) {
            String string3 = "Failed requirement.";
            throw new IllegalArgumentException(string3.toString());
        }
        buffer.position((int)(start - this.currentStart));
        return body2.invoke(new Mapping(buffer, buffer.position()));
    }

    public final <R> R withMappedTail(@NotNull Function1<? super Mapping, ? extends R> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        long[] lArray = new long[]{this.dataSize, Integer.MAX_VALUE};
        long size = Longs.min(lArray);
        return this.withMappedRange(this.dataSize - size, this.dataSize, body2);
    }

    public final <R> R withMappedRangeFrom(long start, @NotNull Function1<? super Mapping, ? extends R> body2) {
        Intrinsics.checkNotNullParameter(body2, "body");
        if (!(start < this.dataSize)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        long[] lArray = new long[]{this.dataSize - start, Integer.MAX_VALUE};
        long size = Longs.min(lArray);
        return this.withMappedRange(start, start + size, body2);
    }

    public final void unmap() {
        MappedByteBuffer mappedByteBuffer = this.currentMappedBuffer;
        if (mappedByteBuffer != null) {
            this.unmapBuffer.invoke(mappedByteBuffer);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0005J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005J\u0006\u0010\u0015\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/jarfs/LargeDynamicMappedBuffer$Mapping;", "", "buffer", "Ljava/nio/MappedByteBuffer;", "baseOffset", "", "<init>", "(Ljava/nio/MappedByteBuffer;I)V", "order", "", "bo", "Ljava/nio/ByteOrder;", "getInt", "offset", "getLong", "", "getShort", "", "getBytes", "", "length", "endOffset", "cli-base"})
    public static final class Mapping {
        @NotNull
        private final MappedByteBuffer buffer;
        private final int baseOffset;

        public Mapping(@NotNull MappedByteBuffer buffer, int baseOffset) {
            Intrinsics.checkNotNullParameter(buffer, "buffer");
            this.buffer = buffer;
            this.baseOffset = baseOffset;
        }

        public final void order(@NotNull ByteOrder bo) {
            Intrinsics.checkNotNullParameter(bo, "bo");
            this.buffer.order(bo);
        }

        public final int getInt(int offset2) {
            return this.buffer.getInt(this.baseOffset + offset2);
        }

        public final long getLong(int offset2) {
            return this.buffer.getLong(this.baseOffset + offset2);
        }

        public final short getShort(int offset2) {
            return this.buffer.getShort(this.baseOffset + offset2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final byte[] getBytes(int offset2, int length) {
            byte[] bytes = new byte[length];
            this.buffer.position(this.baseOffset + offset2);
            try {
                this.buffer.get(bytes, 0, length);
                byte[] byArray = bytes;
                return byArray;
            }
            finally {
                this.buffer.position(this.baseOffset);
            }
        }

        public final int endOffset() {
            return this.buffer.capacity() - this.baseOffset;
        }
    }
}

