#    
#    Copyright (C) 2002-2003 Paul Pelzl
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

# audiostatus.py
#
# manages a display area for showing the audio status during the game.
#


import pygame, initialize

class AudioStatus:
   def __init__(self, audio, screen):
      self.audio     = audio
      self.screen    = screen
      self.notesRect = pygame.Rect( 40, 410,
         initialize.notesOnRect.width, initialize.notesOnRect.height)
      self.megaRect  = pygame.Rect( 120, 410,
         initialize.megaOnRect.width, initialize.megaOnRect.height)

   def draw(self):
      r = initialize.notesOnImage.get_rect()
      notesEraser = pygame.Surface((r.width, r.height))
      notesEraser.fill((1,1,1))
      r = initialize.megaOnImage.get_rect()
      megaEraser = pygame.Surface((r.width, r.height))
      megaEraser.fill((1,1,1))
      if self.audio.Capable:
         if self.audio.musicEnabled:
            #self.screen.blit(notesEraser, self.notesRect)
            self.screen.blit(initialize.notesOnImage, self.notesRect)
         else:
            #self.screen.blit(notesEraser, self.notesRect)
            self.screen.blit(initialize.notesOffImage, self.notesRect)

         if self.audio.soundEnabled:
            #self.screen.blit(megaEraser, self.megaRect)
            self.screen.blit(initialize.megaOnImage, self.megaRect)
         else:
            #self.screen.blit(megaEraser, self.megaRect)
            self.screen.blit(initialize.megaOffImage, self.megaRect)

      pygame.display.flip()


# arch-tag: audio status display
