/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.compression;

public class MoveToFrontCoder {
    int[] symbols;
    private int numSymbols;

    public MoveToFrontCoder(int numberOfSymbols) {
        this.numSymbols = numberOfSymbols;
        this.symbols = new int[numberOfSymbols];
        for (int i = 0; i < numberOfSymbols; ++i) {
            this.symbols[i] = i;
        }
    }

    public int encode(int symbol) {
        if (symbol < 0) {
            throw new IllegalArgumentException("symbol must be positive.");
        }
        if (symbol > this.numSymbols) {
            throw new IllegalArgumentException(String.format("You have only %d symbols, symbol value is too large %d.", this.numSymbols, symbol));
        }
        int carry = -1;
        for (int i = 0; i < this.numSymbols; ++i) {
            int tmp;
            if (this.symbols[i] != symbol) {
                tmp = this.symbols[i];
                if (carry != -1) {
                    this.symbols[i] = carry;
                }
            } else {
                if (carry != -1) {
                    this.symbols[i] = carry;
                }
                this.symbols[0] = symbol;
                return i;
            }
            carry = tmp;
        }
        throw new IllegalArgumentException(String.format("Symbol %d must be found.", symbol));
    }
}

