/*
 * Copyright 2014 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA:
//  cldrVersion=25
//  date=$Date: 2014-02-25 22:16:49 +0100 (Tue, 25 Feb 2014) $
//  number=$Revision: 9791 $
//  type=root

/**
 * Localized names for the "ia" locale.
 */
public class LocalizedNamesImpl_ia extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AD",
        "AF",
        "ZA",
        "AI",
        "AL",
        "DZ",
        "AO",
        "AQ",
        "AG",
        "AN",
        "SA",
        "AR",
        "AM",
        "AU",
        "AT",
        "AW",
        "AX",
        "AZ",
        "BS",
        "BD",
        "BB",
        "BE",
        "BJ",
        "BH",
        "BT",
        "BY",
        "MM",
        "BL",
        "BM",
        "BN",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "BG",
        "BF",
        "BI",
        "BZ",
        "KH",
        "CM",
        "CA",
        "CC",
        "CD",
        "CL",
        "CN",
        "CI",
        "CO",
        "KM",
        "CG",
        "KP",
        "KR",
        "CP",
        "CR",
        "HR",
        "CU",
        "CV",
        "CW",
        "CY",
        "DK",
        "DG",
        "DJ",
        "DM",
        "EA",
        "EC",
        "EG",
        "AE",
        "ER",
        "ES",
        "EE",
        "ET",
        "EU",
        "FI",
        "FJ",
        "FK",
        "FR",
        "GA",
        "GM",
        "GD",
        "GE",
        "DE",
        "GG",
        "GH",
        "GI",
        "GP",
        "GR",
        "GL",
        "GS",
        "GT",
        "GU",
        "GN",
        "GW",
        "GQ",
        "GF",
        "GY",
        "HT",
        "HK",
        "HM",
        "HN",
        "HU",
        "IC",
        "IM",
        "IN",
        "ID",
        "BV",
        "CX",
        "NF",
        "CK",
        "KY",
        "FO",
        "MP",
        "MH",
        "SB",
        "TC",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JP",
        "JE",
        "JM",
        "JO",
        "KZ",
        "KE",
        "KG",
        "KI",
        "KW",
        "LA",
        "LS",
        "LV",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "MW",
        "MY",
        "ML",
        "MA",
        "MR",
        "MC",
        "ME",
        "MX",
        "MF",
        "FM",
        "MO",
        "MD",
        "MN",
        "MZ",
        "MQ",
        "MS",
        "MT",
        "MU",
        "MV",
        "NA",
        "NL",
        "NP",
        "NI",
        "NE",
        "NG",
        "NO",
        "NC",
        "NZ",
        "NR",
        "NU",
        "OM",
        "PA",
        "PK",
        "PG",
        "PY",
        "PE",
        "PH",
        "PM",
        "PN",
        "PL",
        "PF",
        "PT",
        "PR",
        "PS",
        "PW",
        "QA",
        "QO",
        "RE",
        "GB",
        "CF",
        "DO",
        "CZ",
        "RO",
        "RS",
        "RU",
        "RW",
        "EH",
        "WS",
        "AS",
        "KN",
        "LC",
        "VC",
        "SM",
        "SN",
        "SC",
        "SG",
        "SH",
        "SL",
        "SJ",
        "SK",
        "SI",
        "SO",
        "LK",
        "ST",
        "US",
        "SD",
        "SS",
        "CH",
        "SR",
        "SV",
        "SE",
        "SZ",
        "SX",
        "SY",
        "TA",
        "TJ",
        "TW",
        "TZ",
        "TD",
        "IO",
        "TF",
        "TH",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TN",
        "TR",
        "TM",
        "TV",
        "UG",
        "UA",
        "UM",
        "UY",
        "UZ",
        "VA",
        "VU",
        "VE",
        "VG",
        "VI",
        "VN",
        "WF",
        "XK",
        "YE",
        "YT",
        "ZM",
        "ZW",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AE", "Emiratos Arabe Unite");
    namesMap.put("AG", "Antigua e Barbuda");
    namesMap.put("AN", "Antillas nederlandese");
    namesMap.put("AS", "Samoa american");
    namesMap.put("AZ", "Azerbaidzhan");
    namesMap.put("BA", "Bosnia e Herzegovina");
    namesMap.put("BE", "Belgica");
    namesMap.put("BR", "Brasil");
    namesMap.put("BV", "Insula de Bouvet");
    namesMap.put("BY", "Bielorussia");
    namesMap.put("CF", "Republica African Central");
    namesMap.put("CG", "Congo");
    namesMap.put("CH", "Suissa");
    namesMap.put("CK", "Insulas Cook");
    namesMap.put("CM", "Camerun");
    namesMap.put("CX", "Insula de Natal");
    namesMap.put("CY", "Cypro");
    namesMap.put("CZ", "Republica Tchec");
    namesMap.put("DE", "Germania");
    namesMap.put("DK", "Danmark");
    namesMap.put("DO", "Republica Dominican");
    namesMap.put("EG", "Egypto");
    namesMap.put("EH", "Sahara occidental");
    namesMap.put("ES", "Espania");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FO", "Insulas Feroe");
    namesMap.put("FR", "Francia");
    namesMap.put("GB", "Regno Unite");
    namesMap.put("GF", "Guyana francese");
    namesMap.put("GL", "Groenlandia");
    namesMap.put("GQ", "Guinea equatorial");
    namesMap.put("GR", "Grecia");
    namesMap.put("HU", "Hungaria");
    namesMap.put("IE", "Irlanda");
    namesMap.put("IO", "Territorio oceanic britanno-indian");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Islanda");
    namesMap.put("IT", "Italia");
    namesMap.put("JO", "Jordania");
    namesMap.put("JP", "Japon");
    namesMap.put("KG", "Kirghizistan");
    namesMap.put("KH", "Cambodgia");
    namesMap.put("KN", "Sancte Christophoro e Nevis");
    namesMap.put("KP", "Corea del Nord");
    namesMap.put("KR", "Corea del Sud");
    namesMap.put("KY", "Insulas de Caiman");
    namesMap.put("LB", "Libano");
    namesMap.put("LC", "Sancte Lucia");
    namesMap.put("LT", "Lituania");
    namesMap.put("LV", "Lettonia");
    namesMap.put("MA", "Marocco");
    namesMap.put("MD", "Moldavia");
    namesMap.put("MH", "Insulas Marshall");
    namesMap.put("MK", "Macedonia");
    namesMap.put("MM", "Birmania/Myanmar");
    namesMap.put("MP", "Insulas Marianna del Nord");
    namesMap.put("NC", "Nove Caledonia");
    namesMap.put("NF", "Insula Norfolk");
    namesMap.put("NL", "Nederlandia");
    namesMap.put("NO", "Norvegia");
    namesMap.put("NZ", "Nove Zelanda");
    namesMap.put("PF", "Polynesia francese");
    namesMap.put("PG", "Papua Nove Guinea");
    namesMap.put("PH", "Philippinas");
    namesMap.put("PL", "Polonia");
    namesMap.put("RW", "Ruanda");
    namesMap.put("SA", "Arabia Saudita");
    namesMap.put("SB", "Insulas Solomon");
    namesMap.put("SE", "Svedia");
    namesMap.put("SK", "Slovachia");
    namesMap.put("SS", "Sudan del Sud");
    namesMap.put("SZ", "Swazilandia");
    namesMap.put("TC", "Insulas Turcos e Caicos");
    namesMap.put("TD", "Tchad");
    namesMap.put("TF", "Territorios meridional francese");
    namesMap.put("TH", "Thailandia");
    namesMap.put("TJ", "Tadzhikistan");
    namesMap.put("TL", "Timor del Est");
    namesMap.put("TO", "tonga");
    namesMap.put("TR", "Turchia");
    namesMap.put("TT", "Trinidad e Tobago");
    namesMap.put("UA", "Ukraina");
    namesMap.put("US", "Statos Unite");
    namesMap.put("VC", "Sancte Vincente e le Grenadinas");
    namesMap.put("ZA", "Africa del Sud");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AE": "Emiratos Arabe Unite",
        "AG": "Antigua e Barbuda",
        "AN": "Antillas nederlandese",
        "AS": "Samoa american",
        "AZ": "Azerbaidzhan",
        "BA": "Bosnia e Herzegovina",
        "BE": "Belgica",
        "BR": "Brasil",
        "BV": "Insula de Bouvet",
        "BY": "Bielorussia",
        "CF": "Republica African Central",
        "CG": "Congo",
        "CH": "Suissa",
        "CK": "Insulas Cook",
        "CM": "Camerun",
        "CX": "Insula de Natal",
        "CY": "Cypro",
        "CZ": "Republica Tchec",
        "DE": "Germania",
        "DK": "Danmark",
        "DO": "Republica Dominican",
        "EG": "Egypto",
        "EH": "Sahara occidental",
        "ES": "Espania",
        "FI": "Finlandia",
        "FO": "Insulas Feroe",
        "FR": "Francia",
        "GB": "Regno Unite",
        "GF": "Guyana francese",
        "GL": "Groenlandia",
        "GQ": "Guinea equatorial",
        "GR": "Grecia",
        "HU": "Hungaria",
        "IE": "Irlanda",
        "IO": "Territorio oceanic britanno-indian",
        "IQ": "Irak",
        "IS": "Islanda",
        "IT": "Italia",
        "JO": "Jordania",
        "JP": "Japon",
        "KG": "Kirghizistan",
        "KH": "Cambodgia",
        "KN": "Sancte Christophoro e Nevis",
        "KP": "Corea del Nord",
        "KR": "Corea del Sud",
        "KY": "Insulas de Caiman",
        "LB": "Libano",
        "LC": "Sancte Lucia",
        "LT": "Lituania",
        "LV": "Lettonia",
        "MA": "Marocco",
        "MD": "Moldavia",
        "MH": "Insulas Marshall",
        "MK": "Macedonia",
        "MM": "Birmania/Myanmar",
        "MP": "Insulas Marianna del Nord",
        "NC": "Nove Caledonia",
        "NF": "Insula Norfolk",
        "NL": "Nederlandia",
        "NO": "Norvegia",
        "NZ": "Nove Zelanda",
        "PF": "Polynesia francese",
        "PG": "Papua Nove Guinea",
        "PH": "Philippinas",
        "PL": "Polonia",
        "RW": "Ruanda",
        "SA": "Arabia Saudita",
        "SB": "Insulas Solomon",
        "SE": "Svedia",
        "SK": "Slovachia",
        "SS": "Sudan del Sud",
        "SZ": "Swazilandia",
        "TC": "Insulas Turcos e Caicos",
        "TD": "Tchad",
        "TF": "Territorios meridional francese",
        "TH": "Thailandia",
        "TJ": "Tadzhikistan",
        "TL": "Timor del Est",
        "TO": "tonga",
        "TR": "Turchia",
        "TT": "Trinidad e Tobago",
        "UA": "Ukraina",
        "US": "Statos Unite",
        "VC": "Sancte Vincente e le Grenadinas",
        "ZA": "Africa del Sud"
    };
  }-*/;
}
