/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.sf.gogui.gui.GuiTextPane;
import net.sf.gogui.gui.GuiUtils;

public class TextViewer
extends JDialog {
    private static final long serialVersionUID = 0L;
    private GuiTextPane m_textPane;
    private Listener m_listener;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TextViewer(Frame frame, String string, String string2, boolean bl, Listener listener, boolean bl2) {
        super(frame, string);
        this.initialize(string2, bl, listener, bl2);
    }

    public TextViewer(Dialog dialog, String string, String string2, boolean bl, Listener listener, boolean bl2) {
        super(dialog, string);
        this.initialize(string2, bl, listener, bl2);
    }

    private void doSyntaxHighlight() {
        this.m_textPane.addStyle("title", null, null, true);
        this.m_textPane.addStyle("point", new Color(0.25f, 0.5f, 0.7f));
        this.m_textPane.addStyle("number", new Color(0.0f, 0.54f, 0.0f));
        this.m_textPane.addStyle("const", new Color(0.8f, 0.0f, 0.0f));
        this.m_textPane.addStyle("color", new Color(0.54f, 0.0f, 0.54f));
        this.m_textPane.get().setEditable(true);
        this.highlight("number", "\\b-?\\d+\\.?\\d*([Ee][+-]\\d+)?\\b");
        this.highlight("const", "\\b[A-Z_][A-Z_]+[A-Z]\\b");
        this.highlight("color", "\\b([Bb][Ll][Aa][Cc][Kk]|[Ww][Hh][Ii][Tt][Ee])\\b");
        this.highlight("point", "\\b([Pp][Aa][Ss][Ss]|[A-Ta-t](1\\d|[1-9]))\\b");
        this.highlight("title", "^\\S+:(\\s|$)");
        this.m_textPane.get().setEditable(false);
    }

    private void highlight(String string, String string2) {
        block3: {
            Document document = this.m_textPane.getDocument();
            Pattern pattern = Pattern.compile(string2, 8);
            try {
                String string3 = document.getText(0, document.getLength());
                Matcher matcher = pattern.matcher(string3);
                while (matcher.find()) {
                    int n = matcher.start();
                    int n2 = matcher.end();
                    this.m_textPane.setStyle(n, n2 - n, string);
                }
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    private void initialize(String string, boolean bl, Listener listener, boolean bl2) {
        JPanel jPanel;
        block5: {
            this.m_listener = listener;
            jPanel = new JPanel(new BorderLayout());
            Container container = this.getContentPane();
            container.add((Component)jPanel, "Center");
            this.m_textPane = new GuiTextPane(bl2);
            GuiUtils.setMonospacedFont(this.m_textPane.get());
            Document document = this.m_textPane.getDocument();
            while (string.charAt(string.length() - 1) == '\n') {
                string = string.substring(0, string.length() - 1);
            }
            try {
                document.insertString(0, string, null);
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
        JScrollPane jScrollPane = new JScrollPane(this.m_textPane.get());
        jPanel.add((Component)jScrollPane, "Center");
        this.setDefaultCloseOperation(2);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 27) {
                    TextViewer.this.dispose();
                }
            }
        };
        this.m_textPane.get().addKeyListener(keyAdapter);
        CaretListener caretListener = new CaretListener(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void caretUpdate(CaretEvent caretEvent) {
                block4: {
                    if (TextViewer.this.m_listener == null) {
                        return;
                    }
                    int n = TextViewer.this.m_textPane.get().getSelectionStart();
                    int n2 = TextViewer.this.m_textPane.get().getSelectionEnd();
                    Document document = TextViewer.this.m_textPane.getDocument();
                    try {
                        if (n == n2) {
                            String string = document.getText(0, document.getLength());
                            TextViewer.this.m_listener.textSelected(string);
                            return;
                        }
                        String string = document.getText(n, n2 - n);
                        TextViewer.this.m_listener.textSelected(string);
                    }
                    catch (BadLocationException badLocationException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
            }

            static {
                $assertionsDisabled = !(class$net$sf$gogui$gui$TextViewer == null ? (class$net$sf$gogui$gui$TextViewer = TextViewer.class$("net.sf.gogui.gui.TextViewer")) : class$net$sf$gogui$gui$TextViewer).desiredAssertionStatus();
            }
        };
        this.m_textPane.get().addCaretListener(caretListener);
        if (bl) {
            this.doSyntaxHighlight();
        }
        this.m_textPane.get().setCaretPosition(0);
        this.m_textPane.get().setEditable(false);
        this.pack();
        Dimension dimension = this.getSize();
        dimension.width = (int)((double)dimension.width * 1.1);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)(0.9 * (double)dimension2.height);
        int n2 = (int)(0.9 * (double)dimension2.width);
        if (dimension.height > n || dimension.width > n2) {
            dimension.width = Math.min(dimension.width, n2);
            dimension.height = Math.min(dimension.height, n);
        }
        this.setSize(dimension);
    }

    static {
        $assertionsDisabled = !TextViewer.class.desiredAssertionStatus();
    }

    public static interface Listener {
        public void textSelected(String var1);
    }
}

