/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.go;

import java.io.PrintStream;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;

public final class BoardUtils {
    public static final int NUMBER_ROTATIONS = 8;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void print(Board board, PrintStream printStream, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(1024);
        int n = board.getSize();
        BoardUtils.printXCoords(n, stringBuffer);
        for (int i = n - 1; i >= 0; --i) {
            BoardUtils.printYCoord(i, stringBuffer);
            stringBuffer.append(' ');
            for (int j = 0; j < n; ++j) {
                GoPoint goPoint = GoPoint.get(j, i);
                GoColor goColor = board.getColor(goPoint);
                if (goColor == GoColor.BLACK) {
                    stringBuffer.append("@ ");
                    continue;
                }
                if (goColor == GoColor.WHITE) {
                    stringBuffer.append("O ");
                    continue;
                }
                if (board.isHandicap(goPoint)) {
                    stringBuffer.append("+ ");
                    continue;
                }
                stringBuffer.append(". ");
            }
            BoardUtils.printYCoord(i, stringBuffer);
            if (bl) {
                BoardUtils.printGameInfo(board, stringBuffer, i);
            }
            stringBuffer.append('\n');
        }
        BoardUtils.printXCoords(n, stringBuffer);
        if (!bl) {
            BoardUtils.printToMove(board, stringBuffer);
            stringBuffer.append('\n');
        }
        printStream.print(stringBuffer);
    }

    public static GoPoint rotate(int n, GoPoint goPoint, int n2) {
        if (!$assertionsDisabled && n >= 8) {
            throw new AssertionError();
        }
        if (goPoint == null) {
            return null;
        }
        int n3 = goPoint.getX();
        int n4 = goPoint.getY();
        switch (n) {
            case 0: {
                return GoPoint.get(n3, n4);
            }
            case 1: {
                return GoPoint.get(n2 - n3 - 1, n4);
            }
            case 2: {
                return GoPoint.get(n3, n2 - n4 - 1);
            }
            case 3: {
                return GoPoint.get(n4, n3);
            }
            case 4: {
                return GoPoint.get(n2 - n4 - 1, n3);
            }
            case 5: {
                return GoPoint.get(n4, n2 - n3 - 1);
            }
            case 6: {
                return GoPoint.get(n2 - n3 - 1, n2 - n4 - 1);
            }
            case 7: {
                return GoPoint.get(n2 - n4 - 1, n2 - n3 - 1);
            }
        }
        return GoPoint.get(n3, n4);
    }

    private BoardUtils() {
    }

    private static void printGameInfo(Board board, StringBuffer stringBuffer, int n) {
        int n2 = board.getSize();
        if (n == n2 - 1) {
            stringBuffer.append("  ");
            BoardUtils.printToMove(board, stringBuffer);
        } else if (n == n2 - 2) {
            stringBuffer.append("  Prisoners: B ");
            stringBuffer.append(board.getCapturedB());
            stringBuffer.append("  W ");
            stringBuffer.append(board.getCapturedW());
        } else {
            int n3 = board.getMoveNumber() - n - 1;
            if (n3 >= 0) {
                Move move = board.getMove(n3);
                stringBuffer.append("  ");
                stringBuffer.append(n3 + 1);
                stringBuffer.append(' ');
                stringBuffer.append(move.getColor() == GoColor.BLACK ? "B " : "W ");
                stringBuffer.append(GoPoint.toString(move.getPoint()));
            }
        }
    }

    private static void printToMove(Board board, StringBuffer stringBuffer) {
        stringBuffer.append(board.getToMove() == GoColor.BLACK ? "Black" : "White");
        stringBuffer.append(" to move");
    }

    private static void printXCoords(int n, StringBuffer stringBuffer) {
        stringBuffer.append("   ");
        int n2 = 0;
        char c = 'A';
        while (n2 < n) {
            if (c == 'I') {
                c = (char)(c + 1);
            }
            stringBuffer.append(c);
            stringBuffer.append(' ');
            ++n2;
            c = (char)(c + '\u0001');
        }
        stringBuffer.append('\n');
    }

    private static void printYCoord(int n, StringBuffer stringBuffer) {
        String string = Integer.toString(n + 1);
        stringBuffer.append(string);
        if (string.length() == 1) {
            stringBuffer.append(' ');
        }
    }

    static {
        $assertionsDisabled = !BoardUtils.class.desiredAssertionStatus();
    }
}

