/*
 * Decompiled with CFR 0.152.
 */
package net.sf.samtools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.samtools.Chunk;

public class Bin
implements Comparable<Bin> {
    private final int referenceSequence;
    private final int binNumber;
    private List<Chunk> chunkList;
    private Chunk lastChunk;

    public Bin(int referenceSequence, int binNumber) {
        this.referenceSequence = referenceSequence;
        this.binNumber = binNumber;
    }

    protected int getReferenceSequence() {
        return this.referenceSequence;
    }

    protected int getBinNumber() {
        return this.binNumber;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Bin)) {
            return false;
        }
        Bin otherBin = (Bin)other;
        return this.referenceSequence == otherBin.referenceSequence && this.binNumber == otherBin.binNumber;
    }

    public int hashCode() {
        return Integer.valueOf(this.referenceSequence).hashCode() ^ Integer.valueOf(this.binNumber).hashCode();
    }

    public boolean containsChunks() {
        return this.chunkList != null;
    }

    @Override
    public int compareTo(Bin other) {
        if (other == null) {
            throw new ClassCastException("Cannot compare to a null object");
        }
        if (this.referenceSequence != other.referenceSequence) {
            return this.referenceSequence - other.referenceSequence;
        }
        return this.binNumber - other.binNumber;
    }

    public void addInitialChunk(Chunk newChunk) {
        ArrayList<Chunk> oldChunks = new ArrayList<Chunk>();
        this.setChunkList(oldChunks);
        this.setLastChunk(newChunk);
        oldChunks.add(newChunk);
    }

    public void setChunkList(List<Chunk> list) {
        this.chunkList = list;
    }

    public List<Chunk> getChunkList() {
        if (this.chunkList == null) {
            return Collections.emptyList();
        }
        return this.chunkList;
    }

    public void setLastChunk(Chunk c) {
        this.lastChunk = c;
    }

    public Chunk getLastChunk() {
        return this.lastChunk;
    }
}

