/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils.resolver.implementations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResolverXPointer
extends ResourceResolverSpi {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$utils$resolver$implementations$ResolverXPointer == null ? (class$org$apache$xml$security$utils$resolver$implementations$ResolverXPointer = ResolverXPointer.class$("org.apache.xml.security.utils.resolver.implementations.ResolverXPointer")) : class$org$apache$xml$security$utils$resolver$implementations$ResolverXPointer).getName());
    private static final String XP = "#xpointer(id(";
    private static final int XP_LENGTH = "#xpointer(id(".length();
    static /* synthetic */ Class class$org$apache$xml$security$utils$resolver$implementations$ResolverXPointer;

    public XMLSignatureInput engineResolve(Attr attr, String string) throws ResourceResolverException {
        Object object;
        Node node = null;
        Document document = attr.getOwnerElement().getOwnerDocument();
        String string2 = attr.getNodeValue();
        if (ResolverXPointer.isXPointerSlash(string2)) {
            node = document;
        } else if (ResolverXPointer.isXPointerId(string2) && (node = IdResolver.getElementById(document, (String)(object = ResolverXPointer.getXPointerId(string2)))) == null) {
            Object[] objectArray = new Object[]{object};
            throw new ResourceResolverException("signature.Verification.MissingID", objectArray, attr, string);
        }
        object = new XMLSignatureInput(node);
        ((XMLSignatureInput)object).setMIMEType("text/xml");
        if (string != null && string.length() > 0) {
            ((XMLSignatureInput)object).setSourceURI(string.concat(attr.getNodeValue()));
        } else {
            ((XMLSignatureInput)object).setSourceURI(attr.getNodeValue());
        }
        return object;
    }

    public boolean engineCanResolve(Attr attr, String string) {
        if (attr == null) {
            return false;
        }
        String string2 = attr.getNodeValue();
        return ResolverXPointer.isXPointerSlash(string2) || ResolverXPointer.isXPointerId(string2);
    }

    private static boolean isXPointerSlash(String string) {
        return string.equals("#xpointer(/)");
    }

    private static boolean isXPointerId(String string) {
        if (string.startsWith(XP) && string.endsWith("))")) {
            String string2 = string.substring(XP_LENGTH, string.length() - 2);
            int n = string2.length() - 1;
            if (string2.charAt(0) == '\"' && string2.charAt(n) == '\"' || string2.charAt(0) == '\'' && string2.charAt(n) == '\'') {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Id=" + string2.substring(1, n)));
                }
                return true;
            }
        }
        return false;
    }

    private static String getXPointerId(String string) {
        if (string.startsWith(XP) && string.endsWith("))")) {
            String string2 = string.substring(XP_LENGTH, string.length() - 2);
            int n = string2.length() - 1;
            if (string2.charAt(0) == '\"' && string2.charAt(n) == '\"' || string2.charAt(0) == '\'' && string2.charAt(n) == '\'') {
                return string2.substring(1, n);
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

