/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TLongByteHashMap;
import gnu.trove.TLongByteIterator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLongByteHashMapDecorator
extends AbstractMap<Long, Byte> {
    protected final TLongByteHashMap _map;

    public TLongByteHashMapDecorator(TLongByteHashMap map2) {
        this._map = map2;
    }

    @Override
    public Byte put(Long key, Byte value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    @Override
    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Long && val instanceof Byte) {
                    long k = this.unwrapKey(key);
                    byte v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Byte get(Object object) {
        return this.get((Long)object);
    }

    public Byte get(Long key) {
        long k = this.unwrapKey(key);
        byte v = this._map.get(k);
        if (v == 0) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Byte remove(Long key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    @Override
    public Byte remove(Object object) {
        return this.remove((Long)object);
    }

    @Override
    public Set<Map.Entry<Long, Byte>> entrySet() {
        return new AbstractSet<Map.Entry<Long, Byte>>(){

            @Override
            public int size() {
                return TLongByteHashMapDecorator.this._map.size();
            }

            @Override
            public boolean isEmpty() {
                return TLongByteHashMapDecorator.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    Object k = ((Map.Entry)o).getKey();
                    Object v = ((Map.Entry)o).getValue();
                    return TLongByteHashMapDecorator.this.containsKey(k) && TLongByteHashMapDecorator.this.get(k).equals(v);
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<Long, Byte>> iterator() {
                return new Iterator<Map.Entry<Long, Byte>>(){
                    private final TLongByteIterator it;
                    {
                        this.it = TLongByteHashMapDecorator.this._map.iterator();
                    }

                    @Override
                    public Map.Entry<Long, Byte> next() {
                        this.it.advance();
                        final Long key = TLongByteHashMapDecorator.this.wrapKey(this.it.key());
                        final Byte v = TLongByteHashMapDecorator.this.wrapValue(this.it.value());
                        return new Map.Entry<Long, Byte>(){
                            private Byte val;
                            {
                                this.val = v;
                            }

                            @Override
                            public boolean equals(Object o) {
                                return o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(key) && ((Map.Entry)o).getValue().equals(this.val);
                            }

                            @Override
                            public Long getKey() {
                                return key;
                            }

                            @Override
                            public Byte getValue() {
                                return this.val;
                            }

                            @Override
                            public int hashCode() {
                                return key.hashCode() + this.val.hashCode();
                            }

                            @Override
                            public Byte setValue(Byte value) {
                                this.val = value;
                                return TLongByteHashMapDecorator.this.put(key, value);
                            }
                        };
                    }

                    @Override
                    public boolean hasNext() {
                        return this.it.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.it.remove();
                    }
                };
            }

            @Override
            public boolean add(Map.Entry<Long, Byte> o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<Long, Byte>> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                TLongByteHashMapDecorator.this.clear();
            }
        };
    }

    @Override
    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Byte> map2) {
        Iterator<Map.Entry<? extends Long, ? extends Byte>> it = map2.entrySet().iterator();
        int i = map2.size();
        while (i-- > 0) {
            Map.Entry<? extends Long, ? extends Byte> e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Long wrapKey(long k) {
        return new Long(k);
    }

    protected long unwrapKey(Object key) {
        return (Long)key;
    }

    protected Byte wrapValue(byte k) {
        return new Byte(k);
    }

    protected byte unwrapValue(Object value) {
        return (Byte)value;
    }
}

