/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VfsRootAccess;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.CidrCodeInsightFixture;
import com.jetbrains.cidr.CidrLog;
import com.jetbrains.cidr.CidrProjectDependentFixture;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.CidrTestProject;
import com.jetbrains.cidr.CidrTestProjects;
import com.jetbrains.cidr.execution.CidrExecutionFixture;
import com.jetbrains.cidr.execution.debugger.CidrDebuggingFixture;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.hamcrest.Matcher;
import org.hamcrest.number.OrderingComparison;
import org.intellij.lang.annotations.JdkConstants;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;

public abstract class CidrTestCase<PROJECT_FIXTURE extends CidrProjectFixture, EXECUTION_FIXTURE extends CidrExecutionFixture<PROJECT_FIXTURE>, DEBUGGING_FIXTURE extends CidrDebuggingFixture<EXECUTION_FIXTURE>, CODE_INSIGHT_FIXTURE extends CidrCodeInsightFixture>
extends UsefulTestCase
implements CidrProjectDependentFixture {
    private static volatile boolean platformInitialized = false;
    private final List<String> myAllAllowedRoots = new ArrayList<String>();
    protected CidrTestDataFixture myTestDataFixture;
    protected PROJECT_FIXTURE myProjectFixture;
    protected EXECUTION_FIXTURE myExecutionFixture;
    protected DEBUGGING_FIXTURE myDebuggingFixture;
    protected CODE_INSIGHT_FIXTURE myCodeInsightFixture;

    protected CidrTestCase() {
        this.initTestFramework();
    }

    public void initTestFramework() {
        Logger.setFactory(TestLoggerFactory.class);
        if (!platformInitialized) {
            platformInitialized = true;
            this.initPlatform();
        }
    }

    private void initPlatform() {
        try {
            TestApplicationManager app = TestApplicationManager.getInstance();
            ShutDownTracker.getInstance().registerShutdownTask(() -> {
                try {
                    CidrProjectFixture.cleanupStatics();
                    app.dispose();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CidrLog.LOG.error((Throwable)e);
                }
            });
            this.initApplication();
        }
        catch (Throwable e) {
            System.err.println("Application initialization issue, exiting.");
            e.printStackTrace();
            try {
                Logger.getInstance((String)("#" + CidrTestCase.class.getPackage().getName())).error("Application initialization issue, exiting.", e);
            }
            finally {
                System.exit(1);
            }
        }
    }

    protected void initApplication() {
    }

    @Override
    protected void runTestRunnable(@NotNull ThrowableRunnable<Throwable> testRunnable) throws Throwable {
        if (testRunnable == null) {
            CidrTestCase.$$$reportNull$$$0(0);
        }
        if (this.shouldRunInWriteAction()) {
            WriteAction.runAndWait(testRunnable);
        } else {
            super.runTestRunnable(testRunnable);
        }
    }

    protected boolean shouldRunInWriteAction() {
        return false;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Path currentDir = Paths.get(System.getProperty("user.dir"), new String[0]).toAbsolutePath();
        Path tmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).toAbsolutePath();
        long freeSpaceBytesInCurrentDir = Files.getFileStore(currentDir).getUsableSpace();
        long freeSpaceBytesInTmp = Files.getFileStore(tmpDir).getUsableSpace();
        long minimumFreeSpaceMegabytes = 700L;
        long minimumFreeSpaceBytes = 734003200L;
        String errorMessage = "Not enough free space in %s to run a test (less than %d MB), %d B";
        Assert.assertThat((String)String.format("Not enough free space in %s to run a test (less than %d MB), %d B", currentDir, 700L, freeSpaceBytesInCurrentDir), (Object)freeSpaceBytesInCurrentDir, (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(734003200L)));
        Assert.assertThat((String)String.format("Not enough free space in %s to run a test (less than %d MB), %d B", tmpDir, 700L, freeSpaceBytesInTmp), (Object)freeSpaceBytesInTmp, (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(734003200L)));
        this.setUpFixtures();
    }

    public void registerAllowedRoots(List<String> roots, @NotNull Disposable disposable) {
        if (disposable == null) {
            CidrTestCase.$$$reportNull$$$0(1);
        }
        final ArrayList<String> newRoots = new ArrayList<String>(roots);
        newRoots.removeAll(this.myAllAllowedRoots);
        String[] newRootsArray = ArrayUtilRt.toStringArray(newRoots);
        VfsRootAccess.allowRootAccess((Disposable)disposable, (String[])newRootsArray);
        this.myAllAllowedRoots.addAll(newRoots);
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                CidrTestCase.this.myAllAllowedRoots.removeAll(newRoots);
            }
        });
    }

    protected void setUpFixtures() throws Exception {
        this.myTestDataFixture = this.createTestDataFixture();
        this.myProjectFixture = this.createProjectFixture();
        if (this.myProjectFixture != null) {
            ((CidrProjectFixture)this.myProjectFixture).setUp(this.getClass().getName(), this.getName());
            ((CidrProjectFixture)this.myProjectFixture).addProjectDependentFixture(this);
            ((CidrProjectFixture)this.myProjectFixture).setCleanProjectOption(this.shouldCleanProject());
            ArrayList<String> allowedRoots = new ArrayList<String>();
            ((CidrProjectFixture)this.myProjectFixture).collectAllowedRoots(allowedRoots);
            this.registerAllowedRoots(allowedRoots, this.getTestRootDisposable());
            this.myExecutionFixture = this.createExecutionFixture();
            if (this.myExecutionFixture != null) {
                ((CidrExecutionFixture)((Object)this.myExecutionFixture)).setUp();
            }
            if (this.myExecutionFixture != null) {
                this.myDebuggingFixture = this.createDebuggingFixture();
                if (this.myDebuggingFixture != null) {
                    ((CidrDebuggingFixture)((Object)this.myDebuggingFixture)).setUp();
                }
            }
            this.myCodeInsightFixture = this.createCodeInsightFixture();
            if (this.myCodeInsightFixture != null) {
                ((CidrCodeInsightFixture)this.myCodeInsightFixture).setUp();
            }
        }
    }

    @NotNull
    protected CidrTestDataFixture createTestDataFixture() {
        return new CidrTestDataFixture(null);
    }

    @Nullable
    protected PROJECT_FIXTURE createProjectFixture() {
        return null;
    }

    @Nullable
    protected EXECUTION_FIXTURE createExecutionFixture() {
        return null;
    }

    @Nullable
    protected DEBUGGING_FIXTURE createDebuggingFixture() {
        return null;
    }

    @Nullable
    protected CODE_INSIGHT_FIXTURE createCodeInsightFixture() {
        return null;
    }

    @Override
    protected boolean shouldContainTempFiles() {
        return false;
    }

    protected CidrProjectFixture.CleanProjectOption shouldCleanProject() {
        return CidrProjectFixture.CleanProjectOption.DO_NOT_CLEAN;
    }

    @Override
    @NotNull
    public FileSymbolTablesCache.SymbolsProperties.SymbolsKind shouldBuildSymbolTables() {
        FileSymbolTablesCache.SymbolsProperties.SymbolsKind symbolsKind = FileSymbolTablesCache.SymbolsProperties.SymbolsKind.NO_SYMBOLS;
        if (symbolsKind == null) {
            CidrTestCase.$$$reportNull$$$0(2);
        }
        return symbolsKind;
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myCodeInsightFixture != null) {
                ((CidrCodeInsightFixture)this.myCodeInsightFixture).tearDown();
            }
            if (this.myDebuggingFixture != null) {
                ((CidrDebuggingFixture)((Object)this.myDebuggingFixture)).tearDown();
            }
            if (this.myExecutionFixture != null) {
                ((CidrExecutionFixture)((Object)this.myExecutionFixture)).tearDown();
            }
            if (this.myProjectFixture != null) {
                ((CidrProjectFixture)this.myProjectFixture).removeProjectDependentFixture(this);
                ((CidrProjectFixture)this.myProjectFixture).tearDown();
            }
            if (this.myTestDataFixture != null) {
                this.myTestDataFixture.tearDown();
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    public void afterProjectOpened() throws Exception {
    }

    @Override
    public void beforeProjectClosed() throws Exception {
    }

    public static TestApplicationManager getTestApplication() {
        return TestApplicationManager.getInstance();
    }

    @NotNull
    public Project getProject() {
        Project project2 = ((CidrProjectFixture)this.myProjectFixture).getProject();
        if (project2 == null) {
            CidrTestCase.$$$reportNull$$$0(3);
        }
        return project2;
    }

    protected File getTestDataDir() {
        return this.myTestDataFixture.getTestDataDir();
    }

    protected File getTestDataFile(String testDataRelativePath) {
        return this.myTestDataFixture.getTestDataFile(testDataRelativePath);
    }

    protected File getTestDataProjectsDir() {
        return this.myTestDataFixture.getTestDataProjectsDir();
    }

    protected File getTestDataProjectsFile(String testDataRelativePath) {
        return this.myTestDataFixture.getTestDataProjectsFile(testDataRelativePath);
    }

    public VirtualFile createTempDir() {
        return this.myTestDataFixture.createTempDir();
    }

    public File createTempIODir() {
        return this.myTestDataFixture.createTempIODir();
    }

    public VirtualFile createTempFile() {
        return this.myTestDataFixture.createTempFile();
    }

    public File createTempIOFile() {
        return this.myTestDataFixture.createTempIOFile();
    }

    public VirtualFile createTempFile(String content) {
        return this.myTestDataFixture.createTempFile(content);
    }

    public VirtualFile createFile(VirtualFile dir, String name, String content) {
        return this.myTestDataFixture.createFile(dir, name, content);
    }

    public static void assertMatches(String string, @RegExp String pattern) {
        CidrTestCase.assertMatches(string, pattern, 0);
    }

    public static void assertDoesntMatch(String string, @RegExp String pattern) {
        CidrTestCase.assertDoesntMatch(string, pattern, 0);
    }

    public static void assertMatches(String string, @RegExp String pattern, @JdkConstants.PatternFlags int flags) {
        if (!Pattern.compile(pattern, flags).matcher(string).matches()) {
            CidrTestCase.assertEquals((String)("Text: " + string + "\nShould match pattern: " + pattern), (String)pattern.replace("\\n", "\n"), (String)string);
        }
    }

    public static void assertContains(@NotNull String text, @NotNull String subString) {
        if (text == null) {
            CidrTestCase.$$$reportNull$$$0(4);
        }
        if (subString == null) {
            CidrTestCase.$$$reportNull$$$0(5);
        }
        CidrTestCase.assertTrue((String)("Text: '" + text + "'\nShould contain substring: " + subString), (boolean)text.contains(subString));
    }

    public static void assertDoesntMatch(String string, @RegExp String pattern, @JdkConstants.PatternFlags int flags) {
        CidrTestCase.assertFalse((String)("Text: " + string + "\nShould not match pattern: " + pattern), (boolean)Pattern.compile(pattern, flags).matcher(string).matches());
    }

    @NotNull
    public static SystemAssumption assumeSystem() {
        SystemAssumption systemAssumption = SystemAssumption.INSTANCE;
        if (systemAssumption == null) {
            CidrTestCase.$$$reportNull$$$0(6);
        }
        return systemAssumption;
    }

    public static void printPsiStructure(PsiElement e) {
        System.err.println(CidrTestCase.psiStructure(e));
    }

    public static String psiStructure(PsiElement e) {
        return DebugUtil.psiToString((PsiElement)e, (boolean)true);
    }

    public void waitForResolve() {
        DumbService.getInstance((Project)((CidrProjectFixture)this.myProjectFixture).getProject()).runReadActionInSmartMode(() -> FileSymbolTablesCache.getInstance((Project)((CidrProjectFixture)this.myProjectFixture).getProject()).ensurePendingFilesProcessed());
    }

    public static void waitForSwing() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        Semaphore s = new Semaphore();
        s.down();
        ApplicationManager.getApplication().invokeLater(() -> s.up());
        try {
            s.waitForUnsafe();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        UIUtil.invokeAndWaitIfNeeded(() -> {});
    }

    public void waitForDebuggerAndSwingEvents() throws InterruptedException {
        ((CidrDebuggingFixture)((Object)this.myDebuggingFixture)).waitForDebuggerAndSwingEvents();
    }

    @Nullable
    public VirtualFile findTestProjectSubFile(@NotNull String relativePath) {
        if (relativePath == null) {
            CidrTestCase.$$$reportNull$$$0(7);
        }
        return ((CidrProjectFixture)this.myProjectFixture).findProjectSubFile(relativePath);
    }

    protected void initProject(@NotNull String projectFileRelativePath) throws Exception {
        if (projectFileRelativePath == null) {
            CidrTestCase.$$$reportNull$$$0(8);
        }
        ((CidrProjectFixture)this.myProjectFixture).initProject(projectFileRelativePath);
    }

    protected void initProject(@NotNull String projectFileRelativePath, @NotNull String folderToCopy) throws Exception {
        if (projectFileRelativePath == null) {
            CidrTestCase.$$$reportNull$$$0(9);
        }
        if (folderToCopy == null) {
            CidrTestCase.$$$reportNull$$$0(10);
        }
        ((CidrProjectFixture)this.myProjectFixture).initProject(projectFileRelativePath, folderToCopy, true);
    }

    @NotNull
    public VirtualFile getTestProjectRoot() {
        VirtualFile virtualFile = ((CidrProjectFixture)this.myProjectFixture).getProjectDir();
        if (virtualFile == null) {
            CidrTestCase.$$$reportNull$$$0(11);
        }
        return virtualFile;
    }

    protected void closeAndReopenProject() throws Exception {
        this.closeAndReopenProject(null);
    }

    protected void closeAndReopenProject(@Nullable Runnable beforeRestart) throws Exception {
        ((CidrProjectFixture)this.myProjectFixture).saveAndCloseProject();
        if (beforeRestart != null) {
            beforeRestart.run();
        }
        ((CidrProjectFixture)this.myProjectFixture).openProject(true);
    }

    @Nullable
    public static String getProjectPathIfOpenAutomatically(@NotNull Class<?> clazz) {
        CidrTestProject annotation;
        if (clazz == null) {
            CidrTestCase.$$$reportNull$$$0(12);
        }
        if ((annotation = CidrTestCase.getProjectPath(clazz)) == null || annotation.project() == CidrTestProjects.NO_PROJECT) {
            return null;
        }
        return annotation.project().getPath();
    }

    @Nullable
    public static String getProjectPathForSorting(@NotNull Class<?> clazz) {
        CidrTestProject annotation;
        if (clazz == null) {
            CidrTestCase.$$$reportNull$$$0(13);
        }
        if ((annotation = CidrTestCase.getProjectPath(clazz)) == null) {
            return null;
        }
        return annotation.project().getPath();
    }

    @Nullable
    public static CidrTestProject getProjectPath(@NotNull Class<?> clazz) {
        if (clazz == null) {
            CidrTestCase.$$$reportNull$$$0(14);
        }
        do {
            CidrTestProject annotation;
            if ((annotation = clazz.getAnnotation(CidrTestProject.class)) == null) continue;
            return annotation;
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testRunnable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/CidrTestCase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subString";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectFileRelativePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderToCopy";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/CidrTestCase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "shouldBuildSymbolTables";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "assumeSystem";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestProjectRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runTestRunnable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerAllowedRoots";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertContains";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findTestProjectSubFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "initProject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPathIfOpenAutomatically";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPathForSorting";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getProjectPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SystemAssumption {
        private static final SystemAssumption INSTANCE = new SystemAssumption();

        public void isWindows() {
            Assume.assumeTrue((String)"Windows only", (boolean)SystemInfo.isWindows);
        }

        public void isUnix() {
            Assume.assumeTrue((String)"Unix only", (boolean)SystemInfo.isUnix);
        }

        public void isLinux() {
            Assume.assumeTrue((String)"Linux only", (boolean)SystemInfo.isLinux);
        }

        public void isMac() {
            Assume.assumeTrue((String)"Mac only", (boolean)SystemInfo.isMac);
        }

        public void isNotWindows() {
            Assume.assumeFalse((String)"not for Windows", (boolean)SystemInfo.isWindows);
        }

        public void isNotUnix() {
            Assume.assumeFalse((String)"not for Unix", (boolean)SystemInfo.isUnix);
        }

        public void isNotLinux() {
            Assume.assumeFalse((String)"not for Linux", (boolean)SystemInfo.isLinux);
        }

        public void isNotMac() {
            Assume.assumeFalse((String)"not for Mac", (boolean)SystemInfo.isMac);
        }
    }
}

