/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.util;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NameTemplate
implements Cloneable {
    public transient Placeholder[] allowed;
    public String template;
    public static final Placeholder TABLE = new Placeholder("{table}", DatabaseBundle.messagePointer((String)"sql.code.generation.template.table.name", (Object[])new Object[0]), "table1");
    public static final Placeholder COLUMNS = new Placeholder("{columns}", DatabaseBundle.messagePointer((String)"sql.code.generation.template.columns.names", (Object[])new Object[0]), "col1_col2");
    public static final Placeholder REF_TABLE = new Placeholder("{ref_table}", DatabaseBundle.messagePointer((String)"sql.code.generation.template.referenced.table.name", (Object[])new Object[0]), "rtable2");
    public static final Placeholder REF_COLUMNS = new Placeholder("{ref_columns}", DatabaseBundle.messagePointer((String)"sql.code.generation.template.referenced.columns.names", (Object[])new Object[0]), "rcol1_rcol2");
    public static final Placeholder UNIQUE = new RegexPlaceholder("{unique?*:*}", "\\{unique\\?([^:}]*):([^:}]*)\\}", DatabaseBundle.messagePointer((String)"sql.code.generation.template.uniqueness.infix", (Object[])new Object[0]), "$1");

    public NameTemplate(@NotNull String template, Placeholder ... allowed) {
        if (template == null) {
            NameTemplate.$$$reportNull$$$0(0);
        }
        if (allowed == null) {
            NameTemplate.$$$reportNull$$$0(1);
        }
        this.allowed = allowed;
        this.template = template;
    }

    @NotNull
    public static String example(@NotNull String template, Placeholder ... allowed) {
        if (template == null) {
            NameTemplate.$$$reportNull$$$0(2);
        }
        if (allowed == null) {
            NameTemplate.$$$reportNull$$$0(3);
        }
        SubstitutionBuilder builder = new SubstitutionBuilder(template);
        for (Placeholder placeholder : allowed) {
            builder.substitute(placeholder, placeholder.example);
        }
        String string = builder.build();
        if (string == null) {
            NameTemplate.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public abstract String getName(@NotNull DasObject var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameTemplate template1 = (NameTemplate)o;
        if (!Arrays.equals(this.allowed, template1.allowed)) {
            return false;
        }
        return this.template.equals(template1.template);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.allowed);
        result = 31 * result + this.template.hashCode();
        return result;
    }

    protected Object clone() throws CloneNotSupportedException {
        NameTemplate clone = (NameTemplate)super.clone();
        clone.allowed = this.allowed;
        clone.template = this.template;
        return clone;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowed";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/util/NameTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/util/NameTemplate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "example";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "example";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PrimaryKeyNameTemplate
    extends NameTemplate {
        public static final String DEFAULT = "{table}_{columns}_pk";

        public PrimaryKeyNameTemplate() {
            this(DEFAULT);
        }

        public PrimaryKeyNameTemplate(@NotNull String template) {
            if (template == null) {
                PrimaryKeyNameTemplate.$$$reportNull$$$0(0);
            }
            super(template, TABLE, COLUMNS);
        }

        public PrimaryKeyNameTemplate(@NotNull SqlCodeStyleSettings settings) {
            if (settings == null) {
                PrimaryKeyNameTemplate.$$$reportNull$$$0(1);
            }
            this(settings.PRIMARY_KEY_NAME_TEMPLATE);
        }

        @NotNull
        public String getName(@NotNull String tableName, @NotNull Iterable<String> columnNames) {
            if (tableName == null) {
                PrimaryKeyNameTemplate.$$$reportNull$$$0(2);
            }
            if (columnNames == null) {
                PrimaryKeyNameTemplate.$$$reportNull$$$0(3);
            }
            String string = new SubstitutionBuilder(this.template).substitute(TABLE, tableName).substitute(COLUMNS, StringUtil.join(columnNames, (String)"_")).build();
            if (string == null) {
                PrimaryKeyNameTemplate.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getName(@NotNull DasTable table, @NotNull Iterable<? extends DasTypedObject> columns) {
            if (table == null) {
                PrimaryKeyNameTemplate.$$$reportNull$$$0(5);
            }
            if (columns == null) {
                PrimaryKeyNameTemplate.$$$reportNull$$$0(6);
            }
            String string = this.getName(table.getName(), (Iterable<String>)JBIterable.from(columns).transform(DasUtil.TO_NAME));
            if (string == null) {
                PrimaryKeyNameTemplate.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Override
        @NotNull
        public String getName(@NotNull DasObject object) {
            DasTableKey key;
            if (object == null) {
                PrimaryKeyNameTemplate.$$$reportNull$$$0(8);
            }
            String string = (key = (DasTableKey)ObjectUtils.tryCast((Object)object, DasTableKey.class)) == null ? object.getName() : this.getName(key.getTable(), key.getColumnsRef().resolveObjects());
            if (string == null) {
                PrimaryKeyNameTemplate.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnNames";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/util/NameTemplate$PrimaryKeyNameTemplate";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/util/NameTemplate$PrimaryKeyNameTemplate";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class IndexNameTemplate
    extends NameTemplate {
        public static final String DEFAULT = "{table}_{columns}_{unique?u:}index";

        public IndexNameTemplate() {
            this(DEFAULT);
        }

        public IndexNameTemplate(@NotNull String template) {
            if (template == null) {
                IndexNameTemplate.$$$reportNull$$$0(0);
            }
            super(template, TABLE, COLUMNS, UNIQUE);
        }

        public IndexNameTemplate(@NotNull SqlCodeStyleSettings settings) {
            if (settings == null) {
                IndexNameTemplate.$$$reportNull$$$0(1);
            }
            this(settings.INDEX_NAME_TEMPLATE);
        }

        @NotNull
        public String getName(@NotNull String tableName, @NotNull Iterable<String> columnNames, boolean unique) {
            if (tableName == null) {
                IndexNameTemplate.$$$reportNull$$$0(2);
            }
            if (columnNames == null) {
                IndexNameTemplate.$$$reportNull$$$0(3);
            }
            String string = new SubstitutionBuilder(this.template).substitute(TABLE, tableName).substitute(COLUMNS, StringUtil.join(columnNames, (String)"_")).substitute(UNIQUE, unique ? "$1" : "$2").build();
            if (string == null) {
                IndexNameTemplate.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getName(@NotNull DasTable table, @NotNull Iterable<? extends DasTypedObject> columns, boolean unique) {
            if (table == null) {
                IndexNameTemplate.$$$reportNull$$$0(5);
            }
            if (columns == null) {
                IndexNameTemplate.$$$reportNull$$$0(6);
            }
            String string = this.getName(table.getName(), (Iterable<String>)JBIterable.from(columns).transform(DasUtil.TO_NAME), unique);
            if (string == null) {
                IndexNameTemplate.$$$reportNull$$$0(7);
            }
            return string;
        }

        @Override
        @NotNull
        public String getName(@NotNull DasObject object) {
            DasIndex index;
            if (object == null) {
                IndexNameTemplate.$$$reportNull$$$0(8);
            }
            String string = (index = (DasIndex)ObjectUtils.tryCast((Object)object, DasIndex.class)) == null ? object.getName() : this.getName(index.getTable(), index.getColumnsRef().resolveObjects(), index.isUnique());
            if (string == null) {
                IndexNameTemplate.$$$reportNull$$$0(9);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnNames";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/util/NameTemplate$IndexNameTemplate";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/util/NameTemplate$IndexNameTemplate";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 7: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class ForeignKeyNameTemplate
    extends NameTemplate {
        public static final String DEFAULT = "{table}_{ref_table}_{ref_columns}_fk";

        public ForeignKeyNameTemplate() {
            this(DEFAULT);
        }

        public ForeignKeyNameTemplate(@NotNull String template) {
            if (template == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(0);
            }
            super(template, TABLE, COLUMNS, REF_TABLE, REF_COLUMNS);
        }

        public ForeignKeyNameTemplate(@NotNull SqlCodeStyleSettings settings) {
            if (settings == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(1);
            }
            this(settings.FOREIGN_KEY_NAME_TEMPLATE);
        }

        @NotNull
        public String getName(@NotNull String tableName, @NotNull Iterable<String> columnNames, @NotNull String targetName, @NotNull Iterable<String> targetColumnNames) {
            if (tableName == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(2);
            }
            if (columnNames == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(3);
            }
            if (targetName == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(4);
            }
            if (targetColumnNames == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(5);
            }
            String string = new SubstitutionBuilder(this.template).substitute(TABLE, tableName).substitute(COLUMNS, StringUtil.join(columnNames, (String)"_")).substitute(REF_TABLE, targetName).substitute(REF_COLUMNS, StringUtil.join(targetColumnNames, (String)"_")).build();
            if (string == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String getName(@NotNull DasTable table, @NotNull Iterable<? extends DasTypedObject> columns, @Nullable DasTable target, @NotNull Iterable<? extends DasTypedObject> targetColumns) {
            if (table == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(7);
            }
            if (columns == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(8);
            }
            if (targetColumns == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(9);
            }
            String string = this.getName(table.getName(), (Iterable<String>)JBIterable.from(columns).transform(DasUtil.TO_NAME), target == null ? "" : target.getName(), (Iterable<String>)JBIterable.from(targetColumns).transform(DasUtil.TO_NAME));
            if (string == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(10);
            }
            return string;
        }

        @NotNull
        public String getName(@NotNull DasTable table, @NotNull Iterable<? extends DasTypedObject> columns) {
            if (table == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(11);
            }
            if (columns == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(12);
            }
            String string = this.getName(table, columns, null, (Iterable<? extends DasTypedObject>)JBIterable.empty());
            if (string == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(13);
            }
            return string;
        }

        @Override
        @NotNull
        public String getName(@NotNull DasObject object) {
            DasForeignKey key;
            if (object == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(14);
            }
            String string = (key = (DasForeignKey)ObjectUtils.tryCast((Object)object, DasForeignKey.class)) == null ? object.getName() : this.getName(key.getTable(), key.getColumnsRef().resolveObjects(), key.getRefTable(), key.getRefColumns().resolveObjects());
            if (string == null) {
                ForeignKeyNameTemplate.$$$reportNull$$$0(15);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 10: 
                case 13: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 10: 
                case 13: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnNames";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetName";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetColumnNames";
                    break;
                }
                case 6: 
                case 10: 
                case 13: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate";
                    break;
                }
                case 7: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 8: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetColumns";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/util/NameTemplate$ForeignKeyNameTemplate";
                    break;
                }
                case 6: 
                case 10: 
                case 13: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 11: 
                case 12: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "getName";
                    break;
                }
                case 6: 
                case 10: 
                case 13: 
                case 15: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 10: 
                case 13: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class SubstitutionBuilder {
        private String myResult;

        public SubstitutionBuilder(@NotNull String template) {
            if (template == null) {
                SubstitutionBuilder.$$$reportNull$$$0(0);
            }
            this.myResult = template;
        }

        public SubstitutionBuilder substitute(@NotNull Placeholder p, @NotNull String val) {
            if (p == null) {
                SubstitutionBuilder.$$$reportNull$$$0(1);
            }
            if (val == null) {
                SubstitutionBuilder.$$$reportNull$$$0(2);
            }
            this.myResult = p.substitute(this.myResult, val);
            return this;
        }

        @NotNull
        public String build() {
            String string = this.myResult;
            if (string == null) {
                SubstitutionBuilder.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "p";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "val";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/util/NameTemplate$SubstitutionBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/util/NameTemplate$SubstitutionBuilder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "substitute";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class RegexPlaceholder
    extends Placeholder {
        private final Pattern myPattern;

        public RegexPlaceholder(@NotNull String text, @NotNull @RegExp String regex, @NotNull Supplier<String> desc, @NotNull String example) {
            if (text == null) {
                RegexPlaceholder.$$$reportNull$$$0(0);
            }
            if (regex == null) {
                RegexPlaceholder.$$$reportNull$$$0(1);
            }
            if (desc == null) {
                RegexPlaceholder.$$$reportNull$$$0(2);
            }
            if (example == null) {
                RegexPlaceholder.$$$reportNull$$$0(3);
            }
            super(text, desc, example);
            this.myPattern = Pattern.compile(regex);
        }

        @Override
        @NotNull
        public String substitute(@NotNull String s, @NotNull String val) {
            if (s == null) {
                RegexPlaceholder.$$$reportNull$$$0(4);
            }
            if (val == null) {
                RegexPlaceholder.$$$reportNull$$$0(5);
            }
            String string = this.myPattern.matcher(s).replaceAll(val);
            if (string == null) {
                RegexPlaceholder.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regex";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "example";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "val";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/util/NameTemplate$RegexPlaceholder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/util/NameTemplate$RegexPlaceholder";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "substitute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "substitute";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Placeholder {
        @NlsSafe
        public final String text;
        @Nls
        public final Supplier<String> desc;
        @NlsSafe
        public final String example;

        public Placeholder(@NotNull String text, @NotNull Supplier<String> desc, @NotNull String example) {
            if (text == null) {
                Placeholder.$$$reportNull$$$0(0);
            }
            if (desc == null) {
                Placeholder.$$$reportNull$$$0(1);
            }
            if (example == null) {
                Placeholder.$$$reportNull$$$0(2);
            }
            this.text = text;
            this.desc = desc;
            this.example = example;
        }

        @NotNull
        public String substitute(@NotNull String s, @NotNull String val) {
            if (s == null) {
                Placeholder.$$$reportNull$$$0(3);
            }
            if (val == null) {
                Placeholder.$$$reportNull$$$0(4);
            }
            String string = s.replace(this.text, val);
            if (string == null) {
                Placeholder.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "example";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "val";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/util/NameTemplate$Placeholder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/util/NameTemplate$Placeholder";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "substitute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "substitute";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

