/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.actions;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.CancelActionException;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.P4File;

public abstract class ActionBaseFile
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance(ActionBaseFile.class);
    protected static final String[] YES_NO_OPTIONS = new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText()};
    protected static final String[] YES_NO_CANCELREST_OPTIONS = new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText(), PerforceBundle.message("button.text.cancel.rest", new Object[0])};

    protected static void log(@NonNls String msg) {
        LOG.debug(msg);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ActionBaseFile.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        Object[] vFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (ArrayUtil.isEmpty((Object[])vFiles) || !ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)PerforceVcs.getInstance(project), (VirtualFile[])vFiles)) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
    }

    protected abstract void performAction(VirtualFile var1, Project var2, boolean var3, List<VirtualFile> var4) throws CancelActionException, VcsException;

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            ActionBaseFile.$$$reportNull$$$0(1);
        }
        Project project = (Project)event.getRequiredData(CommonDataKeys.PROJECT);
        VirtualFile[] vFiles = (VirtualFile[])event.getRequiredData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        FileDocumentManager.getInstance().saveAllDocuments();
        this.processFiles(project, vFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFiles(Project project, VirtualFile ... vFiles) {
        boolean containsDirectory = false;
        if (vFiles != null && vFiles.length > 0) {
            try {
                ArrayList<VirtualFile> filesToPostProcess = new ArrayList<VirtualFile>();
                for (VirtualFile vFile : vFiles) {
                    boolean[] cancelled = new boolean[]{false};
                    try {
                        try {
                            this.performAction(vFile, project, vFiles.length == 1, filesToPostProcess);
                            if (vFile.isDirectory()) {
                                containsDirectory = true;
                            }
                        }
                        catch (VcsException e) {
                            AbstractVcsHelper.getInstance((Project)project).showError(e, PerforceBundle.message("dialog.title.perforce", new Object[0]));
                        }
                    }
                    catch (CancelActionException e) {
                        cancelled[0] = true;
                    }
                    if (cancelled[0]) break;
                }
                this.postProcessFiles(project, filesToPostProcess);
            }
            finally {
                if (containsDirectory) {
                    VirtualFileManager.getInstance().asyncRefresh(() -> {
                        P4File.invalidateFstat(project);
                        for (VirtualFile file : vFiles) {
                            if (file.isDirectory()) {
                                VcsDirtyScopeManager.getInstance((Project)project).dirDirtyRecursively(file);
                                continue;
                            }
                            VcsDirtyScopeManager.getInstance((Project)project).fileDirty(file);
                        }
                    });
                } else {
                    for (VirtualFile vFile : vFiles) {
                        ApplicationManager.getApplication().runWriteAction(() -> vFile.refresh(false, false));
                        P4File.invalidateFstat(vFile);
                        VcsDirtyScopeManager.getInstance((Project)project).fileDirty(vFile);
                    }
                }
            }
        }
    }

    public void postProcessFiles(Project project, List<VirtualFile> filesToPostProcess) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/perforce/actions/ActionBaseFile";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

