/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import a.d.la;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.ContentPanel;
import com.intellij.dupLocator.resultUI.DuplicatesModel;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.ExportHTMLAction;
import com.intellij.dupLocator.resultUI.GroupNode;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.Painter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.impl.SelectInEditorHandler;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class DuplicatesForm
implements Disposable {
    private final JLabel mySendToLeftButton;
    private final JLabel mySendToRightButton;
    private final JPanel myButtonsPanel;
    @NonNls
    private static final String SEND_TO_LEFT_ID = "DuplicatesForm.SendToLeft";
    @NonNls
    private static final String SEND_TO_RIGHT_ID = "DuplicatesForm.SendToRight";
    @NonNls
    private static final String ourHelpID = "find.locateDuplicates.result";
    private final JBSplitter myPanel;
    private final Tree myDuplicatesTree;
    private final MyDuplicatesModelListener myDupModelListener;
    private final Map<DuplicatesPresentation, DuplicatesView> myViews;
    private final Map<Editor, List<RangeHighlighter>> myInEditorHighlighters;
    private final HighlightManager myHighlightManager;
    private DuplicatesModel myModel;
    private final Project myProject;
    private static final DataKey<DuplicatesModel> MODEL;
    private static final String SCROLL_TO_SOURCE = "DuplicatesForm.settings.scrollToSource";
    private final MyGlassPanePainter myGlassPanePainter;
    private static DupInfo ourDuplicates;
    private static final long a;

    private DuplicatesForm(Project project) {
        long l2 = a ^ 0x3F784CD6C057L;
        this.mySendToLeftButton = new JLabel(AllIcons.Duplicates.SendToTheLeft);
        this.mySendToRightButton = new JLabel(AllIcons.Duplicates.SendToTheRight);
        this.myButtonsPanel = new JPanel(new BorderLayout());
        this.myDuplicatesTree = new Tree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myDupModelListener = new MyDuplicatesModelListener();
        this.myViews = new HashMap<DuplicatesPresentation, DuplicatesView>();
        this.myInEditorHighlighters = new HashMap<Editor, List<RangeHighlighter>>();
        this.myGlassPanePainter = new MyGlassPanePainter();
        this.myProject = project;
        this.myHighlightManager = HighlightManager.getInstance((Project)this.myProject);
        DataProvider dataProvider = string -> {
            long l2 = a ^ 0x1BE212DE5EC8L;
            if (PlatformDataKeys.HELP_ID.is(string)) {
                return ourHelpID;
            }
            if (MODEL.is(string)) {
                return this.myModel;
            }
            if (this.myModel == null) {
                return null;
            }
            if (CommonDataKeys.NAVIGATABLE.is(string)) {
                CodeNode codeNode = this.myModel.getSelectedCodeNode();
                return codeNode != null ? codeNode.getOpenFileDescriptorIfValid() : null;
            }
            return null;
        };
        this.myPanel = new MySplitter(dataProvider);
        this.myPanel.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)this.myDuplicatesTree));
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myDuplicatesTree);
        SelectInEditorHandler.installKeyListener((JComponent)this.myDuplicatesTree);
        this.a();
        this.myDuplicatesTree.setShowsRootHandles(true);
        this.myDuplicatesTree.setRootVisible(false);
        final MyColoredTreeCellRenderer myColoredTreeCellRenderer = new MyColoredTreeCellRenderer();
        this.myDuplicatesTree.setCellRenderer((TreeCellRenderer)myColoredTreeCellRenderer);
        PopupHandler.installPopupMenu((JComponent)this.myDuplicatesTree, (ActionGroup)DuplicatesForm.a(this.getComponent()), (String)"DuplicatesPopup");
        this.myDuplicatesTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e10) {
                int n2 = DuplicatesForm.this.myDuplicatesTree.getRowForLocation(e10.getX(), e10.getY());
                if (n2 >= 0) {
                    Rectangle rectangle = DuplicatesForm.this.myDuplicatesTree.getRowBounds(n2);
                    myColoredTreeCellRenderer.setBounds(rectangle);
                    if (!DuplicatesForm.this.a(e10, rectangle.getLocation(), DuplicatesForm.this.mySendToLeftButton, 0)) {
                        DuplicatesForm.this.a(e10, new Point(rectangle.x + DuplicatesForm.this.mySendToLeftButton.getWidth(), rectangle.y), DuplicatesForm.this.mySendToRightButton, 1);
                    }
                }
            }
        });
        this.myButtonsPanel.add((Component)this.mySendToLeftButton, "West");
        this.myButtonsPanel.add((Component)this.mySendToRightButton, "East");
        this.myButtonsPanel.setBackground(UIUtil.getTreeBackground());
        IdeGlassPaneUtil.installPainter((JComponent)this.myDuplicatesTree, (Painter)this.myGlassPanePainter, (Disposable)this);
        this.myDuplicatesTree.addMouseMotionListener((MouseMotionListener)new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e10) {
                Object object;
                int n2 = DuplicatesForm.this.myDuplicatesTree.getRowForLocation(e10.getX(), e10.getY());
                if (n2 >= 0 && (object = DuplicatesForm.this.myDuplicatesTree.getPathForRow(n2).getLastPathComponent()) instanceof CodeNode) {
                    Rectangle rectangle = DuplicatesForm.this.myDuplicatesTree.getRowBounds(n2);
                    myColoredTreeCellRenderer.setBounds(rectangle);
                    Point point = e10.getPoint();
                    Rectangle rectangle2 = DuplicatesForm.this.mySendToLeftButton.getBounds();
                    rectangle2.setLocation(rectangle.getLocation());
                    Icon icon = null;
                    if (rectangle2.contains(point)) {
                        icon = AllIcons.Duplicates.SendToTheLeft;
                    } else {
                        rectangle2 = DuplicatesForm.this.mySendToRightButton.getBounds();
                        rectangle2.setLocation(new Point(rectangle.x + AllIcons.Duplicates.SendToTheRight.getIconWidth(), rectangle.y));
                        if (rectangle2.contains(point)) {
                            icon = AllIcons.Duplicates.SendToTheRight;
                        }
                    }
                    if (icon != null) {
                        DuplicatesForm.this.myGlassPanePainter.setPaint(icon, rectangle2.getLocation());
                        return;
                    }
                }
                DuplicatesForm.this.myGlassPanePainter.setPaint(null, null);
            }
        });
    }

    private void a() {
        final EditSourceOnDoubleClickHandler.TreeMouseListener treeMouseListener = new EditSourceOnDoubleClickHandler.TreeMouseListener((JTree)this.myDuplicatesTree);
        new DoubleClickListener(){
            private static final long a = la.a(-4620432470897039184L, 1856158014046316535L, MethodHandles.lookup().lookupClass()).a(221066597267489L);

            protected boolean onDoubleClick(@NotNull MouseEvent e10) {
                if (e10 == null) {
                    3.a(0);
                }
                treeMouseListener.onDoubleClick(e10);
                CodeNode codeNode = DuplicatesForm.this.a();
                if (codeNode != null) {
                    PsiFragment psiFragment = codeNode.getFragment();
                    UsageInfo usageInfo = psiFragment.getUsageInfo();
                    if (usageInfo == null) {
                        return true;
                    }
                    PsiElement[] psiElementArray = psiFragment.getElements();
                    assert (psiElementArray.length > 0);
                    PsiElement psiElement = psiElementArray[0];
                    OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(DuplicatesForm.this.myProject, usageInfo.getVirtualFile(), psiElement.getTextOffset());
                    Editor editor = FileEditorManager.getInstance((Project)DuplicatesForm.this.myProject).openTextEditor(openFileDescriptor, false);
                    if (editor != null) {
                        List<RangeHighlighter> list2 = DuplicatesForm.this.myInEditorHighlighters.get(editor);
                        if (list2 != null) {
                            for (RangeHighlighter rangeHighlighter : list2) {
                                DuplicatesForm.this.myHighlightManager.removeSegmentHighlighter(editor, rangeHighlighter);
                            }
                        }
                        List<RangeHighlighter> list3 = DuplicatesForm.highlightPsiFragment(editor, psiFragment, DuplicatesForm.this.myHighlightManager, 0);
                        DuplicatesForm.this.myInEditorHighlighters.put(editor, list3);
                    }
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x157C9E0E278CL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/dupLocator/resultUI/DuplicatesForm$3", "onDoubleClick"));
            }
        }.installOn((Component)this.myDuplicatesTree);
    }

    private boolean a(MouseEvent mouseEvent, Point point, JLabel jLabel, int n2) {
        Point point2 = mouseEvent.getPoint();
        Rectangle rectangle = jLabel.getBounds();
        rectangle.setLocation(point);
        CodeNode codeNode = this.myModel.getSelectedCodeNode();
        if (codeNode != null && rectangle.contains(point2)) {
            this.myModel.setDiff(n2, codeNode);
            mouseEvent.consume();
            return true;
        }
        return false;
    }

    public JTree getDuplicatesTree() {
        return this.myDuplicatesTree;
    }

    private static DefaultActionGroup a(JComponent jComponent) {
        long l2 = a ^ 0x595076BAA2D9L;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        ActionManager actionManager = ActionManager.getInstance();
        defaultActionGroup.add(actionManager.getAction("EditSource"));
        defaultActionGroup.add(actionManager.getAction("ViewSource"));
        defaultActionGroup.addSeparator();
        AnAction anAction = actionManager.getAction(SEND_TO_LEFT_ID);
        anAction.registerCustomShortcutSet(anAction.getShortcutSet(), jComponent);
        defaultActionGroup.add(anAction);
        anAction = actionManager.getAction(SEND_TO_RIGHT_ID);
        anAction.registerCustomShortcutSet(anAction.getShortcutSet(), jComponent);
        defaultActionGroup.add(anAction);
        return defaultActionGroup;
    }

    public void addToolbarActionsTo(ContentPanel panel2) {
        panel2.addActionSeparator();
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){
            private static final long a = la.a(-4911546805445382617L, -7202393088782630603L, MethodHandles.lookup().lookupClass()).a(170558306277172L);

            protected boolean isAutoScrollMode() {
                long l2 = a ^ 0x60788604BC0AL;
                return PropertiesComponent.getInstance().getBoolean(DuplicatesForm.SCROLL_TO_SOURCE);
            }

            protected void setAutoScrollMode(boolean state) {
                long l2 = a ^ 0x2CB1F8664897L;
                PropertiesComponent.getInstance().setValue(DuplicatesForm.SCROLL_TO_SOURCE, state);
            }
        };
        autoScrollToSourceHandler.install((JTree)this.myDuplicatesTree);
        panel2.addAction((AnAction)autoScrollToSourceHandler.createToggleAction());
        if (DuplicatesForm.a()) {
            panel2.addAction(new EliminateDuplicatesAction(this));
        }
        panel2.addAction(new ExportHTMLAction(this.myModel.getRoot()));
    }

    private static boolean a() {
        for (int i10 = 0; i10 < ourDuplicates.getPatterns(); ++i10) {
            DuplicatesPresentation duplicatesPresentation = DuplicatesPresentation.Service.findPresentationForDuplicate(ourDuplicates, i10);
            if (duplicatesPresentation == null || !duplicatesPresentation.isFixAbilityProvided()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private CodeNode a() {
        BasicTreeNode basicTreeNode;
        CodeNode codeNode = this.myModel.getSelectedCodeNode();
        if (codeNode != null) {
            return codeNode;
        }
        TreePath treePath = this.myDuplicatesTree.getSelectionPath();
        if (treePath != null && (basicTreeNode = (BasicTreeNode)treePath.getLastPathComponent()) instanceof GroupNode && basicTreeNode.getChildCount() > 0) {
            return (CodeNode)basicTreeNode.getChildAt(0);
        }
        return null;
    }

    private void a(DuplicatesModel duplicatesModel) {
        if (this.myModel != null) {
            this.myModel.removeListener(this.myDupModelListener);
        }
        this.myModel = duplicatesModel;
        this.myDuplicatesTree.setModel(duplicatesModel.getTreeModel());
        this.myDuplicatesTree.setSelectionModel(duplicatesModel.getSelectionModel());
        duplicatesModel.addListener(this.myDupModelListener);
        this.myDupModelListener.a();
    }

    public JComponent getComponent() {
        return this.myPanel;
    }

    public static DuplicatesForm create(Project project, DupInfo duplicates) {
        ourDuplicates = duplicates;
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        DuplicatesForm duplicatesForm = new DuplicatesForm(project);
        DuplicatesModel duplicatesModel = new DuplicatesModel(duplicates, project);
        duplicatesForm.a(duplicatesModel);
        return duplicatesForm;
    }

    public void dispose() {
        for (Editor editor : this.myInEditorHighlighters.keySet()) {
            List<RangeHighlighter> list2 = this.myInEditorHighlighters.get(editor);
            for (RangeHighlighter rangeHighlighter : list2) {
                this.myHighlightManager.removeSegmentHighlighter(editor, rangeHighlighter);
            }
        }
    }

    public static List<RangeHighlighter> highlightPsiFragment(Editor editor, PsiFragment fragment, HighlightManager highlightManager, int firstOffset) {
        PsiElement[] psiElementArray = fragment.getElements();
        ArrayList<RangeHighlighter> arrayList = new ArrayList<RangeHighlighter>();
        for (PsiElement psiElement : psiElementArray) {
            if (psiElement == null) continue;
            TextRange textRange = psiElement.getTextRange();
            int n2 = textRange.getStartOffset() - firstOffset;
            int n3 = textRange.getEndOffset() - firstOffset;
            highlightManager.addRangeHighlight(editor, n2, n3, EditorColors.SEARCH_RESULT_ATTRIBUTES, false, arrayList);
        }
        return arrayList;
    }

    static {
        a = la.a(-1871396824220572407L, -3227933755084664368L, MethodHandles.lookup().lookupClass()).a(134450089196910L);
        long l2 = a ^ 0x73DAB2DB31CL;
        MODEL = DataKey.create((String)"DUPLICATES_MODEL");
    }

    private class EliminateDuplicatesAction
    extends AnAction {
        final /* synthetic */ DuplicatesForm this$0;
        private static final long a = la.a(7931020503742266257L, 6974342672961082927L, MethodHandles.lookup().lookupClass()).a(274911273532235L);

        EliminateDuplicatesAction(DuplicatesForm duplicatesForm) {
            long l2 = a ^ 0x534753EC701L;
            this.this$0 = duplicatesForm;
            super(DupLocatorBundle.messagePointer((String)"eliminate.duplicates.action.text", (Object[])new Object[0]), DupLocatorBundle.messagePointer((String)"eliminate.duplicates.action.text", (Object[])new Object[0]), AllIcons.Actions.Replace);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                EliminateDuplicatesAction.a(0);
            }
            CodeNode codeNode = this.this$0.a();
            assert (codeNode != null);
            DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
            assert (duplicatesPresentation != null);
            duplicatesPresentation.applyFix(codeNode);
        }

        public void update(@NotNull AnActionEvent e10) {
            CodeNode codeNode;
            boolean bl2;
            if (e10 == null) {
                EliminateDuplicatesAction.a(1);
            }
            boolean bl3 = bl2 = (codeNode = this.this$0.a()) != null;
            if (bl2) {
                DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
                bl2 = duplicatesPresentation != null && duplicatesPresentation.isFixAvailable(codeNode);
            }
            e10.getPresentation().setEnabled(bl2);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x69A0C596FFDDL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dupLocator/resultUI/DuplicatesForm$EliminateDuplicatesAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyGlassPanePainter
    extends AbstractPainter {
        private Icon myIcon;
        private Point myPoint;

        private MyGlassPanePainter() {
        }

        public boolean setPaint(Icon icon, Point point) {
            this.myIcon = (Icon)this.setNeedsRepaint(this.myIcon, icon);
            this.myPoint = (Point)this.setNeedsRepaint(this.myPoint, point);
            return this.needsRepaint();
        }

        public void executePaint(Component component, Graphics2D g10) {
            if (this.myIcon == null) {
                return;
            }
            this.myIcon.paintIcon(component, g10, this.myPoint.x, this.myPoint.y);
        }
    }

    private class MyDuplicatesModelListener
    implements DuplicatesModel.Listener {
        private final Alarm myAlarm = new Alarm();

        private MyDuplicatesModelListener() {
        }

        @Override
        public void onSelectionChanged() {
            this.myAlarm.cancelAllRequests();
            DuplicatesModel duplicatesModel = DuplicatesForm.this.myModel;
            this.myAlarm.addRequest(() -> {
                if (duplicatesModel == DuplicatesForm.this.myModel && DuplicatesForm.this.myPanel.isDisplayable()) {
                    this.a();
                }
            }, 200);
        }

        private void a() {
            JComponent jComponent;
            CodeNode codeNode = DuplicatesForm.this.myModel.getLeft();
            CodeNode codeNode2 = DuplicatesForm.this.myModel.getRight();
            if (codeNode == null || codeNode2 == null) {
                return;
            }
            DuplicatesPresentation duplicatesPresentation = codeNode.getPresentation();
            DuplicatesView duplicatesView = null;
            if (duplicatesPresentation != null && (duplicatesView = DuplicatesForm.this.myViews.get(duplicatesPresentation)) == null) {
                duplicatesView = duplicatesPresentation.createView(DuplicatesForm.this.myProject);
                Disposer.register((Disposable)DuplicatesForm.this, (Disposable)duplicatesView);
                DuplicatesForm.this.myViews.put(duplicatesPresentation, duplicatesView);
            }
            JComponent jComponent2 = DuplicatesForm.this.myPanel.getSecondComponent();
            JComponent jComponent3 = jComponent = duplicatesView != null ? duplicatesView.getComponent() : null;
            if (jComponent != jComponent2) {
                if (jComponent2 != null) {
                    jComponent2.setVisible(false);
                }
                DuplicatesForm.this.myPanel.setSecondComponent(jComponent);
                if (jComponent != null) {
                    jComponent.setMinimumSize((Dimension)JBUI.size((int)10));
                    jComponent.setVisible(true);
                }
            }
            if (duplicatesView != null) {
                duplicatesView.setContent(codeNode, codeNode2);
            }
            DuplicatesForm.this.myDuplicatesTree.repaint();
        }
    }

    private static class SendToAction
    extends AnAction {
        private final int myDiffIndex;
        private static final long a = la.a(8406886017467731380L, -7038948670362528976L, MethodHandles.lookup().lookupClass()).a(257403423932692L);

        SendToAction(@NlsActions.ActionText String text, @NlsActions.ActionDescription String description, Icon icon, String actionId, int diffIndex) {
            super(text, description, icon);
            this.myDiffIndex = diffIndex;
            this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)actionId), null);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SendToAction.a(0);
            }
            DuplicatesModel duplicatesModel = (DuplicatesModel)e10.getData(MODEL);
            duplicatesModel.setDiff(this.myDiffIndex, duplicatesModel.getSelectedCodeNode());
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                SendToAction.a(1);
            }
            Presentation presentation = e10.getPresentation();
            DuplicatesModel duplicatesModel = (DuplicatesModel)e10.getData(MODEL);
            if (duplicatesModel == null) {
                presentation.setEnabled(false);
                return;
            }
            CodeNode codeNode = duplicatesModel.getSelectedCodeNode();
            if (codeNode == null) {
                presentation.setEnabled(false);
                return;
            }
            presentation.setEnabled(true);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x5861331153FCL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/dupLocator/resultUI/DuplicatesForm$SendToAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MySplitter
    extends JBSplitter
    implements DataProvider {
        private final DataProvider myDataProvider;
        private static final long a = la.a(1620861285613632193L, -1344615489226883750L, MethodHandles.lookup().lookupClass()).a(241507935964318L);

        MySplitter(DataProvider dataProvider) {
            long l2 = a ^ 0x688F5D902B60L;
            super("DuplicatesForm.settings", 0.3f);
            this.myDataProvider = dataProvider;
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                MySplitter.a(0);
            }
            return this.myDataProvider.getData(dataId);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x6BBD1F81356DL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/dupLocator/resultUI/DuplicatesForm$MySplitter", "getData"));
        }
    }

    private class MyColoredTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long a = la.a(-2277583242278050349L, 7499906997678735277L, MethodHandles.lookup().lookupClass()).a(95716790927250L);

        private MyColoredTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            long l2 = a ^ 0x5A0211677478L;
            JPanel jPanel = new JPanel(new BorderLayout(5, 0));
            Color color = UIUtil.getTreeBackground((boolean)sel, (boolean)true);
            UIUtil.changeBackGround((Component)jPanel, (Color)color);
            SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
            simpleColoredComponent.setOpaque(true);
            jPanel.add((Component)simpleColoredComponent, "Center");
            if (value instanceof GroupNode) {
                ((GroupNode)value).getTitle(sel).customize(simpleColoredComponent);
            } else if (value instanceof CodeNode) {
                CodeNode codeNode = (CodeNode)value;
                jPanel.add((Component)DuplicatesForm.this.myButtonsPanel, "West");
                DuplicatesForm.this.mySendToLeftButton.setIcon(codeNode.isLeftInDiff() ? AllIcons.Duplicates.SendToTheLeft : AllIcons.Duplicates.SendToTheLeftGrayed);
                DuplicatesForm.this.mySendToRightButton.setIcon(codeNode.isRightInDiff() ? AllIcons.Duplicates.SendToTheRight : AllIcons.Duplicates.SendToTheRightGrayed);
                codeNode.getTitle(sel).customize(simpleColoredComponent);
                jPanel.setToolTipText(DupLocatorBundle.message((String)"tooltip.tree.text", (Object[])new Object[0]));
            }
            return jPanel;
        }
    }

    public static class SendToLeftAction
    extends SendToAction {
        private static final long b = la.a(2712685607963263348L, 8731199585428819445L, MethodHandles.lookup().lookupClass()).a(217265119664950L);

        public SendToLeftAction() {
            long l2 = b ^ 0x494A50D1BA9BL;
            super(DupLocatorBundle.message((String)"duplicates.send.to.left.action", (Object[])new Object[0]), DupLocatorBundle.message((String)"duplicates.send.to.left.action.description", (Object[])new Object[0]), AllIcons.Duplicates.SendToTheLeft, DuplicatesForm.SEND_TO_LEFT_ID, 0);
        }
    }

    public static class SendToRightAction
    extends SendToAction {
        private static final long b = la.a(-6927667728871759933L, 5847595296944765984L, MethodHandles.lookup().lookupClass()).a(22984317427409L);

        public SendToRightAction() {
            long l2 = b ^ 0x784914CA0987L;
            super(DupLocatorBundle.message((String)"duplicates.send.to.right.action", (Object[])new Object[0]), DupLocatorBundle.message((String)"duplicates.send.to.right.action.description", (Object[])new Object[0]), AllIcons.Duplicates.SendToTheRight, DuplicatesForm.SEND_TO_RIGHT_ID, 1);
        }
    }
}

