/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import a.d.la;
import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageEditorAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageOptionsProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageRunnerData;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.CoverageSuiteListener;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewSuiteListener;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.coverage.CoverageEnabledConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileContentsChangedAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.ui.UIBundle;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="com.intellij.coverage.CoverageDataManagerImpl", storages={@Storage(value="$WORKSPACE_FILE$")})
public class CoverageDataManagerImpl
extends CoverageDataManager
implements Disposable,
PersistentStateComponent<Element> {
    private final List<CoverageSuiteListener> myListeners;
    private static final Logger LOG;
    @NonNls
    private static final String SUITE = "SUITE";
    private final Project myProject;
    private final Set<CoverageSuite> myCoverageSuites;
    private boolean myIsProjectClosing;
    private final Object myLock;
    private boolean mySubCoverageIsActive;
    private final VirtualFileContentsChangedAdapter myContentListener;
    private Set<LocalFileSystem.WatchRequest> myWatchRequests;
    private List<String> myCurrentSuiteRoots;
    private CoverageSuitesBundle myCurrentSuitesBundle;
    private final Object ANNOTATORS_LOCK;
    private final Map<Editor, CoverageEditorAnnotator> myAnnotators;
    private Alarm myRequestsAlarm;
    private static final long b;

    @Override
    public CoverageSuitesBundle getCurrentSuitesBundle() {
        return this.myCurrentSuitesBundle;
    }

    public CoverageDataManagerImpl(final @NotNull Project project) {
        if (project == null) {
            CoverageDataManagerImpl.b(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myCoverageSuites = new HashSet<CoverageSuite>();
        this.myIsProjectClosing = false;
        this.myLock = new Object();
        this.myContentListener = new VirtualFileContentsChangedAdapter(){
            private static final long a = la.a(-5623898829295382749L, -1251435799230777942L, MethodHandles.lookup().lookupClass()).a(122999191806759L);

            protected void onFileChange(@NotNull VirtualFile fileOrDirectory) {
                if (fileOrDirectory == null) {
                    1.a(0);
                }
                if (CoverageDataManagerImpl.this.myCurrentSuiteRoots != null && VfsUtilCore.isUnder((String)fileOrDirectory.getPath(), CoverageDataManagerImpl.this.myCurrentSuiteRoots)) {
                    CoverageDataManagerImpl.this.myCurrentSuitesBundle.restoreCoverageData();
                    CoverageDataManagerImpl.this.a(CoverageDataManagerImpl.this.myCurrentSuitesBundle);
                }
            }

            protected void onBeforeFileChange(@NotNull VirtualFile fileOrDirectory) {
                if (fileOrDirectory == null) {
                    1.a(1);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x2B72BE10075BL;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "fileOrDirectory";
                objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onFileChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onBeforeFileChange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.ANNOTATORS_LOCK = new Object();
        this.myAnnotators = new HashMap<Editor, CoverageEditorAnnotator>();
        this.myRequestsAlarm = null;
        this.myProject = project;
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        messageBusConnection.subscribe(EditorColorsManager.TOPIC, (Object)new EditorColorsListener(){

            public void globalSchemeChange(EditorColorsScheme scheme) {
                CoverageDataManagerImpl.this.chooseSuitesBundle(CoverageDataManagerImpl.this.myCurrentSuitesBundle);
            }
        });
        CoverageViewSuiteListener coverageViewSuiteListener = this.createCoverageViewListener();
        if (coverageViewSuiteListener != null) {
            this.addSuiteListener(coverageViewSuiteListener, this);
        }
        CoverageRunner.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CoverageRunner>(){
            private static final long a = la.a(7541848018567870287L, 8526845355491494093L, MethodHandles.lookup().lookupClass()).a(30355214267624L);

            public void extensionRemoved(@NotNull CoverageRunner coverageRunner, @NotNull PluginDescriptor pluginDescriptor) {
                CoverageSuitesBundle coverageSuitesBundle;
                if (coverageRunner == null) {
                    3.a(0);
                }
                if (pluginDescriptor == null) {
                    3.a(1);
                }
                if ((coverageSuitesBundle = CoverageDataManagerImpl.this.getCurrentSuitesBundle()) != null && ContainerUtil.exists((Object[])coverageSuitesBundle.getSuites(), coverageSuite -> coverageRunner == coverageSuite.getRunner())) {
                    CoverageDataManagerImpl.this.chooseSuitesBundle(null);
                }
                RunManager runManager = RunManager.getInstance((Project)project);
                List list2 = runManager.getAllConfigurationsList();
                for (RunConfiguration runConfiguration : list2) {
                    CoverageEnabledConfiguration coverageEnabledConfiguration;
                    if (!(runConfiguration instanceof RunConfigurationBase) || (coverageEnabledConfiguration = (CoverageEnabledConfiguration)((RunConfigurationBase)runConfiguration).getCopyableUserData(CoverageEnabledConfiguration.COVERAGE_KEY)) == null || !Objects.equals(coverageRunner.getId(), coverageEnabledConfiguration.getRunnerId())) continue;
                    coverageEnabledConfiguration.coverageRunnerExtensionRemoved(coverageRunner);
                    ((RunConfigurationBase)runConfiguration).putCopyableUserData(CoverageEnabledConfiguration.COVERAGE_KEY, null);
                }
                ((RunManagerImpl)runManager).reloadSchemes();
                for (CoverageSuite coverageSuite2 : CoverageDataManagerImpl.this.getSuites()) {
                    CoverageRunner coverageRunner2;
                    if (!(coverageSuite2 instanceof BaseCoverageSuite) || (coverageRunner2 = coverageSuite2.getRunner()) != coverageRunner) continue;
                    ((BaseCoverageSuite)coverageSuite2).setRunner(null);
                }
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x72225643B752L;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "coverageRunner";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/coverage/CoverageDataManagerImpl$3";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
        CoverageEngine.EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<CoverageEngine>(){
            private static final long a = la.a(2370854951508686015L, -6202333770145138793L, MethodHandles.lookup().lookupClass()).a(234731962254472L);

            public void extensionRemoved(@NotNull CoverageEngine coverageEngine, @NotNull PluginDescriptor pluginDescriptor) {
                CoverageSuitesBundle coverageSuitesBundle;
                if (coverageEngine == null) {
                    4.a(0);
                }
                if (pluginDescriptor == null) {
                    4.a(1);
                }
                if ((coverageSuitesBundle = CoverageDataManagerImpl.this.getCurrentSuitesBundle()) != null && coverageSuitesBundle.getCoverageEngine() == coverageEngine) {
                    CoverageDataManagerImpl.this.chooseSuitesBundle(null);
                }
                CoverageDataManagerImpl.this.myCoverageSuites.removeIf(coverageSuite -> coverageSuite.getCoverageEngine() == coverageEngine);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x83416281D2BL;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "coverageEngine";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/coverage/CoverageDataManagerImpl$4";
                objectArray[2] = "extensionRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this);
    }

    @Nullable
    protected CoverageViewSuiteListener createCoverageViewListener() {
        return new CoverageViewSuiteListener(this, this.myProject);
    }

    public void loadState(@NotNull Element element) {
        long l2 = b ^ 0x75303DCD082DL;
        if (element == null) {
            CoverageDataManagerImpl.b(1);
        }
        for (Element element2 : element.getChildren(SUITE)) {
            Object object;
            CoverageRunner coverageRunner = BaseCoverageSuite.readRunnerAttribute(element2);
            if (coverageRunner == null) {
                object = BaseCoverageSuite.readDataFileProviderAttribute(element2);
                if (!object.isValid()) continue;
                continue;
            }
            object = null;
            for (CoverageEngine coverageEngine : (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions()) {
                if (!coverageRunner.acceptsCoverageEngine(coverageEngine) || (object = coverageEngine.createEmptyCoverageSuite(coverageRunner)) == null) continue;
                if (!(object instanceof BaseCoverageSuite)) break;
                ((BaseCoverageSuite)object).setProject(this.myProject);
                break;
            }
            if (object == null) continue;
            try {
                object.readExternal(element2);
                this.myCoverageSuites.add((CoverageSuite)object);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    @Nullable
    public Element getState() {
        long l2 = b ^ 0x5671FA526D81L;
        Element element = new Element("state");
        for (CoverageSuite coverageSuite : this.myCoverageSuites) {
            Element element2 = new Element(SUITE);
            element.addContent(element2);
            coverageSuite.writeExternal(element2);
        }
        return element;
    }

    @Override
    public CoverageSuite addCoverageSuite(String name, CoverageFileProvider fileProvider, String[] filters, long lastCoverageTimeStamp, @Nullable String suiteToMergeWith, CoverageRunner coverageRunner, boolean collectLineInfo, boolean tracingEnabled) {
        CoverageSuite coverageSuite = this.a(coverageRunner, name, fileProvider, filters, lastCoverageTimeStamp, suiteToMergeWith, collectLineInfo, tracingEnabled);
        if (suiteToMergeWith == null || !name.equals(suiteToMergeWith)) {
            this.removeCoverageSuite(coverageSuite);
        }
        this.myCoverageSuites.remove(coverageSuite);
        this.myCoverageSuites.add(coverageSuite);
        return coverageSuite;
    }

    @Override
    public CoverageSuite addExternalCoverageSuite(String selectedFileName, long timeStamp, CoverageRunner coverageRunner, CoverageFileProvider fileProvider) {
        CoverageSuite coverageSuite = this.a(coverageRunner, selectedFileName, fileProvider, ArrayUtilRt.EMPTY_STRING_ARRAY, timeStamp, null, false, false);
        this.myCoverageSuites.add(coverageSuite);
        return coverageSuite;
    }

    @Override
    public CoverageSuite addCoverageSuite(CoverageEnabledConfiguration config) {
        long l2 = b ^ 0x412062A06D1EL;
        String string = CoverageBundle.message("coverage.results.suite.name", config.getName());
        String string2 = config.getCoverageFilePath();
        assert (string2 != null);
        CoverageRunner coverageRunner = config.getCoverageRunner();
        LOG.assertTrue(coverageRunner != null, (Object)("Coverage runner id = " + config.getRunnerId()));
        DefaultCoverageFileProvider defaultCoverageFileProvider = new DefaultCoverageFileProvider(new File(string2));
        CoverageSuite coverageSuite = CoverageDataManagerImpl.a(config, string, coverageRunner, defaultCoverageFileProvider);
        this.removeCoverageSuite(coverageSuite);
        this.myCoverageSuites.add(coverageSuite);
        return coverageSuite;
    }

    @Override
    public void removeCoverageSuite(CoverageSuite suite) {
        suite.deleteCachedCoverageData();
        this.myCoverageSuites.remove(suite);
        if (this.myCurrentSuitesBundle != null && this.myCurrentSuitesBundle.contains(suite)) {
            Object[] objectArray = this.myCurrentSuitesBundle.getSuites();
            this.chooseSuitesBundle((objectArray = (CoverageSuite[])ArrayUtil.remove((Object[])objectArray, (Object)suite)).length > 0 ? new CoverageSuitesBundle((CoverageSuite[])objectArray) : null);
        }
    }

    @Override
    public CoverageSuite @NotNull [] getSuites() {
        CoverageSuite[] coverageSuiteArray = this.myCoverageSuites.toArray(new CoverageSuite[0]);
        if (coverageSuiteArray == null) {
            CoverageDataManagerImpl.b(2);
        }
        return coverageSuiteArray;
    }

    @Override
    public void chooseSuitesBundle(CoverageSuitesBundle suite) {
        if (this.myCurrentSuitesBundle == suite && suite == null) {
            return;
        }
        if (this.myWatchRequests != null) {
            LocalFileSystem.getInstance().removeWatchedRoots(this.myWatchRequests);
            VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myContentListener);
            this.myWatchRequests = null;
            this.myCurrentSuiteRoots = null;
        }
        this.a(suite);
    }

    private void a(CoverageSuitesBundle coverageSuitesBundle) {
        LOG.assertTrue(!this.myProject.isDefault());
        this.fireBeforeSuiteChosen();
        this.mySubCoverageIsActive = false;
        if (this.myCurrentSuitesBundle != null) {
            this.myCurrentSuitesBundle.getCoverageEngine().getCoverageAnnotator(this.myProject).onSuiteChosen(coverageSuitesBundle);
        }
        this.myCurrentSuitesBundle = coverageSuitesBundle;
        this.disposeAnnotators();
        if (coverageSuitesBundle == null) {
            this.triggerPresentationUpdate();
            return;
        }
        for (CoverageSuite coverageSuite : this.myCurrentSuitesBundle.getSuites()) {
            boolean bl2 = coverageSuite.getCoverageDataFileProvider().ensureFileExists();
            if (bl2) continue;
            this.chooseSuitesBundle(null);
            return;
        }
        this.renewCoverageData(coverageSuitesBundle);
        this.fireAfterSuiteChosen();
    }

    @Override
    public void coverageGathered(@NotNull CoverageSuite suite) {
        if (suite == null) {
            CoverageDataManagerImpl.b(3);
        }
        this.fireCoverageGathered(suite);
        ApplicationManager.getApplication().invokeLater(() -> {
            long l2 = b ^ 0xCDF93A69E3DL;
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myCurrentSuitesBundle != null) {
                int n2;
                String[] stringArray;
                String string = CoverageBundle.message("display.coverage.prompt", suite.getPresentableName());
                final CoverageOptionsProvider coverageOptionsProvider = CoverageOptionsProvider.getInstance(this.myProject);
                DialogWrapper.DoNotAskOption doNotAskOption = new DialogWrapper.DoNotAskOption(){
                    private static final long a = la.a(2213288224924329441L, -6245712861215140894L, MethodHandles.lookup().lookupClass()).a(30127522816112L);

                    public boolean isToBeShown() {
                        return coverageOptionsProvider.getOptionToReplace() == 3;
                    }

                    public void setToBeShown(boolean value, int exitCode) {
                        coverageOptionsProvider.setOptionsToReplace(value ? 3 : exitCode);
                    }

                    public boolean canBeHidden() {
                        return true;
                    }

                    public boolean shouldSaveOptionsOnCancel() {
                        return true;
                    }

                    @NotNull
                    public String getDoNotShowMessage() {
                        long l2 = a ^ 0x82E2FC0F5E2L;
                        String string = UIBundle.message((String)"dialog.options.do.not.show", (Object[])new Object[0]);
                        if (string == null) {
                            5.a(0);
                        }
                        return string;
                    }

                    private static /* synthetic */ void a(int n2) {
                        long l2 = a ^ 0xA9373B1E357L;
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageDataManagerImpl$5", "getDoNotShowMessage"));
                    }
                };
                if (this.myCurrentSuitesBundle.getCoverageEngine() == suite.getCoverageEngine()) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = CoverageBundle.message("coverage.replace.active.suites", new Object[0]);
                    stringArray2[1] = CoverageBundle.message("coverage.add.to.active.suites", new Object[0]);
                    stringArray = stringArray2;
                    stringArray2[2] = CoverageBundle.message("coverage.do.not.apply.collected.coverage", new Object[0]);
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = CoverageBundle.message("coverage.replace.active.suites", new Object[0]);
                    stringArray = stringArray3;
                    stringArray3[1] = CoverageBundle.message("coverage.do.not.apply.collected.coverage", new Object[0]);
                }
                String[] stringArray4 = stringArray;
                int n3 = n2 = doNotAskOption.isToBeShown() ? Messages.showDialog((String)string, (String)CoverageBundle.message("code.coverage", new Object[0]), (String[])stringArray4, (int)1, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption) : coverageOptionsProvider.getOptionToReplace();
                if (n2 == 0) {
                    this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
                } else if (n2 == 1) {
                    this.chooseSuitesBundle(new CoverageSuitesBundle((CoverageSuite[])ArrayUtil.append((Object[])this.myCurrentSuitesBundle.getSuites(), (Object)suite)));
                }
            } else {
                this.chooseSuitesBundle(new CoverageSuitesBundle(suite));
            }
        });
    }

    @Override
    public void triggerPresentationUpdate() {
        this.b();
        UIUtil.invokeLaterIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            ProjectView.getInstance((Project)this.myProject).refresh();
            CoverageViewManager.getInstance(this.myProject).setReady(true);
        });
    }

    @Override
    public void attachToProcess(final @NotNull ProcessHandler handler, final @NotNull RunConfigurationBase configuration, final RunnerSettings runnerSettings) {
        if (handler == null) {
            CoverageDataManagerImpl.b(4);
        }
        if (configuration == null) {
            CoverageDataManagerImpl.b(5);
        }
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private static final long a = la.a(-4490076292459248147L, 4595836625928365307L, MethodHandles.lookup().lookupClass()).a(38968390151177L);

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    6.a(0);
                }
                CoverageDataManagerImpl.this.processGatheredCoverage(configuration, runnerSettings);
                handler.removeProcessListener((ProcessListener)this);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x40853FCEBA9CL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/coverage/CoverageDataManagerImpl$6", "processTerminated"));
            }
        });
    }

    @Override
    public void processGatheredCoverage(@NotNull RunConfigurationBase configuration, RunnerSettings runnerSettings) {
        if (configuration == null) {
            CoverageDataManagerImpl.b(6);
        }
        if (runnerSettings instanceof CoverageRunnerData) {
            CoverageDataManagerImpl.processGatheredCoverage(configuration);
        }
    }

    public void addRootsToWatch(List<? extends CoverageSuite> suites) {
        this.myCurrentSuiteRoots = ContainerUtil.map(suites, coverageSuite -> coverageSuite.getCoverageDataFileName());
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        this.myCurrentSuiteRoots.forEach(string -> localFileSystem.refreshAndFindFileByPath(string));
        this.myWatchRequests = localFileSystem.addRootsToWatch(this.myCurrentSuiteRoots, true);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myContentListener);
    }

    public void dispose() {
    }

    public static void processGatheredCoverage(RunConfigurationBase configuration) {
        Project project = configuration.getProject();
        if (project.isDisposed()) {
            return;
        }
        CoverageDataManager coverageDataManager = CoverageDataManager.getInstance(project);
        CoverageEnabledConfiguration coverageEnabledConfiguration = CoverageEnabledConfiguration.getOrCreate(configuration);
        CoverageSuite coverageSuite = coverageEnabledConfiguration.getCurrentCoverageSuite();
        if (coverageSuite != null) {
            ((BaseCoverageSuite)coverageSuite).setConfiguration(configuration);
            coverageDataManager.coverageGathered(coverageSuite);
        }
    }

    protected void renewCoverageData(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.b(7);
        }
        if (this.myCurrentSuitesBundle != null) {
            this.myCurrentSuitesBundle.getCoverageEngine().getCoverageAnnotator(this.myProject).renewCoverageData(suite, this);
        }
    }

    private void b() {
        VirtualFile[] virtualFileArray;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
        for (VirtualFile virtualFile : virtualFileArray = fileEditorManager.getOpenFiles()) {
            FileEditor[] fileEditorArray = fileEditorManager.getAllEditors(virtualFile);
            this.a(fileEditorArray, virtualFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(FileEditor[] fileEditorArray, VirtualFile virtualFile) {
        PsiFile psiFile = (PsiFile)this.doInReadActionIfProjectOpen(() -> PsiManager.getInstance((Project)this.myProject).findFile(virtualFile));
        if (psiFile != null && this.myCurrentSuitesBundle != null && psiFile.isPhysical()) {
            CoverageEditorAnnotator coverageEditorAnnotator;
            Object object;
            Editor editor;
            CoverageEngine coverageEngine = this.myCurrentSuitesBundle.getCoverageEngine();
            if (!coverageEngine.coverageEditorHighlightingApplicableTo(psiFile)) {
                return;
            }
            for (FileEditor fileEditor : fileEditorArray) {
                if (!(fileEditor instanceof TextEditor)) continue;
                editor = ((TextEditor)fileEditor).getEditor();
                object = this.ANNOTATORS_LOCK;
                synchronized (object) {
                    coverageEditorAnnotator = this.myAnnotators.remove(editor);
                }
                if (coverageEditorAnnotator == null) break;
                Disposer.dispose((Disposable)coverageEditorAnnotator);
                break;
            }
            for (FileEditor fileEditor : fileEditorArray) {
                if (!(fileEditor instanceof TextEditor)) continue;
                editor = ((TextEditor)fileEditor).getEditor();
                coverageEditorAnnotator = this.getAnnotator(editor);
                if (coverageEditorAnnotator == null) {
                    coverageEditorAnnotator = coverageEngine.createSrcFileAnnotator(psiFile, editor);
                    object = this.ANNOTATORS_LOCK;
                    synchronized (object) {
                        this.myAnnotators.put(editor, coverageEditorAnnotator);
                    }
                }
                if (this.myCurrentSuitesBundle == null || !coverageEngine.acceptedByFilters(psiFile, this.myCurrentSuitesBundle)) continue;
                coverageEditorAnnotator.showCoverage(this.myCurrentSuitesBundle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T doInReadActionIfProjectOpen(Computable<T> computation) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myIsProjectClosing) {
                return null;
            }
        }
        return (T)ApplicationManager.getApplication().runReadAction(computation);
    }

    @Override
    public void selectSubCoverage(@NotNull CoverageSuitesBundle suite, List<String> testNames) {
        if (suite == null) {
            CoverageDataManagerImpl.b(8);
        }
        suite.restoreCoverageData();
        ProjectData projectData = suite.getCoverageData();
        if (projectData == null) {
            return;
        }
        this.mySubCoverageIsActive = true;
        HashMap<String, Set<Integer>> hashMap = new HashMap<String, Set<Integer>>();
        for (CoverageSuite coverageSuite : suite.getSuites()) {
            suite.getCoverageEngine().collectTestLines(testNames, coverageSuite, hashMap);
        }
        ProjectData projectData2 = new ProjectData();
        for (String string : hashMap.keySet()) {
            Object object2;
            CoverageSuite coverageSuite;
            coverageSuite = projectData2.getClassData(string);
            if (coverageSuite == null) {
                coverageSuite = projectData2.getOrCreateClassData(string);
            }
            Set set = (Set)hashMap.get(string);
            ClassData classData = projectData.getClassData(string);
            LOG.assertTrue(classData != null, (Object)("missed className: \"" + string + "\""));
            Object[] objectArray = classData.getLines();
            LOG.assertTrue(objectArray != null);
            int n2 = objectArray.length;
            for (Object object2 : set) {
                if ((Integer)object2 < n2) continue;
                n2 = (Integer)object2 + 1;
            }
            LineData[] lineDataArray = new LineData[n2];
            object2 = set.iterator();
            while (object2.hasNext()) {
                LineData lineData;
                Integer n3 = (Integer)object2.next();
                int n4 = n3 - 1;
                String string2 = null;
                if (n4 < classData.getLines().length && (lineData = classData.getLineData(n4)) != null) {
                    string2 = lineData.getMethodSignature();
                }
                lineData = new LineData(n4, string2);
                if (string2 != null) {
                    coverageSuite.registerMethodSignature(lineData);
                }
                lineData.setStatus((byte)2);
                lineDataArray[n4] = lineData;
            }
            coverageSuite.setLines(lineDataArray);
        }
        suite.setCoverageData(projectData2);
        this.renewCoverageData(suite);
    }

    @Override
    public void restoreMergedCoverage(@NotNull CoverageSuitesBundle suite) {
        if (suite == null) {
            CoverageDataManagerImpl.b(9);
        }
        this.mySubCoverageIsActive = false;
        suite.restoreCoverageData();
        this.renewCoverageData(suite);
    }

    @Override
    public void addSuiteListener(final @NotNull CoverageSuiteListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            CoverageDataManagerImpl.b(10);
        }
        if (parentDisposable == null) {
            CoverageDataManagerImpl.b(11);
        }
        this.myListeners.add(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                CoverageDataManagerImpl.this.myListeners.remove(listener);
            }
        });
    }

    public void fireCoverageGathered(@NotNull CoverageSuite suite) {
        if (suite == null) {
            CoverageDataManagerImpl.b(12);
        }
        for (CoverageSuiteListener coverageSuiteListener : this.myListeners) {
            coverageSuiteListener.coverageGathered(suite);
        }
    }

    public void fireBeforeSuiteChosen() {
        for (CoverageSuiteListener coverageSuiteListener : this.myListeners) {
            coverageSuiteListener.beforeSuiteChosen();
        }
    }

    public void fireAfterSuiteChosen() {
        for (CoverageSuiteListener coverageSuiteListener : this.myListeners) {
            coverageSuiteListener.afterSuiteChosen();
        }
    }

    @Override
    public boolean isSubCoverageActive() {
        return this.mySubCoverageIsActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CoverageEditorAnnotator getAnnotator(Editor editor) {
        Object object = this.ANNOTATORS_LOCK;
        synchronized (object) {
            return this.myAnnotators.get(editor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeAnnotators() {
        Object object = this.ANNOTATORS_LOCK;
        synchronized (object) {
            for (CoverageEditorAnnotator coverageEditorAnnotator : this.myAnnotators.values()) {
                if (coverageEditorAnnotator == null) continue;
                Disposer.dispose((Disposable)coverageEditorAnnotator);
            }
            this.myAnnotators.clear();
        }
    }

    @NotNull
    private static CoverageSuite a(CoverageEnabledConfiguration coverageEnabledConfiguration, String string, CoverageRunner coverageRunner, DefaultCoverageFileProvider defaultCoverageFileProvider) {
        CoverageEngine coverageEngine;
        CoverageSuite coverageSuite = null;
        CoverageEngine[] coverageEngineArray = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int n2 = coverageEngineArray.length;
        for (int i10 = 0; !(i10 >= n2 || coverageRunner.acceptsCoverageEngine(coverageEngine = coverageEngineArray[i10]) && coverageEngine.isApplicableTo(coverageEnabledConfiguration.getConfiguration()) && (coverageSuite = coverageEngine.createCoverageSuite(coverageRunner, string, defaultCoverageFileProvider, coverageEnabledConfiguration)) != null); ++i10) {
        }
        LOG.assertTrue(coverageSuite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        CoverageSuite coverageSuite2 = coverageSuite;
        if (coverageSuite2 == null) {
            CoverageDataManagerImpl.b(13);
        }
        return coverageSuite2;
    }

    @NotNull
    private CoverageSuite a(CoverageRunner coverageRunner, String string, CoverageFileProvider coverageFileProvider, String[] stringArray, long l2, String string2, boolean bl2, boolean bl3) {
        CoverageEngine coverageEngine;
        CoverageSuite coverageSuite = null;
        CoverageEngine[] coverageEngineArray = (CoverageEngine[])CoverageEngine.EP_NAME.getExtensions();
        int n2 = coverageEngineArray.length;
        for (int i10 = 0; !(i10 >= n2 || coverageRunner.acceptsCoverageEngine(coverageEngine = coverageEngineArray[i10]) && (coverageSuite = coverageEngine.createCoverageSuite(coverageRunner, string, coverageFileProvider, stringArray, l2, string2, bl2, bl3, false, this.myProject)) != null); ++i10) {
        }
        LOG.assertTrue(coverageSuite != null, (Object)("Cannot create coverage suite for runner: " + coverageRunner.getPresentableName()));
        CoverageSuite coverageSuite2 = coverageSuite;
        if (coverageSuite2 == null) {
            CoverageDataManagerImpl.b(14);
        }
        return coverageSuite2;
    }

    static {
        b = la.a(7359424735831255177L, 2589276547669288969L, MethodHandles.lookup().lookupClass()).a(230652281700208L);
        LOG = Logger.getInstance(CoverageDataManagerImpl.class);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x5F518ACC90BDL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/coverage/CoverageDataManagerImpl";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suite";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuites";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createCoverageSuite";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "coverageGathered";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "attachToProcess";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processGatheredCoverage";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "renewCoverageData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectSubCoverage";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "restoreMergedCoverage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addSuiteListener";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fireCoverageGathered";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class CoverageProjectManagerListener
    implements ProjectManagerListener {
        private static final long a = la.a(1261207636990957417L, 977058626953939603L, MethodHandles.lookup().lookupClass()).a(226147229491661L);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void projectClosing(@NotNull Project project) {
            if (project == null) {
                CoverageProjectManagerListener.a(0);
            }
            CoverageDataManagerImpl coverageDataManagerImpl = (CoverageDataManagerImpl)CoverageDataManager.getInstance(project);
            Object object = coverageDataManagerImpl.myLock;
            synchronized (object) {
                coverageDataManagerImpl.myIsProjectClosing = true;
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x6E1473199289L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/coverage/CoverageDataManagerImpl$CoverageProjectManagerListener", "projectClosing"));
        }
    }

    public static class CoverageEditorFactoryListener
    implements EditorFactoryListener {
        private final Map<Editor, Runnable> myCurrentEditors = new HashMap<Editor, Runnable>();
        private static final long a = la.a(7534543608362022682L, 5587792889357848071L, MethodHandles.lookup().lookupClass()).a(191393191809478L);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            PsiFile psiFile;
            Editor editor;
            Project project;
            if (event == null) {
                CoverageEditorFactoryListener.a(0);
            }
            if ((project = (editor = event.getEditor()).getProject()) == null) {
                return;
            }
            CoverageDataManagerImpl coverageDataManagerImpl = (CoverageDataManagerImpl)CoverageDataManager.getInstance(project);
            if (coverageDataManagerImpl.myCurrentSuitesBundle != null && (psiFile = (PsiFile)ReadAction.compute(() -> {
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
                Document document = editor.getDocument();
                return psiDocumentManager.getPsiFile(document);
            })) != null && psiFile.isPhysical()) {
                CoverageEngine coverageEngine = coverageDataManagerImpl.myCurrentSuitesBundle.getCoverageEngine();
                if (!coverageEngine.coverageEditorHighlightingApplicableTo(psiFile)) {
                    return;
                }
                CoverageEditorAnnotator coverageEditorAnnotator = coverageDataManagerImpl.getAnnotator(editor);
                if (coverageEditorAnnotator == null) {
                    coverageEditorAnnotator = coverageEngine.createSrcFileAnnotator(psiFile, editor);
                }
                CoverageEditorAnnotator coverageEditorAnnotator2 = coverageEditorAnnotator;
                Object object = coverageDataManagerImpl.ANNOTATORS_LOCK;
                synchronized (object) {
                    coverageDataManagerImpl.myAnnotators.put(editor, coverageEditorAnnotator2);
                }
                object = () -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    CoverageSuitesBundle coverageSuitesBundle = coverageDataManagerImpl.myCurrentSuitesBundle;
                    if (coverageSuitesBundle != null && coverageEngine.acceptedByFilters(psiFile, coverageSuitesBundle)) {
                        coverageEditorAnnotator2.showCoverage(coverageSuitesBundle);
                    }
                };
                this.myCurrentEditors.put(editor, (Runnable)object);
                CoverageEditorFactoryListener.a(coverageDataManagerImpl).addRequest((Runnable)object, 100);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Editor editor;
            Project project;
            if (event == null) {
                CoverageEditorFactoryListener.a(1);
            }
            if ((project = (editor = event.getEditor()).getProject()) == null) {
                return;
            }
            CoverageDataManagerImpl coverageDataManagerImpl = (CoverageDataManagerImpl)project.getServiceIfCreated(CoverageDataManagerImpl.class);
            try {
                CoverageEditorAnnotator coverageEditorAnnotator;
                if (coverageDataManagerImpl == null) {
                    return;
                }
                Object object = coverageDataManagerImpl.ANNOTATORS_LOCK;
                synchronized (object) {
                    coverageEditorAnnotator = coverageDataManagerImpl.myAnnotators.remove(editor);
                }
                if (coverageEditorAnnotator != null) {
                    Disposer.dispose((Disposable)coverageEditorAnnotator);
                }
            }
            finally {
                Runnable runnable = this.myCurrentEditors.remove(editor);
                if (runnable != null && coverageDataManagerImpl != null) {
                    CoverageEditorFactoryListener.a(coverageDataManagerImpl).cancelRequest(runnable);
                }
            }
        }

        @RequiresEdt
        private static Alarm a(@NotNull CoverageDataManagerImpl coverageDataManagerImpl) {
            Alarm alarm;
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (coverageDataManagerImpl == null) {
                CoverageEditorFactoryListener.a(2);
            }
            if ((alarm = coverageDataManagerImpl.myRequestsAlarm) == null) {
                coverageDataManagerImpl.myRequestsAlarm = alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)coverageDataManagerImpl);
            }
            return alarm;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = a ^ 0x2C9EA305E9A4L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/coverage/CoverageDataManagerImpl$CoverageEditorFactoryListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "editorReleased";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRequestsAlarm";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

