/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.launcher.core;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.gradle.internal.impldep.org.junit.platform.commons.PreconditionViolationException;
import org.gradle.internal.impldep.org.junit.platform.commons.logging.Logger;
import org.gradle.internal.impldep.org.junit.platform.commons.logging.LoggerFactory;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestIdentifier;
import org.gradle.internal.impldep.org.junit.platform.launcher.TestPlan;
import org.gradle.internal.impldep.org.junit.platform.launcher.core.LauncherDiscoveryResult;

class InternalTestPlan
extends TestPlan {
    private static final Logger logger = LoggerFactory.getLogger(InternalTestPlan.class);
    private final AtomicBoolean executionStarted = new AtomicBoolean(false);
    private final AtomicBoolean warningEmitted = new AtomicBoolean(false);
    private final LauncherDiscoveryResult discoveryResult;
    private final TestPlan delegate;

    static InternalTestPlan from(LauncherDiscoveryResult discoveryResult) {
        TestPlan delegate = TestPlan.from(discoveryResult.getEngineTestDescriptors());
        return new InternalTestPlan(discoveryResult, delegate);
    }

    private InternalTestPlan(LauncherDiscoveryResult discoveryResult, TestPlan delegate) {
        super(delegate.containsTests());
        this.discoveryResult = discoveryResult;
        this.delegate = delegate;
    }

    void markStarted() {
        if (!this.executionStarted.compareAndSet(false, true)) {
            throw new PreconditionViolationException("TestPlan must only be executed once");
        }
    }

    LauncherDiscoveryResult getDiscoveryResult() {
        return this.discoveryResult;
    }

    @Override
    public void add(TestIdentifier testIdentifier) {
        if (this.warningEmitted.compareAndSet(false, true)) {
            logger.warn(() -> "Attempt to modify the TestPlan was detected. A future version of the JUnit Platform will ignore this call and eventually even throw an exception. Please contact your IDE/tool vendor and request a fix (see https://github.com/junit-team/junit5/issues/1732 for details).");
        }
        this.addInternal(testIdentifier);
    }

    void addInternal(TestIdentifier testIdentifier) {
        this.delegate.add(testIdentifier);
    }

    @Override
    public Set<TestIdentifier> getRoots() {
        return this.delegate.getRoots();
    }

    @Override
    public Optional<TestIdentifier> getParent(TestIdentifier child) {
        return this.delegate.getParent(child);
    }

    @Override
    public Set<TestIdentifier> getChildren(TestIdentifier parent) {
        return this.delegate.getChildren(parent);
    }

    @Override
    public Set<TestIdentifier> getChildren(String parentId) {
        return this.delegate.getChildren(parentId);
    }

    @Override
    public TestIdentifier getTestIdentifier(String uniqueId) throws PreconditionViolationException {
        return this.delegate.getTestIdentifier(uniqueId);
    }

    @Override
    public long countTestIdentifiers(Predicate<? super TestIdentifier> predicate) {
        return this.delegate.countTestIdentifiers(predicate);
    }

    @Override
    public Set<TestIdentifier> getDescendants(TestIdentifier parent) {
        return this.delegate.getDescendants(parent);
    }

    @Override
    public boolean containsTests() {
        return this.delegate.containsTests();
    }
}

