/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import org.gradle.api.internal.StartParameterInternal;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.session.BuildSessionState;
import org.gradle.internal.session.CrossBuildSessionState;
import org.gradle.launcher.exec.BuildActionExecuter;
import org.gradle.launcher.exec.BuildActionParameters;
import org.gradle.launcher.exec.BuildActionResult;
import org.gradle.tooling.internal.provider.serialization.PayloadSerializer;

public class BuildSessionLifecycleBuildActionExecuter
implements BuildActionExecuter<BuildActionParameters, BuildRequestContext> {
    private final ServiceRegistry globalServices;
    private final GradleUserHomeScopeServiceRegistry userHomeServiceRegistry;

    public BuildSessionLifecycleBuildActionExecuter(GradleUserHomeScopeServiceRegistry userHomeServiceRegistry, ServiceRegistry globalServices) {
        this.userHomeServiceRegistry = userHomeServiceRegistry;
        this.globalServices = globalServices;
    }

    @Override
    public BuildActionResult execute(BuildAction action, BuildActionParameters actionParameters, BuildRequestContext requestContext) {
        StartParameterInternal startParameter = action.getStartParameter();
        if (action.isCreateModel()) {
            startParameter.setContinuous(false);
        }
        try (CrossBuildSessionState crossBuildSessionState = new CrossBuildSessionState(this.globalServices, startParameter);){
            BuildSessionState buildSessionState = new BuildSessionState(this.userHomeServiceRegistry, crossBuildSessionState, startParameter, requestContext, actionParameters.getInjectedPluginClasspath(), requestContext.getCancellationToken(), requestContext.getClient(), requestContext.getEventConsumer());
            try {
                BuildActionResult buildActionResult = buildSessionState.run(context -> {
                    BuildActionRunner.Result result = context.execute(action);
                    PayloadSerializer payloadSerializer = context.getServices().get(PayloadSerializer.class);
                    if (result.getBuildFailure() == null) {
                        return BuildActionResult.of(payloadSerializer.serialize(result.getClientResult()));
                    }
                    if (requestContext.getCancellationToken().isCancellationRequested()) {
                        return BuildActionResult.cancelled(payloadSerializer.serialize(result.getBuildFailure()));
                    }
                    return BuildActionResult.failed(payloadSerializer.serialize(result.getClientFailure()));
                });
                buildSessionState.close();
                return buildActionResult;
            }
            catch (Throwable throwable) {
                try {
                    buildSessionState.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

