/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.descriptor;

import java.util.Collection;
import java.util.List;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.util.internal.CollectionUtils;

public class Configuration {
    private final String name;
    private final boolean transitive;
    private final boolean visible;
    private final List<String> extendsFrom;

    public Configuration(String name, boolean transitive, boolean visible, Collection<String> extendsFrom) {
        this.name = name;
        this.transitive = transitive;
        this.visible = visible;
        this.extendsFrom = CollectionUtils.toList(extendsFrom);
    }

    public String getName() {
        return this.name;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public List<String> getExtendsFrom() {
        return this.extendsFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.transitive == that.transitive && this.visible == that.visible && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal(this.extendsFrom, that.extendsFrom);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.transitive, this.visible, this.extendsFrom});
    }
}

