/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

class NegationCountVisitor
extends JSRecursiveElementVisitor {
    private int negationCount = 0;

    NegationCountVisitor() {
    }

    @Override
    public void visitJSElement(JSElement jsElement) {
        int oldCount = 0;
        if (jsElement instanceof JSFunction) {
            oldCount = this.negationCount;
        }
        super.visitJSElement(jsElement);
        if (jsElement instanceof JSFunction) {
            this.negationCount = oldCount;
        }
    }

    @Override
    public void visitJSBinaryExpression(@NotNull JSBinaryExpression expression) {
        if (expression == null) {
            NegationCountVisitor.$$$reportNull$$$0(0);
        }
        super.visitJSBinaryExpression(expression);
        IElementType sign = expression.getOperationSign();
        if (JSTokenTypes.NE.equals(sign) || JSTokenTypes.NEQEQ.equals(sign)) {
            ++this.negationCount;
        }
    }

    @Override
    public void visitJSPrefixExpression(@NotNull JSPrefixExpression expression) {
        if (expression == null) {
            NegationCountVisitor.$$$reportNull$$$0(1);
        }
        super.visitJSPrefixExpression(expression);
        IElementType sign = expression.getOperationSign();
        if (JSTokenTypes.EXCL.equals(sign)) {
            ++this.negationCount;
        }
    }

    public int getNegationCount() {
        return this.negationCount;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expression";
        objectArray2[1] = "com/sixrr/inspectjs/functionmetrics/NegationCountVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSBinaryExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitJSPrefixExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

