/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import java.util.concurrent.atomic.AtomicLongArray;

public final class AtomicLongRingArray {
    private static final int CACHE_SIZE = 5;
    private final AtomicLongArray myElements = new AtomicLongArray(5);

    public boolean hasLong(long id) {
        for (int i2 = 0; i2 < this.myElements.length(); ++i2) {
            long stored = this.myElements.get(i2);
            if (stored != id) continue;
            return true;
        }
        return false;
    }

    public synchronized void addLong(long id) {
        for (int i2 = 0; i2 < this.myElements.length(); ++i2) {
            long current = this.myElements.get(i2);
            if (current == id) {
                return;
            }
            if (current != 0L) continue;
            this.myElements.set(i2, id);
            if (i2 < 4) {
                this.myElements.set(i2 + 1, 0L);
            } else {
                this.myElements.set(0, 0L);
            }
            return;
        }
    }
}

