/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.JSImportCandidateDescriptor;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.ModuleReferenceInfo;
import com.intellij.lang.javascript.modules.imports.JSImportAction;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.JSPlaceElementFilter;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class NodeJSModulesSearcher {
    @NotNull
    private final ModuleReferenceInfo myModuleReferenceInfo;
    @NotNull
    private final PsiElement myNode;
    private final ResolveResult @NotNull [] myResolveResults;
    @NotNull
    private final Set<VirtualFile> myPredefinedFiles;

    public NodeJSModulesSearcher(@NotNull ModuleReferenceInfo info, @NotNull PsiElement node, ResolveResult @NotNull [] results, @NotNull Set<VirtualFile> predefinedFiles) {
        if (info == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(0);
        }
        if (node == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(1);
        }
        if (predefinedFiles == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(2);
        }
        if (results == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(3);
        }
        this.myModuleReferenceInfo = info;
        this.myNode = node;
        this.myResolveResults = results;
        this.myPredefinedFiles = predefinedFiles;
    }

    @NotNull
    public List<? extends JSImportCandidate> find() {
        if (this.hasGlobalResolvedElement()) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                NodeJSModulesSearcher.$$$reportNull$$$0(4);
            }
            return list2;
        }
        String referenceName = this.myModuleReferenceInfo.getContextName();
        if (StringUtil.isEmpty((String)referenceName)) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                NodeJSModulesSearcher.$$$reportNull$$$0(5);
            }
            return list3;
        }
        List<? extends JSImportCandidate> list4 = this.processForName(referenceName);
        if (list4 == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(6);
        }
        return list4;
    }

    private List<? extends JSImportCandidate> processForName(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(7);
        }
        ArrayList<JSImportCandidate> indexCandidates = new ArrayList<JSImportCandidate>(this.getFromProviders(referenceName));
        this.addShortModulesFor(indexCandidates);
        return indexCandidates;
    }

    public void addShortModulesFor(@NotNull List<JSImportCandidate> fixDescriptors) {
        if (fixDescriptors == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(8);
        }
        if (fixDescriptors.isEmpty()) {
            return;
        }
        ArrayList<JSImportCandidate> descriptors = new ArrayList<JSImportCandidate>(fixDescriptors);
        Set existingPaths = descriptors.stream().flatMap(candidate -> candidate.getDescriptors().stream()).map(el -> el.getModuleName()).collect(Collectors.toSet());
        for (JSImportCandidate candidate2 : descriptors) {
            JSImportCandidateDescriptor newDescriptor;
            VirtualFile libModuleRoot;
            VirtualFile file2;
            int idx;
            String key;
            String path2;
            JSImportDescriptor descriptor2 = candidate2.getSingleDescriptorOrNull();
            if (descriptor2 == null || candidate2.getSourceType() == JSImportCandidate.SourceType.ES6 || (path2 = descriptor2.getModuleName()).startsWith(".") || path2.startsWith("/") || FileUtil.isAbsolute((String)path2) || existingPaths.contains(key = (idx = path2.indexOf(47)) > 0 ? path2.substring(0, idx) : path2) || key.isEmpty() || "react".equalsIgnoreCase(key) || (file2 = candidate2.getElementFile()) == null || (libModuleRoot = JSLibraryUtil.getLibraryFolder(file2, "node_modules")) == null) continue;
            Pair<Boolean, NodeModuleSearchUtil.ModuleMainFiles> moduleInPackage = NodeModuleSearchUtil.findMainModuleInPackage(libModuleRoot);
            NodeModuleSearchUtil.ModuleMainFiles mainFiles = (NodeModuleSearchUtil.ModuleMainFiles)moduleInPackage.getSecond();
            VirtualFile selectedMainFile = mainFiles.getMain();
            if (!file2.equals(selectedMainFile) && mainFiles.getJsNextMain() != null) {
                selectedMainFile = mainFiles.getJsNextMain();
            }
            if (selectedMainFile == null) continue;
            existingPaths.add(key);
            if (this.myModuleReferenceInfo.getParentName() == null) {
                String target = descriptor2.getExportedName();
                if (target == null) {
                    target = descriptor2.getImportedName();
                }
                newDescriptor = new JSImportCandidateDescriptor(candidate2.getSourceType(), key, descriptor2.getImportedName(), target, descriptor2.getImportExportPrefixKind(), descriptor2.getImportType());
            } else {
                newDescriptor = new JSImportCandidateDescriptor(candidate2.getSourceType(), key, descriptor2.getImportedName(), null, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT, (JSImportExportType)ES6ImportPsiUtil.ImportExportType.IMPORT_BINDING_ALL);
            }
            fixDescriptors.add(newDescriptor);
        }
    }

    public boolean hasGlobalResolvedElement() {
        for (ResolveResult result2 : this.myResolveResults) {
            PsiFile file2;
            PsiElement element = result2.getElement();
            if (element == null || (file2 = element.getContainingFile()) == null || !file2.isValid() || !this.myPredefinedFiles.contains(file2.getVirtualFile()) || !(element instanceof JSQualifiedNamedElement) || ((JSQualifiedNamedElement)element).getNamespace() != null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private List<? extends JSImportCandidate> getFromProviders(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(9);
        }
        List<? extends JSImportCandidate> list2 = new JSImportAction(null, referenceName, new JSImportPlaceInfo(this.myNode, this.myResolveResults), JSPlaceElementFilter.DEFAULT_FILTER).getFilteredCandidates();
        if (list2 == null) {
            NodeJSModulesSearcher.$$$reportNull$$$0(10);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/NodeJSModulesSearcher";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/NodeJSModulesSearcher";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processForName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addShortModulesFor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFromProviders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

