/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.linter.GlobPatternUtil;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.lang.javascript.linter.JSLinterUtil;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EslintUtil {
    public static final String DEFAULT_IGNORE_FILENAME = ".eslintignore";
    public static final String CONFIG_SECTION_NAME = "eslintConfig";
    public static final String ESLINTIGNORE_PACKAGE_SECTION_NAME = "eslintIgnore";
    public static final String PACKAGE_NAME = "eslint";
    public static final String DEFAULT_CONFIG_PREFIX = ".eslintrc";
    private static final String[] CONFIG_EXTENSIONS = new String[]{"", ".js", ".yaml", ".yml", ".json"};
    private static final String[] CONFIG_FILENAMES = new String[CONFIG_EXTENSIONS.length];
    private static final String[] CONFIG_FILENAMES_WITH_PACKAGE_JSON = new String[CONFIG_EXTENSIONS.length + 1];

    private EslintUtil() {
    }

    public static boolean isEslintConfigFile(@NotNull PsiElement element) {
        PsiFile file2;
        if (element == null) {
            EslintUtil.$$$reportNull$$$0(0);
        }
        if ((file2 = element.getContainingFile()) != null) {
            file2 = file2.getOriginalFile();
        }
        return file2 != null && EslintUtil.isEslintConfigFile(file2);
    }

    public static boolean isEslintConfigFile(@NotNull PsiFile file2) {
        if (file2 == null) {
            EslintUtil.$$$reportNull$$$0(1);
        }
        return EslintUtil.isEslintConfigFile(file2.getViewProvider().getVirtualFile());
    }

    public static boolean isEslintConfigFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EslintUtil.$$$reportNull$$$0(2);
        }
        if (!file2.isValid() || file2.isDirectory()) {
            return false;
        }
        CharSequence name = file2.getNameSequence();
        if (StringUtil.startsWith((CharSequence)name, (CharSequence)DEFAULT_CONFIG_PREFIX)) {
            for (String ext : CONFIG_EXTENSIONS) {
                if (name.length() != DEFAULT_CONFIG_PREFIX.length() + ext.length() || !StringUtil.endsWith((CharSequence)name, (CharSequence)ext)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static List<VirtualFile> findAllConfigsWithPackageJsonUpFileSystem(@NotNull VirtualFile fileToLint) {
        if (fileToLint == null) {
            EslintUtil.$$$reportNull$$$0(3);
        }
        List<VirtualFile> list2 = JSLinterConfigFileUtil.findAllFilesUpToFileSystemRoot(fileToLint, CONFIG_FILENAMES_WITH_PACKAGE_JSON);
        if (list2 == null) {
            EslintUtil.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public static List<VirtualFile> findAllConfigsInScope(@NotNull Project project) {
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(5);
        }
        List<VirtualFile> list2 = JSLinterConfigFileUtil.findAllConfigs(project, CONFIG_FILENAMES);
        if (list2 == null) {
            EslintUtil.$$$reportNull$$$0(6);
        }
        return list2;
    }

    public static boolean hasConfigFiles(@NotNull Project project) {
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(7);
        }
        return JSLinterConfigFileUtil.hasConfigFiles(project, CONFIG_FILENAMES);
    }

    @Nullable
    public static JsonObject getConfigRootObject(@NotNull PsiFile configFile) {
        JsonObject eslintRootObject;
        if (configFile == null) {
            EslintUtil.$$$reportNull$$$0(8);
        }
        JsonObject jsonObject = eslintRootObject = configFile instanceof JsonFile ? JsonUtil.getTopLevelObject((JsonFile)((JsonFile)configFile)) : null;
        if (eslintRootObject != null && PackageJsonUtil.isPackageJsonFile(configFile)) {
            eslintRootObject = (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)eslintRootObject, (String)CONFIG_SECTION_NAME, JsonObject.class);
        }
        return eslintRootObject;
    }

    @Nullable
    public static VirtualFile findDistinctConfigInContentRoots(@NotNull Project project) {
        if (project == null) {
            EslintUtil.$$$reportNull$$$0(9);
        }
        return JSLinterConfigFileUtil.findDistinctConfigInContentRoots(project, Arrays.asList(CONFIG_FILENAMES_WITH_PACKAGE_JSON), (Condition<? super VirtualFile>)((Condition)file2 -> {
            if (PackageJsonUtil.isPackageJsonFile(file2)) {
                return PackageJsonData.getOrCreate(file2).getTopLevelProperties().contains(CONFIG_SECTION_NAME);
            }
            return true;
        }));
    }

    @Nullable
    public static VirtualFile lookupIgnoreFile(@NotNull VirtualFile virtualFile, @NotNull VirtualFile stopAt) {
        if (virtualFile == null) {
            EslintUtil.$$$reportNull$$$0(10);
        }
        if (stopAt == null) {
            EslintUtil.$$$reportNull$$$0(11);
        }
        return JSLinterConfigFileUtil.findFileUpToRoot(virtualFile, new String[]{DEFAULT_IGNORE_FILENAME}, stopAt);
    }

    public static boolean isPossiblyAcceptableFileType(@NotNull PsiFile file2) {
        if (file2 == null) {
            EslintUtil.$$$reportNull$$$0(12);
        }
        return EslintUtil.getFileKind(file2) != null;
    }

    @Nullable
    public static FileKind getFileKind(@NotNull PsiFile psiFile) {
        String additionalExtensions;
        VirtualFile virtualFile;
        if (psiFile == null) {
            EslintUtil.$$$reportNull$$$0(13);
        }
        if ((virtualFile = psiFile.getVirtualFile()) == null) {
            return null;
        }
        try {
            additionalExtensions = Registry.stringValue((String)"eslint.additional.file.extensions");
        }
        catch (MissingResourceException e) {
            additionalExtensions = null;
        }
        if (!StringUtil.isEmpty((String)additionalExtensions)) {
            String fileExtension = virtualFile.getExtension();
            for (String extension : additionalExtensions.split(",")) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)(extension = StringUtil.trimStart((String)StringUtil.trim((String)extension), (String)".")), (CharSequence)fileExtension)) continue;
                return FileKind.JavaScriptAndOther;
            }
        }
        String filesPattern = ((EslintState)EslintConfiguration.getInstance(psiFile.getProject()).getExtendedState().getState()).getFilesPattern();
        if (!GlobPatternUtil.isFileMatchingGlobPattern(psiFile.getProject(), filesPattern, virtualFile)) {
            return null;
        }
        FileType fileType = psiFile.getFileType();
        if (TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(fileType)) {
            return FileKind.TypeScript;
        }
        if (JSLinterUtil.isPureHtmlFile(psiFile)) {
            return FileKind.Html;
        }
        if (JSLinterUtil.isVueFile(psiFile)) {
            if (virtualFile.getFileType() == HtmlFileType.INSTANCE) {
                return FileKind.Html;
            }
            return FileKind.Vue;
        }
        return FileKind.JavaScriptAndOther;
    }

    static {
        for (int i2 = 0; i2 < CONFIG_EXTENSIONS.length; ++i2) {
            EslintUtil.CONFIG_FILENAMES[i2] = DEFAULT_CONFIG_PREFIX + CONFIG_EXTENSIONS[i2];
            EslintUtil.CONFIG_FILENAMES_WITH_PACKAGE_JSON[i2] = CONFIG_FILENAMES[i2];
        }
        EslintUtil.CONFIG_FILENAMES_WITH_PACKAGE_JSON[EslintUtil.CONFIG_FILENAMES_WITH_PACKAGE_JSON.length - 1] = "package.json";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToLint";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EslintUtil";
                break;
            }
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EslintUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllConfigsWithPackageJsonUpFileSystem";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllConfigsInScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEslintConfigFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAllConfigsWithPackageJsonUpFileSystem";
                break;
            }
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAllConfigsInScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getConfigRootObject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findDistinctConfigInContentRoots";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lookupIgnoreFile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isPossiblyAcceptableFileType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getFileKind";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum FileKind {
        TypeScript("ts"),
        Html("html"),
        Vue("vue"),
        JavaScriptAndOther("js_and_other");

        private final String myStringValue;

        private FileKind(String stringValue) {
            this.myStringValue = stringValue;
        }

        public String getStringValue() {
            return this.myStringValue;
        }
    }
}

