/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.json.JsonFileType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleTypeWithWebFeatures;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCreateConfigFileAction
extends AnAction
implements DumbAware {
    public static final String TSCONFIG_JSON = "tsconfig.json";

    public TypeScriptCreateConfigFileAction() {
        super(JavaScriptBundle.message("dialog.kind.0.file", TSCONFIG_JSON), JavaScriptBundle.message("action.creates.new.file.description", TSCONFIG_JSON), JsonFileType.INSTANCE.getIcon());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiDirectory psiDir;
        if (e == null) {
            TypeScriptCreateConfigFileAction.$$$reportNull$$$0(0);
        }
        if ((psiDir = TypeScriptCreateConfigFileAction.getPsiDirectory(e)) != null) {
            TypeScriptCreateConfigFileAction.createConfigFile(psiDir);
        }
    }

    private static PsiFile createConfigFile(PsiDirectory psiDir) {
        FileTemplate template = FileTemplateManager.getInstance((Project)psiDir.getProject()).getInternalTemplate(TSCONFIG_JSON);
        return CreateFileFromTemplateAction.createFileFromTemplate((String)TSCONFIG_JSON, (FileTemplate)template, (PsiDirectory)psiDir, null, (boolean)true);
    }

    public void update(@NotNull AnActionEvent e) {
        VirtualFile virtualDir;
        PsiDirectory psiDir;
        Module module;
        if (e == null) {
            TypeScriptCreateConfigFileAction.$$$reportNull$$$0(1);
        }
        if ((module = (Module)e.getData(LangDataKeys.MODULE)) == null || !ModuleTypeWithWebFeatures.isAvailable((Module)module)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean available = false;
        Project project = e.getProject();
        if (project != null && (psiDir = TypeScriptCreateConfigFileAction.getPsiDirectory(e)) != null && (virtualDir = psiDir.getVirtualFile()).isDirectory() && virtualDir.findChild(TSCONFIG_JSON) == null) {
            available = true;
        }
        e.getPresentation().setEnabledAndVisible(available);
    }

    @Nullable
    private static PsiDirectory getPsiDirectory(AnActionEvent e) {
        PsiDirectory[] directories;
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view != null && (directories = view.getDirectories()).length == 1) {
            return directories[0];
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/lang/javascript/actions/TypeScriptCreateConfigFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

