/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.psi.css.MinifiedFilesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ThreeState;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.io.BooleanDataDescriptor;
import com.intellij.util.io.DataExternalizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSMinifiedFileUtil {
    private static final int MINIFIED_FLAG_GIST_VERSION = 1;
    private static final Key<Pair<Boolean, Pair<Long, Long>>> CACHED_MINIFIED_STATUS_KEY = Key.create((String)"js.cached.minified.status");
    private static final TokenSet NO_WHITESPACE_REQUIRED_AFTER = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.andNot((TokenSet)JSTokenTypes.OPERATIONS, (TokenSet)JSKeywordSets.IDENTIFIER_NAMES), TokenSet.andNot((TokenSet)JSTokenTypes.COMMENTS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.END_OF_LINE_COMMENT})), TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, JSTokenTypes.LPAR, JSTokenTypes.RPAR, JSTokenTypes.DOT, JSTokenTypes.SEMICOLON, JSTokenTypes.ANY_IDENTIFIER})});
    private static final TokenSet NO_WHITESPACE_REQUIRED_BEFORE = TokenSet.orSet((TokenSet[])new TokenSet[]{NO_WHITESPACE_REQUIRED_AFTER, JSTokenTypes.COMMENTS, JSTokenTypes.STRING_LITERALS});
    private static final TokenSet STRING_LITERAL_TYPES = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.STRING_LITERALS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.STRING_TEMPLATE_PART})});
    private static final VirtualFileGist<Boolean> MINIFIED_CONTENT_GIST = GistManager.getInstance().newVirtualFileGist("js.minified.store", 1, (DataExternalizer)BooleanDataDescriptor.INSTANCE, (project, file2) -> {
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)JavascriptLanguage.INSTANCE);
        Document document2 = FileDocumentManager.getInstance().getCachedDocument(file2);
        @NotNull CharSequence content = JSMinifiedFileUtil.calcFileContent(file2, document2);
        return MinifiedFilesUtil.isMinified((CharSequence)content, (ParserDefinition)def, (TokenSet)NO_WHITESPACE_REQUIRED_BEFORE, (TokenSet)NO_WHITESPACE_REQUIRED_AFTER, (TokenSet)STRING_LITERAL_TYPES);
    });

    public static boolean isFileMinified(@NotNull VirtualFile file2, @NotNull Project project) {
        JSLibraryManager libraryManager;
        ThreeState isExplicitlyCompact;
        if (file2 == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(1);
        }
        if ((isExplicitlyCompact = (libraryManager = JSLibraryManager.getInstance(project)).getFileState(file2)) == ThreeState.YES) {
            return true;
        }
        if (isExplicitlyCompact == ThreeState.NO) {
            return false;
        }
        return JSMinifiedFileUtil.isFileContentMinified(file2);
    }

    public static boolean isFileContentMinified(@NotNull VirtualFile file2) {
        long documentTimeStamp;
        if (file2 == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(2);
        }
        if (file2.isDirectory() || !file2.isValid()) {
            return false;
        }
        if (file2 instanceof HttpVirtualFile) {
            RemoteFileInfo info = ((HttpVirtualFile)file2).getFileInfo();
            if (info == null || info.getState() != RemoteFileState.DOWNLOADED) {
                return false;
            }
            VirtualFile localFile = info.getLocalFile();
            if (localFile == null) {
                return false;
            }
            file2 = localFile;
        }
        Document document2 = FileDocumentManager.getInstance().getCachedDocument(file2);
        Pair status = (Pair)CACHED_MINIFIED_STATUS_KEY.get((UserDataHolder)file2);
        long l = documentTimeStamp = document2 != null ? document2.getModificationStamp() : -1L;
        if (status == null || ((Long)((Pair)status.getSecond()).getFirst()).longValue() != file2.getTimeStamp() || (Long)((Pair)status.getSecond()).getSecond() != documentTimeStamp) {
            status = Pair.create((Object)JSMinifiedFileUtil.checkAndPersistFileContentMinified(file2), (Object)Pair.create((Object)file2.getTimeStamp(), (Object)documentTimeStamp));
            CACHED_MINIFIED_STATUS_KEY.set((UserDataHolder)file2, (Object)status);
        }
        return (Boolean)status.getFirst();
    }

    @NotNull
    private static CharSequence calcFileContent(@NotNull VirtualFile file2, @Nullable Document document2) {
        CharSequence charSequence;
        if (file2 == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(3);
        }
        if (document2 != null) {
            CharSequence charSequence2 = document2.getCharsSequence();
            if (charSequence2 == null) {
                JSMinifiedFileUtil.$$$reportNull$$$0(4);
            }
            return charSequence2;
        }
        try {
            charSequence = LoadTextUtil.loadText((VirtualFile)file2, (int)0x100000);
        }
        catch (Exception e) {
            return "";
        }
        if (charSequence == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    private static boolean checkAndPersistFileContentMinified(@Nullable VirtualFile file2) {
        if (file2 == null) {
            return false;
        }
        String fileName = file2.getName();
        if (FileTypeRegistry.getInstance().getFileTypeByFileName(fileName) != JavaScriptFileType.INSTANCE) {
            return false;
        }
        if (fileName.contains(".min.")) {
            return true;
        }
        if (fileName.contains(".dev.")) {
            return false;
        }
        return (Boolean)MINIFIED_CONTENT_GIST.getFileData(null, file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSMinifiedFileUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSMinifiedFileUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calcFileContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFileMinified";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isFileContentMinified";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcFileContent";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

