/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.web.webTypes.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.intellij.javascript.web.webTypes.json.Contributions;
import com.intellij.javascript.web.webTypes.json.FrameworkConfig;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"$schema", "framework", "name", "version", "js-types-syntax", "description-markup", "framework-config", "default-icon", "contributions"})
public class WebTypes {
    @JsonProperty(value="$schema")
    private String $schema;
    @JsonProperty(value="framework")
    @JsonPropertyDescription(value="Framework, for which the components are provided by the library")
    private String framework;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the library")
    private String name;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Version of the library, for which web-types are provided")
    private String version;
    @JsonProperty(value="js-types-syntax")
    @JsonPropertyDescription(value="Language in which JavaScript objects types are specified.")
    private JsTypesSyntax jsTypesSyntax;
    @JsonProperty(value="description-markup")
    @JsonPropertyDescription(value="Markup language in which descriptions are formatted")
    private DescriptionMarkup descriptionMarkup = DescriptionMarkup.fromValue("none");
    @JsonProperty(value="framework-config")
    private FrameworkConfig frameworkConfig;
    @JsonProperty(value="default-icon")
    @JsonPropertyDescription(value="Relative path to icon")
    private String defaultIcon;
    @JsonProperty(value="contributions")
    private Contributions contributions;

    @JsonProperty(value="$schema")
    public String get$schema() {
        return this.$schema;
    }

    @JsonProperty(value="$schema")
    public void set$schema(String $schema) {
        this.$schema = $schema;
    }

    @JsonProperty(value="framework")
    public String getFramework() {
        return this.framework;
    }

    @JsonProperty(value="framework")
    public void setFramework(String framework) {
        this.framework = framework;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty(value="js-types-syntax")
    public JsTypesSyntax getJsTypesSyntax() {
        return this.jsTypesSyntax;
    }

    @JsonProperty(value="js-types-syntax")
    public void setJsTypesSyntax(JsTypesSyntax jsTypesSyntax) {
        this.jsTypesSyntax = jsTypesSyntax;
    }

    @JsonProperty(value="description-markup")
    public DescriptionMarkup getDescriptionMarkup() {
        return this.descriptionMarkup;
    }

    @JsonProperty(value="description-markup")
    public void setDescriptionMarkup(DescriptionMarkup descriptionMarkup) {
        this.descriptionMarkup = descriptionMarkup;
    }

    @JsonProperty(value="framework-config")
    public FrameworkConfig getFrameworkConfig() {
        return this.frameworkConfig;
    }

    @JsonProperty(value="framework-config")
    public void setFrameworkConfig(FrameworkConfig frameworkConfig) {
        this.frameworkConfig = frameworkConfig;
    }

    @JsonProperty(value="default-icon")
    public String getDefaultIcon() {
        return this.defaultIcon;
    }

    @JsonProperty(value="default-icon")
    public void setDefaultIcon(String defaultIcon) {
        this.defaultIcon = defaultIcon;
    }

    @JsonProperty(value="contributions")
    public Contributions getContributions() {
        return this.contributions;
    }

    @JsonProperty(value="contributions")
    public void setContributions(Contributions contributions2) {
        this.contributions = contributions2;
    }

    public static enum JsTypesSyntax {
        TYPESCRIPT("typescript");

        private final String value;
        private static final Map<String, JsTypesSyntax> CONSTANTS;

        private JsTypesSyntax(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static JsTypesSyntax fromValue(String value) {
            JsTypesSyntax constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, JsTypesSyntax>();
            for (JsTypesSyntax c : JsTypesSyntax.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum DescriptionMarkup {
        HTML("html"),
        MARKDOWN("markdown"),
        NONE("none");

        private final String value;
        private static final Map<String, DescriptionMarkup> CONSTANTS;

        private DescriptionMarkup(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DescriptionMarkup fromValue(String value) {
            DescriptionMarkup constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DescriptionMarkup>();
            for (DescriptionMarkup c : DescriptionMarkup.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

