/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.modules.TypeScriptTypingsMapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModuleDirectorySearchProcessor {
    public static final NodeModuleDirectorySearchProcessor PROCESSOR = new NodeModuleDirectorySearchProcessor();
    public static final String INDEX_NAME = "index";
    private final String[] myExtensionsWithDot;

    public @NotNull NodeModuleDirectorySearchProcessor() {
        this(NodeModuleSearchUtil.FILE_EXTENSIONS_IN_ORDER);
    }

    public NodeModuleDirectorySearchProcessor(String @NotNull [] extensionsWithDot) {
        if (extensionsWithDot == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(0);
        }
        this.myExtensionsWithDot = extensionsWithDot;
    }

    @NotNull
    public static NodeModuleDirectorySearchProcessor forElement(@NotNull PsiElement element) {
        if (element == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(1);
        }
        NodeModuleDirectorySearchProcessor nodeModuleDirectorySearchProcessor = DialectDetector.isTypeScript(element) ? TypeScriptNodeReference.TS_PROCESSOR : PROCESSOR;
        if (nodeModuleDirectorySearchProcessor == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(2);
        }
        return nodeModuleDirectorySearchProcessor;
    }

    @Nullable
    public ResolvedModuleInfo doResolveModule(@Nullable VirtualFile moduleSourceRoot, @NotNull ModuleType type, @NotNull VirtualFile baseDir, @NotNull String requiredModuleName, boolean resolveDirectory, boolean respectPackageJson) {
        String childNamePrefix;
        VirtualFile parentDir;
        int lastSlashInd;
        if (type == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(3);
        }
        if (baseDir == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(4);
        }
        if (requiredModuleName == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(5);
        }
        if ((lastSlashInd = (requiredModuleName = FileUtil.toSystemIndependentName((String)requiredModuleName)).lastIndexOf(47)) == -1) {
            parentDir = baseDir;
            childNamePrefix = requiredModuleName;
        } else {
            if (lastSlashInd == 0 || lastSlashInd == requiredModuleName.length() - 1) {
                return null;
            }
            parentDir = baseDir.findFileByRelativePath(requiredModuleName.substring(0, lastSlashInd));
            if (parentDir == null) {
                return null;
            }
            childNamePrefix = requiredModuleName.substring(lastSlashInd + 1);
        }
        boolean directory = false;
        VirtualFile fileOrDir = null;
        if (resolveDirectory && (fileOrDir = childNamePrefix.equals("..") ? parentDir.getParent() : (childNamePrefix.equals(".") ? parentDir : parentDir.findChild(childNamePrefix))) != null && fileOrDir.isValid()) {
            if (fileOrDir.isDirectory()) {
                directory = true;
            } else {
                if (moduleSourceRoot != null) {
                    return new ResolvedModuleInfo(moduleSourceRoot, fileOrDir, type);
                }
                return new ResolvedModuleInfo(fileOrDir, type);
            }
        }
        for (String ext : this.getExtensions()) {
            VirtualFile childFile = parentDir.findChild(childNamePrefix + ext);
            if (childFile == null || !NodeModuleSearchUtil.isFile(childFile)) continue;
            if (moduleSourceRoot != null) {
                return new ResolvedModuleInfo(moduleSourceRoot, childFile, type);
            }
            return new ResolvedModuleInfo(childFile, type);
        }
        if (directory) {
            return this.loadDirectory(moduleSourceRoot, fileOrDir, type, respectPackageJson);
        }
        return null;
    }

    protected String[] getExtensions() {
        return this.myExtensionsWithDot;
    }

    @Nullable
    public ResolvedModuleInfo loadDirectory(@Nullable VirtualFile moduleSourceRoot, @NotNull VirtualFile dir, @NotNull ModuleType type, boolean respectPackageJson) {
        PackageJsonData data;
        String main;
        VirtualFile packageJson;
        if (dir == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(6);
        }
        if (type == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(7);
        }
        if (moduleSourceRoot == null) {
            moduleSourceRoot = dir;
        }
        if (respectPackageJson && (packageJson = PackageJsonUtil.findChildPackageJsonFile(dir)) != null && (main = this.findPathInPackageJson(data = PackageJsonData.getOrCreate(packageJson), packageJson)) != null) {
            ResolvedModuleInfo resolvedMain;
            String subPath = StringUtil.trimEnd((String)main, (char)'/');
            boolean resolveDirectory = INDEX_NAME.equals(subPath);
            ResolvedModuleInfo info = this.doResolveModule(moduleSourceRoot, type, dir, INDEX_NAME, resolveDirectory, false);
            if (!data.hasTypingsProperty() && info != null && "index.d.ts".equals(info.getModuleMainFile().getName())) {
                return info;
            }
            if (!INDEX_NAME.equals(subPath) && (resolvedMain = this.doResolveModule(moduleSourceRoot, type, dir, subPath, true, false)) != null) {
                return resolvedMain;
            }
            return info;
        }
        return this.doResolveModule(moduleSourceRoot, type, dir, INDEX_NAME, false, false);
    }

    protected String findPathInPackageJson(@NotNull PackageJsonData data, @NotNull VirtualFile packageJson) {
        if (data == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(8);
        }
        if (packageJson == null) {
            NodeModuleDirectorySearchProcessor.$$$reportNull$$$0(9);
        }
        String defaultMain = data.getDefaultMain();
        if (data.hasTypings()) {
            return TypeScriptTypingsMapper.substituteTypings(defaultMain, packageJson, data, false);
        }
        return defaultMain;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionsWithDot";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredModuleName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeModuleDirectorySearchProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "forElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "forElement";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doResolveModule";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadDirectory";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findPathInPackageJson";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

