/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.jest.scope.JestScopeKind;
import com.intellij.javascript.jest.scope.JestScopeView;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.ui.PathShortener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JestRunConfigurationEditor
extends SettingsEditor<JestRunConfiguration> {
    private final Project myProject;
    private final TextFieldWithHistoryWithBrowseButton myConfigPathTextFieldWithBrowseButton;
    private final NodeJsInterpreterField myInterpreterField;
    private final RawCommandLineEditor myNodeOptionsEditor;
    private final NodePackageField myJestPackageField;
    private final TextFieldWithBrowseButton myWorkingDirComponent;
    private final RawCommandLineEditor myJestOptionsEditor;
    private final EnvironmentVariablesTextFieldWithBrowseButton myEnvVarsComponent;
    private final Map<JestScopeKind, JRadioButton> myRadioButtonMap;
    private final Map<JestScopeKind, JestScopeView> myScopeKindViewMap;
    private final JPanel mySelectedScopeKindPanel;
    private final JPanel myPanel;
    private final int myLongestLabelWidth;

    public JestRunConfigurationEditor(@NotNull Project project) {
        if (project == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        this.myRadioButtonMap = new HashMap<JestScopeKind, JRadioButton>();
        this.myScopeKindViewMap = new HashMap<JestScopeKind, JestScopeView>();
        this.myLongestLabelWidth = new JLabel((String)UIUtil.removeMnemonic((String)JavaScriptBundle.message((String)"rc.environmentVariables.label", (Object[])new Object[0]))).getPreferredSize().width;
        this.myProject = project;
        this.myInterpreterField = new NodeJsInterpreterField(project, false);
        this.myNodeOptionsEditor = JestRunConfigurationEditor.createNodeOptionsEditor();
        this.myWorkingDirComponent = JestRunConfigurationEditor.createWorkingDirComponent(project);
        this.myConfigPathTextFieldWithBrowseButton = JestRunConfigurationEditor.createConfigurationFileTextField(project, this.myWorkingDirComponent.getTextField());
        PathShortener.enablePathShortening((JTextField)((TextFieldWithHistory)this.myConfigPathTextFieldWithBrowseButton.getChildComponent()).getTextEditor(), null);
        PathShortener.enablePathShortening((JTextField)this.myWorkingDirComponent.getTextField(), null);
        this.myJestPackageField = new NodePackageField(this.myInterpreterField, JestUtil.PKG_DESCRIPTOR, () -> {
            String text = PathShortener.getAbsolutePath((JTextField)this.myWorkingDirComponent.getTextField());
            return !text.isEmpty() ? LocalFileSystem.getInstance().findFileByPath(text) : null;
        });
        this.myJestOptionsEditor = JestRunConfigurationEditor.createJestOptionsEditor();
        this.myEnvVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        JPanel scopeKindPanel = this.createScopeKindRadioButtonPanel();
        this.mySelectedScopeKindPanel = new JPanel(new BorderLayout());
        this.myPanel = new FormBuilder().setAlignLabelOnRight(false).addLabeledComponent(JavaScriptBundle.message("jest.rc.configurationFile.label", new Object[0]), (JComponent)this.myConfigPathTextFieldWithBrowseButton).addSeparator(8).addLabeledComponent(NodeJsInterpreterField.getLabelTextForComponent(), (JComponent)((Object)this.myInterpreterField), 8).addLabeledComponent(JavaScriptBundle.message("rc.nodeOptions.label", new Object[0]), (JComponent)this.myNodeOptionsEditor).addLabeledComponent(JavaScriptBundle.message("jest.rc.jestPackageField.label", new Object[0]), (JComponent)((Object)this.myJestPackageField)).addLabeledComponent(JavaScriptBundle.message("rc.workingDirectory.label", new Object[0]), (JComponent)this.myWorkingDirComponent).addLabeledComponent(JavaScriptBundle.message("jest.rc.jestOptions.label", new Object[0]), (JComponent)this.myJestOptionsEditor).addLabeledComponent(JavaScriptBundle.message("rc.environmentVariables.label", new Object[0]), (JComponent)this.myEnvVarsComponent).addSeparator(8).addComponent((JComponent)scopeKindPanel).addComponent((JComponent)this.mySelectedScopeKindPanel).getPanel();
    }

    @NotNull
    private static RawCommandLineEditor createNodeOptionsEditor() {
        RawCommandLineEditor editor = new RawCommandLineEditor();
        JTextField field = editor.getTextField();
        if (field instanceof ExpandableTextField) {
            ((ExpandableTextField)field).setMonospaced(false);
        }
        RawCommandLineEditor rawCommandLineEditor = editor;
        if (rawCommandLineEditor == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        return rawCommandLineEditor;
    }

    @NotNull
    private static RawCommandLineEditor createJestOptionsEditor() {
        RawCommandLineEditor editor = new RawCommandLineEditor();
        JTextField field = editor.getTextField();
        if (field instanceof ExpandableTextField) {
            ((ExpandableTextField)field).setMonospaced(false);
        }
        if (field instanceof ComponentWithEmptyText) {
            ((ComponentWithEmptyText)field).getEmptyText().setText(JavaScriptBundle.message("jest.rc.jestOptions.emptyText", new Object[0]));
        }
        RawCommandLineEditor rawCommandLineEditor = editor;
        if (rawCommandLineEditor == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return rawCommandLineEditor;
    }

    @NotNull
    private static TextFieldWithHistoryWithBrowseButton createConfigurationFileTextField(final @NotNull Project project, final @NotNull JTextField workingDir) {
        if (project == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        if (workingDir == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
        final TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent();
        textFieldWithHistory.setHistorySize(-1);
        textFieldWithHistory.setMinimumAndPreferredWidth(0);
        PathShortener.enablePathShortening((JTextField)textFieldWithHistory.getTextEditor(), null);
        SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> {
            List<VirtualFile> newFiles = JestUtil.listPossibleConfigFilesInProject(project);
            List newFilePaths = ContainerUtil.map(newFiles, file2 -> {
                String path2 = FileUtil.toSystemDependentName((String)file2.getPath());
                return FileUtil.getLocationRelativeToUserHome((String)path2, (boolean)false);
            });
            Collections.sort(newFilePaths);
            return newFilePaths;
        });
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithHistoryWithBrowseButton)textFieldWithHistoryWithBrowseButton, (String)JavaScriptBundle.message("jest.rc.configurationFile.title", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        textFieldWithHistory.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){
            private String myLastAddedText;

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                String currentText = textFieldWithHistory.getText();
                if (currentText == null || currentText.equals(this.myLastAddedText)) {
                    return;
                }
                List oldHistory = textFieldWithHistory.getHistory();
                HashSet<String> newHistory = new HashSet<String>(oldHistory);
                newHistory.remove(this.myLastAddedText);
                this.myLastAddedText = null;
                if (!oldHistory.contains(currentText)) {
                    newHistory.add(currentText);
                    this.myLastAddedText = currentText;
                }
                ArrayList result2 = new ArrayList(newHistory);
                Collections.sort(result2);
                if (!result2.equals(oldHistory)) {
                    textFieldWithHistory.setHistory(result2);
                    textFieldWithHistory.setSelectedItem((Object)currentText);
                }
            }
        });
        ((TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent()).setEditor((ComboBoxEditor)new BasicComboBoxEditor(){

            @Override
            protected JTextField createEditorComponent() {
                final JBTextField field = new JBTextField();
                workingDir.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                    protected void textChanged(@NotNull DocumentEvent e) {
                        VirtualFile file2;
                        String path2;
                        if (e == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (!(path2 = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)((file2 = JestRunConfigurationEditor.inferJestConfigByWorkingDir(project, PathShortener.getAbsolutePath((JTextField)workingDir))) != null ? file2.getPath() : null)))).isEmpty()) {
                            path2 = FileUtil.getLocationRelativeToUserHome((String)path2, (boolean)false);
                        }
                        field.getEmptyText().setText(path2);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/jest/JestRunConfigurationEditor$2$1", "textChanged"));
                    }
                });
                return field;
            }
        });
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton2 = textFieldWithHistoryWithBrowseButton;
        if (textFieldWithHistoryWithBrowseButton2 == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        return textFieldWithHistoryWithBrowseButton2;
    }

    @Nullable
    private static VirtualFile inferJestConfigByWorkingDir(@NotNull Project project, @NotNull String workingDirectory) {
        if (project == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(6);
        }
        if (workingDirectory == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(7);
        }
        if (workingDirectory.isEmpty()) {
            return null;
        }
        VirtualFile workingDir = LocalFileSystem.getInstance().findFileByPath(workingDirectory);
        if (workingDir == null || !workingDir.isDirectory()) {
            return null;
        }
        VirtualFile configFile = JSProjectUtil.findFileUpToContentRoot(project, workingDir, "jest.config.js", "package.json");
        return PackageJsonUtil.isPackageJsonFile(configFile) ? null : configFile;
    }

    @NotNull
    private static TextFieldWithBrowseButton createWorkingDirComponent(@NotNull Project project) {
        if (project == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(8);
        }
        TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (String)JavaScriptBundle.message("rc.workingDirectory.browseDialogTitle", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
        TextFieldWithBrowseButton textFieldWithBrowseButton2 = textFieldWithBrowseButton;
        if (textFieldWithBrowseButton2 == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(9);
        }
        return textFieldWithBrowseButton2;
    }

    @NotNull
    private JPanel createScopeKindRadioButtonPanel() {
        JPanel testKindPanel = new JPanel(new FlowLayout(1, JBUIScale.scale((int)40), 0));
        testKindPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (final JestScopeKind scopeKind : JestScopeKind.values()) {
            JRadioButton radioButton = new JRadioButton(UIUtil.replaceMnemonicAmpersand((String)scopeKind.getName()));
            radioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JestRunConfigurationEditor.this.setScopeKind(scopeKind);
                }
            });
            this.myRadioButtonMap.put(scopeKind, radioButton);
            testKindPanel.add(radioButton);
            buttonGroup.add(radioButton);
        }
        JPanel jPanel = testKindPanel;
        if (jPanel == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    private void setScopeKind(@NotNull JestScopeKind scopeKind) {
        JestScopeKind selectedScopeKind;
        if (scopeKind == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(11);
        }
        if ((selectedScopeKind = this.getScopeKind()) != scopeKind) {
            JRadioButton radioButton = this.myRadioButtonMap.get((Object)scopeKind);
            radioButton.setSelected(true);
        }
        JestScopeView view = this.getScopeKindView(scopeKind);
        JestRunConfigurationEditor.setCenterBorderLayoutComponent(this.mySelectedScopeKindPanel, view.getComponent());
    }

    @NotNull
    private JestScopeView getScopeKindView(@NotNull JestScopeKind scopeKind) {
        JestScopeView view;
        if (scopeKind == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(12);
        }
        if ((view = this.myScopeKindViewMap.get((Object)scopeKind)) == null) {
            view = scopeKind.createView(this.myProject);
            this.myScopeKindViewMap.put(scopeKind, view);
            JComponent component = view.getComponent();
            if (component.getLayout() instanceof GridBagLayout) {
                component.add(Box.createHorizontalStrut(this.myLongestLabelWidth), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insets((int)0, (int)0, (int)0, (int)10), 0, 0));
            }
        }
        JestScopeView jestScopeView = view;
        if (jestScopeView == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(13);
        }
        return jestScopeView;
    }

    private static void setCenterBorderLayoutComponent(@NotNull JPanel panel2, @NotNull Component child) {
        Component prevChild;
        if (panel2 == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(14);
        }
        if (child == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(15);
        }
        if ((prevChild = ((BorderLayout)panel2.getLayout()).getLayoutComponent("Center")) != null) {
            panel2.remove(prevChild);
        }
        panel2.add(child, "Center");
        panel2.revalidate();
        panel2.repaint();
    }

    @Nullable
    private JestScopeKind getScopeKind() {
        for (Map.Entry<JestScopeKind, JRadioButton> entry : this.myRadioButtonMap.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            return entry.getKey();
        }
        return null;
    }

    protected void resetEditorFrom(@NotNull JestRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(16);
        }
        JestRunSettings runSettings = runConfiguration.getRunSettings();
        this.myConfigPathTextFieldWithBrowseButton.setTextAndAddToHistory(runSettings.getConfigFileSystemDependentPath());
        this.myInterpreterField.setInterpreterRef(runSettings.getInterpreterRef());
        this.myNodeOptionsEditor.setText(runSettings.getNodeOptions());
        this.myJestPackageField.setSelected(runConfiguration.getJestPackage());
        this.myWorkingDirComponent.setText(runSettings.getWorkingDirSystemDependentPath());
        this.myJestOptionsEditor.setText(runSettings.getJestOptions());
        this.myEnvVarsComponent.setData(runSettings.getEnvData());
        this.setScopeKind(runSettings.getScopeKind());
        for (JestScopeKind value : JestScopeKind.values()) {
            JestScopeView view = this.getScopeKindView(value);
            view.resetFrom(runSettings);
        }
        this.updatePreferredWidth();
    }

    private void updatePreferredWidth() {
        DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)this.myPanel);
        if (dialogWrapper instanceof SingleConfigurableEditor) {
            this.myInterpreterField.setPreferredWidthToFitText();
            this.myJestPackageField.setPreferredWidthToFitText();
            SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)this.myConfigPathTextFieldWithBrowseButton);
            ApplicationManager.getApplication().invokeLater(() -> SwingHelper.adjustDialogSizeToFitPreferredSize((DialogWrapper)dialogWrapper), ModalityState.stateForComponent((Component)this.myPanel));
        }
    }

    protected void applyEditorTo(@NotNull JestRunConfiguration runConfiguration) throws ConfigurationException {
        if (runConfiguration == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(17);
        }
        JestRunSettings.Builder builder = JestRunSettings.builder();
        builder.setConfigFilePath(PathShortener.getAbsolutePath((JTextField)((TextFieldWithHistory)this.myConfigPathTextFieldWithBrowseButton.getChildComponent()).getTextEditor()));
        builder.setInterpreterRef(this.myInterpreterField.getInterpreterRef());
        builder.setNodeOptions(this.myNodeOptionsEditor.getText());
        builder.setJestPackage(this.myJestPackageField.getSelected());
        builder.setWorkingDir(PathShortener.getAbsolutePath((JTextField)this.myWorkingDirComponent.getTextField()));
        builder.setJestOptions(this.myJestOptionsEditor.getText());
        builder.setEnvData(this.myEnvVarsComponent.getData());
        JestScopeKind scopeKind = this.getScopeKind();
        if (scopeKind != null) {
            builder.setScopeKind(scopeKind);
            JestScopeView view = this.getScopeKindView(scopeKind);
            view.applyTo(builder);
        }
        runConfiguration.setRunSettings(builder.build());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            JestRunConfigurationEditor.$$$reportNull$$$0(18);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/jest/JestRunConfigurationEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeKind";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/jest/JestRunConfigurationEditor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodeOptionsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createJestOptionsEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurationFileTextField";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createWorkingDirComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createScopeKindRadioButtonPanel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeKindView";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 18: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationFileTextField";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "inferJestConfigByWorkingDir";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createWorkingDirComponent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setScopeKind";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getScopeKindView";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setCenterBorderLayoutComponent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 9: 
            case 10: 
            case 13: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

