/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.sourcemap.visualizer.EditorListItem;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceFileFinder;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapInspector;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapInspectorKt;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapVisualizer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.SingleAlarm;
import com.intellij.util.Url;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.javascript.debugger.JavaScriptDebugAware;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.MappingsProcessorInLine;
import org.jetbrains.debugger.sourcemap.SourceMap;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001:\u0001?B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ \u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0002J \u0010&\u001a\u00020'2\u0006\u0010.\u001a\u00020\u00112\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0002J\u0010\u00102\u001a\u0002032\b\u00104\u001a\u0004\u0018\u000105J\u0010\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u00020\u0005H\u0002J\u0010\u00108\u001a\u00020'2\u0006\u00109\u001a\u00020!H\u0002J\u0010\u0010:\u001a\u00020'2\u0006\u0010;\u001a\u00020!H\u0002J\b\u0010<\u001a\u00020'H\u0002J\u0018\u0010=\u001a\u00020'2\u0006\u0010>\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceMapInspector;", "", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "generatedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "disposable", "Lcom/intellij/openapi/Disposable;", "sourceFileFinder", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceFileFinder;", "(Lorg/jetbrains/debugger/sourcemap/SourceMap;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceFileFinder;)V", "alarm", "Lcom/intellij/util/SingleAlarm;", "currentHighlighters", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/editor/markup/MarkupModel;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "editorListModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/EditorListItem;", "generatedEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "getGeneratedEditor", "()Lcom/intellij/openapi/editor/ex/EditorEx;", "generatedTextEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "getGeneratedTextEditor$intellij_javascript_debugger", "()Lcom/intellij/openapi/fileEditor/TextEditor;", "setGeneratedTextEditor$intellij_javascript_debugger", "(Lcom/intellij/openapi/fileEditor/TextEditor;)V", "positionToSelect", "Lcom/intellij/openapi/editor/LogicalPosition;", "positionToSelectIsSource", "", "rightPanel", "Ljavax/swing/JPanel;", "addSelectedHighlighter", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "mapping", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "mappings", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "markupModel", "startOffset", "", "endOffset", "createMainComponent", "Ljavax/swing/JComponent;", "selectedSourceUrl", "Lcom/intellij/util/Url;", "createSourceEditor", "virtualFile", "highlightGenerated", "sourcePosition", "highlightSource", "generatedPosition", "removeHighlighters", "scheduleHighlight", "position", "SourceFileFinderImpl", "intellij.javascript.debugger"})
public final class SourceMapInspector {
    @NotNull
    private TextEditor generatedTextEditor;
    @NotNull
    private final EditorEx generatedEditor;
    private JPanel rightPanel;
    private final SingleAlarm alarm;
    private LogicalPosition positionToSelect;
    private boolean positionToSelectIsSource;
    private CollectionComboBoxModel<EditorListItem> editorListModel;
    private final MultiMap<MarkupModel, RangeHighlighter> currentHighlighters;
    private final SourceFileFinder sourceFileFinder;
    private final SourceMap map;
    private final Project project;
    private final Disposable disposable;

    @NotNull
    public final TextEditor getGeneratedTextEditor$intellij_javascript_debugger() {
        return this.generatedTextEditor;
    }

    public final void setGeneratedTextEditor$intellij_javascript_debugger(@NotNull TextEditor textEditor) {
        Intrinsics.checkNotNullParameter((Object)textEditor, (String)"<set-?>");
        this.generatedTextEditor = textEditor;
    }

    @NotNull
    public final EditorEx getGeneratedEditor() {
        return this.generatedEditor;
    }

    private final void scheduleHighlight(LogicalPosition position, boolean positionToSelectIsSource) {
        this.positionToSelect = position;
        this.positionToSelectIsSource = positionToSelectIsSource;
        SingleAlarm.cancelAndRequest$default((SingleAlarm)this.alarm, (boolean)false, (int)1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JComponent createMainComponent(@Nullable Url selectedSourceUrl) {
        boolean bl = false;
        List editors = new ArrayList();
        Url[] sources = this.map.getSources();
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getInstance(project).fileIndex");
        ProjectFileIndex fileIndex = projectFileIndex;
        int selectedIndex = -1;
        int n = 0;
        int n2 = sources.length;
        while (n < n2) {
            void i;
            Url url = sources[i];
            VirtualFile file2 = this.sourceFileFinder.find(url);
            Font font = null;
            if (file2 == null) {
                Font font2 = UIUtil.getListFont().deriveFont(2);
                Intrinsics.checkNotNullExpressionValue((Object)font2, (String)"UIUtil.getListFont().deriveFont(Font.ITALIC)");
                font = font2;
            } else if (!fileIndex.isInContent(file2) || fileIndex.isInLibrary(file2)) {
                Font font3 = UIUtil.getListFont();
                Intrinsics.checkNotNullExpressionValue((Object)font3, (String)"UIUtil.getListFont()");
                font = font3;
            } else {
                Font font4 = UIUtil.getListFont().deriveFont(1);
                Intrinsics.checkNotNullExpressionValue((Object)font4, (String)"UIUtil.getListFont().deriveFont(Font.BOLD)");
                font = font4;
            }
            Collection collection = editors;
            String string = file2 == null ? url.toDecodedForm() : SourceMapInspectorKt.getFileTitle(file2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (file == null) url.to\u2026) else getFileTitle(file)");
            EditorListItem editorListItem = new EditorListItem((int)i, file2, font, string);
            boolean bl2 = false;
            collection.add(editorListItem);
            if (selectedIndex == -1 && selectedSourceUrl != null && Intrinsics.areEqual((Object)selectedSourceUrl, (Object)url)) {
                selectedIndex = i;
            }
            ++i;
        }
        this.editorListModel = new CollectionComboBoxModel(editors);
        CollectionComboBoxModel<EditorListItem> collectionComboBoxModel = this.editorListModel;
        Intrinsics.checkNotNull(collectionComboBoxModel);
        ComboBox comboBox = new ComboBox((ComboBoxModel)collectionComboBoxModel, 100);
        new ComboboxSpeedSearch(comboBox, (JComboBox)comboBox){
            final /* synthetic */ ComboBox $comboBox;

            @NotNull
            protected String getElementText(@NotNull Object element) {
                String string;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                EditorListItem item = (EditorListItem)element;
                if (item.getFile() == null) {
                    string = item.getName();
                } else {
                    String string2 = item.getFile().getName();
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"item.file.name");
                }
                return string;
            }
            {
                this.$comboBox = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((SimpleListCellRenderer.Customizer)createMainComponent.2.INSTANCE));
        comboBox.addItemListener(new ItemListener(this){
            final /* synthetic */ SourceMapInspector this$0;

            public final void itemStateChanged(ItemEvent e) {
                ItemEvent itemEvent = e;
                Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"e");
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                Object object = e.getItem();
                if (!(object instanceof EditorListItem)) {
                    object = null;
                }
                EditorListItem editorListItem = (EditorListItem)object;
                if (editorListItem == null) {
                    return;
                }
                EditorListItem selectedItem = editorListItem;
                JPanel jPanel = SourceMapInspector.access$getRightPanel$p(this.this$0);
                Intrinsics.checkNotNull((Object)jPanel);
                if (jPanel.getComponentCount() > 1) {
                    JPanel jPanel2 = SourceMapInspector.access$getRightPanel$p(this.this$0);
                    Intrinsics.checkNotNull((Object)jPanel2);
                    jPanel2.remove(1);
                }
                if (selectedItem.getEditor() == null && selectedItem.getFile() != null) {
                    selectedItem.setEditor(SourceMapInspector.access$createSourceEditor(this.this$0, selectedItem.getFile()));
                }
                if (selectedItem.getEditor() != null) {
                    JPanel jPanel3 = SourceMapInspector.access$getRightPanel$p(this.this$0);
                    Intrinsics.checkNotNull((Object)jPanel3);
                    EditorEx editorEx = selectedItem.getEditor();
                    Intrinsics.checkNotNull((Object)editorEx);
                    jPanel3.add(editorEx.getComponent(), "Center", 1);
                }
                LogicalPosition sourcePosition2 = null;
                if (selectedItem.getFile() == null) {
                    sourcePosition2 = new LogicalPosition(0, 0);
                } else {
                    JavaScriptDebugAware debugAware;
                    PsiFile psiFile = PsiManager.getInstance((Project)SourceMapInspector.access$getProject$p(this.this$0)).findFile(selectedItem.getFile());
                    Intrinsics.checkNotNull((Object)psiFile);
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(p\u2026File(selectedItem.file)!!");
                    PsiFile file2 = psiFile;
                    PsiElement navigationElement = null;
                    JavaScriptDebugAware[] javaScriptDebugAwareArray = (JavaScriptDebugAware[])JavaScriptDebugAware.Companion.getEP_NAME().getExtensions();
                    int n = javaScriptDebugAwareArray.length;
                    for (int i = 0; i < n && (navigationElement = (debugAware = javaScriptDebugAwareArray[i]).getNavigationElementForSourcemapInspector(file2)) == null; ++i) {
                    }
                    if (navigationElement == null) {
                        navigationElement = file2.getNavigationElement();
                    }
                    PsiElement psiElement = navigationElement;
                    Intrinsics.checkNotNull((Object)psiElement);
                    int offset = psiElement.getTextOffset();
                    EditorEx editorEx = selectedItem.getEditor();
                    Intrinsics.checkNotNull((Object)editorEx);
                    DocumentEx documentEx = editorEx.getDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"selectedItem.editor!!.document");
                    DocumentEx document = documentEx;
                    int line = document.getLineNumber(offset);
                    sourcePosition2 = new LogicalPosition(line, offset - document.getLineStartOffset(line));
                }
                JPanel jPanel4 = SourceMapInspector.access$getRightPanel$p(this.this$0);
                Intrinsics.checkNotNull((Object)jPanel4);
                if (jPanel4.getParent() != null) {
                    JPanel jPanel5 = SourceMapInspector.access$getRightPanel$p(this.this$0);
                    Intrinsics.checkNotNull((Object)jPanel5);
                    jPanel5.revalidate();
                    JPanel jPanel6 = SourceMapInspector.access$getRightPanel$p(this.this$0);
                    Intrinsics.checkNotNull((Object)jPanel6);
                    jPanel6.repaint();
                    SourceMapInspector.access$highlightGenerated(this.this$0, sourcePosition2);
                } else {
                    SourceMapInspector.access$setPositionToSelect$p(this.this$0, sourcePosition2);
                    SourceMapInspector.access$setPositionToSelectIsSource$p(this.this$0, true);
                }
            }
            {
                this.this$0 = sourceMapInspector;
            }
        });
        JPanel jPanel = this.rightPanel = new JPanel(new BorderLayout());
        Intrinsics.checkNotNull((Object)jPanel);
        jPanel.add((Component)comboBox, "First");
        comboBox.setSelectedIndex(selectedIndex);
        JBSplitter splitter = new JBSplitter();
        splitter.setSplitterProportionKey("SourceMapInspector.splitter");
        splitter.setFirstComponent(this.generatedEditor.getComponent());
        splitter.setSecondComponent((JComponent)this.rightPanel);
        this.generatedEditor.getComponent().addAncestorListener((AncestorListener)new AncestorListenerAdapter(this){
            final /* synthetic */ SourceMapInspector this$0;

            public void ancestorAdded(@NotNull AncestorEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.getGeneratedEditor().getComponent().removeAncestorListener((AncestorListener)((Object)this));
                if (SourceMapInspector.access$getPositionToSelect$p(this.this$0) == null) {
                    return;
                }
                LogicalPosition logicalPosition = SourceMapInspector.access$getPositionToSelect$p(this.this$0);
                Intrinsics.checkNotNull((Object)logicalPosition);
                SourceMapInspector.access$highlightGenerated(this.this$0, logicalPosition);
                SourceMapInspector.access$setPositionToSelect$p(this.this$0, null);
                SourceMapInspector.access$setPositionToSelectIsSource$p(this.this$0, false);
            }
            {
                this.this$0 = this$0;
            }
        });
        return (JComponent)splitter;
    }

    private final EditorEx createSourceEditor(VirtualFile virtualFile) {
        FileEditor fileEditor = TextEditorProvider.getInstance().createEditor(this.project, virtualFile);
        if (fileEditor == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        }
        TextEditor textEditor = (TextEditor)fileEditor;
        Editor editor = textEditor.getEditor();
        if (editor == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        }
        EditorEx sourceEditor = (EditorEx)editor;
        SourceMapInspectorKt.access$setupEditor(sourceEditor);
        sourceEditor.getCaretModel().addCaretListener(new CaretListener(this){
            final /* synthetic */ SourceMapInspector this$0;

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                LogicalPosition logicalPosition = event.getNewPosition();
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"event.newPosition");
                SourceMapInspector.access$scheduleHighlight(this.this$0, logicalPosition, true);
            }
            {
                this.this$0 = this$0;
            }
        });
        Disposer.register((Disposable)this.disposable, (Disposable)((Disposable)textEditor));
        return sourceEditor;
    }

    private final void highlightGenerated(LogicalPosition sourcePosition2) {
        EditorListItem item;
        this.removeHighlighters();
        CollectionComboBoxModel<EditorListItem> collectionComboBoxModel = this.editorListModel;
        Intrinsics.checkNotNull(collectionComboBoxModel);
        EditorListItem editorListItem = item = (EditorListItem)collectionComboBoxModel.getSelected();
        Intrinsics.checkNotNull((Object)editorListItem);
        Mappings mappings = this.map.findSourceMappings(editorListItem.getSourceIndex());
        if (mappings == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
        }
        MappingList mappingsOrderedBySource = (MappingList)mappings;
        int mappingIndex = mappingsOrderedBySource.indexOf(sourcePosition2.line, sourcePosition2.column);
        if (mappingIndex == -1) {
            return;
        }
        MappingEntry mappingEntry = mappingsOrderedBySource.get(sourcePosition2.line, sourcePosition2.column);
        Intrinsics.checkNotNull((Object)mappingEntry);
        MappingEntry mapping = mappingEntry;
        EditorEx editorEx = item.getEditor();
        Intrinsics.checkNotNull((Object)editorEx);
        this.addSelectedHighlighter((Editor)editorEx, mapping, mappingsOrderedBySource);
        MappingEntry nextMapping = Mappings.DefaultImpls.getNextOnTheSameLine$default((Mappings)((Mappings)mappingsOrderedBySource), (int)mappingIndex, (boolean)false, (int)2, null);
        mappingsOrderedBySource.processMappingsInLine(mapping.getSourceLine(), new MappingsProcessorInLine(this, mapping, nextMapping){
            final /* synthetic */ SourceMapInspector this$0;
            final /* synthetic */ MappingEntry $mapping;
            final /* synthetic */ MappingEntry $nextMapping;

            public boolean process(@NotNull MappingEntry entry, @Nullable MappingEntry nextEntry) {
                Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
                if (entry.getSourceColumn() >= this.$mapping.getSourceColumn()) {
                    Mappings mappings = SourceMapInspector.access$getMap$p(this.this$0).getGeneratedMappings();
                    if (mappings == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
                    }
                    SourceMapInspector.access$addSelectedHighlighter(this.this$0, (Editor)this.this$0.getGeneratedEditor(), entry, (MappingList)mappings);
                }
                return nextEntry != null && nextEntry != this.$nextMapping;
            }
            {
                this.this$0 = this$0;
                this.$mapping = $captured_local_variable$1;
                this.$nextMapping = $captured_local_variable$2;
            }

            public boolean processIterable(@NotNull Iterable<? extends MappingEntry> mappingsInLine) {
                Intrinsics.checkNotNullParameter(mappingsInLine, (String)"mappingsInLine");
                return MappingsProcessorInLine.DefaultImpls.processIterable((MappingsProcessorInLine)this, mappingsInLine);
            }
        });
        this.generatedEditor.getScrollingModel().scrollTo(new LogicalPosition(mapping.getGeneratedLine(), mapping.getGeneratedColumn()), ScrollType.CENTER);
    }

    private final void removeHighlighters() {
        if (this.currentHighlighters.isEmpty()) {
            return;
        }
        for (MarkupModel markupModel : this.currentHighlighters.keySet()) {
            Iterator iterator = this.currentHighlighters.get((Object)markupModel).iterator();
            while (iterator.hasNext()) {
                RangeHighlighter rangeHighlighter;
                RangeHighlighter rangeHighlighter2 = rangeHighlighter = (RangeHighlighter)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"rangeHighlighter");
                if (!rangeHighlighter2.isValid()) continue;
                markupModel.removeHighlighter(rangeHighlighter);
            }
        }
        this.currentHighlighters.clear();
    }

    private final void addSelectedHighlighter(Editor editor, MappingEntry mapping, MappingList mappings) {
        int lineStartOffset = editor.getDocument().getLineStartOffset(mappings.getLine(mapping));
        MarkupModel markupModel = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModel, (String)"editor.markupModel");
        int n = lineStartOffset + mappings.getColumn(mapping);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        this.addSelectedHighlighter(markupModel, n, mappings.getEndOffset(mapping, lineStartOffset, document));
    }

    private final void addSelectedHighlighter(MarkupModel markupModel, int startOffset, int endOffset) {
        if (startOffset == endOffset) {
            return;
        }
        if (endOffset < startOffset) {
            throw (Throwable)new IllegalStateException();
        }
        RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(startOffset, endOffset, 6100, SourceMapVisualizer.SELECTED_MARKER, HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter, (String)"markupModel.addRangeHigh\u2026erTargetArea.EXACT_RANGE)");
        RangeHighlighter highlighter = rangeHighlighter;
        this.currentHighlighters.putValue((Object)markupModel, (Object)highlighter);
    }

    private final void highlightSource(LogicalPosition generatedPosition) {
        String string;
        this.removeHighlighters();
        MappingEntry mapping = this.map.getGeneratedMappings().get(generatedPosition.line, generatedPosition.column);
        JComponent headerComponent = this.generatedEditor.getHeaderComponent();
        JLabel component = null;
        if (headerComponent instanceof JLabel) {
            component = (JLabel)headerComponent;
        } else if (headerComponent != null) {
            JPanel compoundComponent = new JPanel(new BorderLayout());
            compoundComponent.add((Component)headerComponent, "First");
            component = new JLabel("0:0", 4);
            compoundComponent.add((Component)component, "Last");
            this.generatedEditor.setHeaderComponent((JComponent)compoundComponent);
        } else {
            component = new JLabel("0:0", 4);
            this.generatedEditor.setHeaderComponent((JComponent)component);
        }
        if (mapping == null || mapping.getSource() == -1) {
            component.setText(JSDebuggerBundle.message("js.scripts.visualize.unmapped", new Object[0]));
            return;
        }
        StringBuilder stringBuilder = new StringBuilder().append(mapping.getSourceLine()).append(':').append(mapping.getSourceColumn());
        if (mapping.getName() == null) {
            string = "";
        } else {
            StringBuilder stringBuilder2 = new StringBuilder().append(" ");
            String string2 = mapping.getName();
            Intrinsics.checkNotNull((Object)string2);
            string = stringBuilder2.append(string2).toString();
        }
        component.setText(stringBuilder.append(string).append(" (").append(mapping.getGeneratedLine()).append(":").append(mapping.getGeneratedColumn()).append(")").toString());
        int sourceIndex = mapping.getSource();
        CollectionComboBoxModel<EditorListItem> collectionComboBoxModel = this.editorListModel;
        Intrinsics.checkNotNull(collectionComboBoxModel);
        EditorListItem listItem = (EditorListItem)collectionComboBoxModel.getElementAt(sourceIndex);
        VirtualFile virtualFile = listItem.getFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile sourceFile = virtualFile;
        EditorEx sourceEditor = listItem.getEditor();
        if (sourceEditor == null) {
            sourceEditor = this.createSourceEditor(sourceFile);
            listItem.setEditor(sourceEditor);
            JPanel jPanel = this.rightPanel;
            Intrinsics.checkNotNull((Object)jPanel);
            jPanel.add(sourceEditor.getComponent(), "Center", 1);
            JPanel jPanel2 = this.rightPanel;
            Intrinsics.checkNotNull((Object)jPanel2);
            jPanel2.revalidate();
            JPanel jPanel3 = this.rightPanel;
            Intrinsics.checkNotNull((Object)jPanel3);
            jPanel3.repaint();
        }
        CollectionComboBoxModel<EditorListItem> collectionComboBoxModel2 = this.editorListModel;
        Intrinsics.checkNotNull(collectionComboBoxModel2);
        collectionComboBoxModel2.setSelectedItem((Object)listItem);
        Mappings mappings = this.map.findSourceMappings(sourceIndex);
        if (mappings == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
        }
        this.addSelectedHighlighter((Editor)sourceEditor, mapping, (MappingList)mappings);
        Mappings mappings2 = this.map.getGeneratedMappings();
        if (mappings2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.debugger.sourcemap.MappingList");
        }
        this.addSelectedHighlighter((Editor)this.generatedEditor, mapping, (MappingList)mappings2);
        sourceEditor.getScrollingModel().scrollTo(new LogicalPosition(mapping.getSourceLine(), mapping.getSourceColumn()), ScrollType.MAKE_VISIBLE);
        if (Intrinsics.areEqual((Object)((Boolean)SourceMapInspectorKt.access$getEDITOR_MARKED$p().get((UserDataHolder)sourceEditor)), (Object)true) ^ true) {
            SourceMapInspectorKt.access$getEDITOR_MARKED$p().set((UserDataHolder)sourceEditor, (Object)true);
            SourceMapVisualizer.addMarkersToSourceFile(this.map, (MarkupModel)sourceEditor.getMarkupModel(), this.map.getSources()[sourceIndex]);
        }
    }

    public SourceMapInspector(@NotNull SourceMap map2, @NotNull VirtualFile generatedFile, @NotNull Project project, @NotNull Disposable disposable, @Nullable SourceFileFinder sourceFileFinder) {
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)generatedFile, (String)"generatedFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.map = map2;
        this.project = project;
        this.disposable = disposable;
        FileEditor fileEditor = TextEditorProvider.getInstance().createEditor(this.project, generatedFile);
        if (fileEditor == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        }
        this.generatedTextEditor = (TextEditor)fileEditor;
        Editor editor = this.generatedTextEditor.getEditor();
        if (editor == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        }
        this.generatedEditor = (EditorEx)editor;
        this.currentHighlighters = new MultiMap();
        SourceFileFinder sourceFileFinder2 = sourceFileFinder;
        if (sourceFileFinder2 == null) {
            sourceFileFinder2 = new SourceFileFinderImpl();
        }
        this.sourceFileFinder = sourceFileFinder2;
        Disposer.register((Disposable)this.disposable, (Disposable)((Disposable)this.generatedTextEditor));
        SourceMapInspectorKt.access$setupEditor(this.generatedEditor);
        this.generatedEditor.setHeaderComponent((JComponent)new JLabel("0:0", 4));
        SourceMapVisualizer.addMarkersToGeneratedFile(this.map, (MarkupModel)this.generatedEditor.getMarkupModel());
        this.alarm = new SingleAlarm(new Runnable(){

            @Override
            public final void run() {
                LogicalPosition p = positionToSelect;
                if (p != null) {
                    positionToSelect = null;
                    if (positionToSelectIsSource) {
                        this.highlightGenerated(p);
                    } else {
                        this.highlightSource(p);
                    }
                }
            }
        }, 100, this.disposable, null, null, 24, null);
        this.generatedEditor.addEditorMouseMotionListener(new EditorMouseMotionListener(){

            public void mouseMoved(@NotNull EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                MouseEvent mouseEvent = event.getMouseEvent();
                Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"event.mouseEvent");
                if (mouseEvent.isShiftDown()) {
                    Editor editor = event.getEditor();
                    MouseEvent mouseEvent2 = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"event.mouseEvent");
                    LogicalPosition logicalPosition = editor.xyToLogicalPosition(mouseEvent2.getPoint());
                    Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"event.editor.xyToLogical\u2026n(event.mouseEvent.point)");
                    this.scheduleHighlight(logicalPosition, false);
                }
            }
        });
        this.generatedEditor.getCaretModel().addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                LogicalPosition logicalPosition = event.getNewPosition();
                Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"event.newPosition");
                this.scheduleHighlight(logicalPosition, false);
            }
        });
    }

    public static final /* synthetic */ JPanel access$getRightPanel$p(SourceMapInspector $this) {
        return $this.rightPanel;
    }

    public static final /* synthetic */ void access$setRightPanel$p(SourceMapInspector $this, JPanel jPanel) {
        $this.rightPanel = jPanel;
    }

    public static final /* synthetic */ EditorEx access$createSourceEditor(SourceMapInspector $this, VirtualFile virtualFile) {
        return $this.createSourceEditor(virtualFile);
    }

    public static final /* synthetic */ void access$setPositionToSelectIsSource$p(SourceMapInspector $this, boolean bl) {
        $this.positionToSelectIsSource = bl;
    }

    public static final /* synthetic */ void access$addSelectedHighlighter(SourceMapInspector $this, Editor editor, MappingEntry mapping, MappingList mappings) {
        $this.addSelectedHighlighter(editor, mapping, mappings);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceMapInspector$SourceFileFinderImpl;", "Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceFileFinder;", "(Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourceMapInspector;)V", "userDataHolder", "Lcom/intellij/openapi/util/UserDataHolderBase;", "find", "Lcom/intellij/openapi/vfs/VirtualFile;", "source", "Lcom/intellij/util/Url;", "intellij.javascript.debugger"})
    public final class SourceFileFinderImpl
    implements SourceFileFinder {
        private final UserDataHolderBase userDataHolder = new UserDataHolderBase();

        @Override
        @Nullable
        public VirtualFile find(@NotNull Url source) {
            VirtualFile file2;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            VirtualFile virtualFile = SourceMapInspectorKt.createSourceFromProvidedContent(SourceMapInspector.this.map, source, (UserDataHolder)this.userDataHolder);
            if (virtualFile == null) {
                virtualFile = file2 = SourceMapInspectorKt.getSourceFile(source);
            }
            if (file2 == null) {
                Iterator iterator = XDebuggerManager.getInstance((Project)SourceMapInspector.this.project).getDebugProcesses(JavaScriptDebugProcess.class).iterator();
                while (iterator.hasNext()) {
                    WebBrowser webBrowser;
                    JavaScriptDebugProcess debugProcess;
                    JavaScriptDebugProcess javaScriptDebugProcess = debugProcess = (JavaScriptDebugProcess)((Object)iterator.next());
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)javaScriptDebugProcess), (String)"debugProcess");
                    XDebugSession xDebugSession = javaScriptDebugProcess.getSession();
                    Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"debugProcess.session");
                    WebBrowser webBrowser2 = webBrowser = xDebugSession.isStopped() ? null : debugProcess.getConnection().getBrowser();
                    if (BrowserFamily.CHROME != (webBrowser2 != null ? webBrowser2.getFamily() : null)) continue;
                    return debugProcess.findFileOrAny(source);
                }
            }
            return file2;
        }
    }
}

