/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.google.common.base.Joiner;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.DebuggableFileFinderImpl;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinderKt;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00192\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u001c\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\u0014\u0010\u001e\u001a\u00020\u000e2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0019R6\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lcom/intellij/javascript/debugger/RemoteDebuggingFileFinder;", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "mappings", "Lcom/google/common/collect/BiMap;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "parent", "(Lcom/google/common/collect/BiMap;Lcom/intellij/javascript/debugger/DebuggableFileFinder;)V", "<set-?>", "getMappings$intellij_javascript_debugger", "()Lcom/google/common/collect/BiMap;", "getParent$intellij_javascript_debugger", "()Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "canSetRemoteUrl", "", "file", "project", "Lcom/intellij/openapi/project/Project;", "createPredefinedMappings", "findFile", "url", "Lcom/intellij/util/Url;", "findNavigatable", "Lcom/intellij/pom/Navigatable;", "getRemoteUrls", "", "guessFile", "isDebuggable", "searchesByName", "toString", "updateRemoteUrlMapping", "Lcom/intellij/javascript/debugger/execution/RemoteUrlMappingBean;", "intellij.javascript.debugger"})
public final class RemoteDebuggingFileFinder
implements DebuggableFileFinder {
    @NotNull
    private BiMap<String, VirtualFile> mappings;
    @Nullable
    private final DebuggableFileFinder parent;

    @NotNull
    public final BiMap<String, VirtualFile> getMappings$intellij_javascript_debugger() {
        return this.mappings;
    }

    @Override
    @Nullable
    public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = RemoteDebuggingFileFinderKt.access$findByMappings(url, this.mappings);
        if (virtualFile != null) {
            VirtualFile virtualFile2 = virtualFile;
            boolean bl = false;
            boolean bl2 = false;
            VirtualFile it = virtualFile2;
            boolean bl3 = false;
            return (Navigatable)JsFileUtil.createNavigatable(project, it);
        }
        DebuggableFileFinder debuggableFileFinder = this.parent;
        return debuggableFileFinder != null ? debuggableFileFinder.findNavigatable(url, project) : null;
    }

    @Override
    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return RemoteDebuggingFileFinderKt.access$findByMappings(url, this.mappings);
    }

    @Override
    @Nullable
    public VirtualFile guessFile(@NotNull Url url, @NotNull Project project) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        DebuggableFileFinder debuggableFileFinder = this.parent;
        if (debuggableFileFinder != null && (debuggableFileFinder = debuggableFileFinder.findFile(url, project)) != null) {
            DebuggableFileFinder debuggableFileFinder2 = debuggableFileFinder;
            boolean bl = false;
            boolean bl2 = false;
            DebuggableFileFinder it = debuggableFileFinder2;
            boolean bl3 = false;
            return it;
        }
        BiMap<String, VirtualFile> predefinedMappings = (BiMap<String, VirtualFile>)project.getUserData(RemoteDebuggingFileFinderKt.access$getPREDEFINED_MAPPINGS_KEY$p());
        if (predefinedMappings == null) {
            predefinedMappings = this.createPredefinedMappings(project);
            project.putUserData(RemoteDebuggingFileFinderKt.access$getPREDEFINED_MAPPINGS_KEY$p(), predefinedMappings);
        }
        if ((object = RemoteDebuggingFileFinderKt.access$findByMappings(url, (BiMap)predefinedMappings)) == null) {
            DebuggableFileFinder debuggableFileFinder3 = this.parent;
            object = debuggableFileFinder3 != null ? debuggableFileFinder3.guessFile(url, project) : null;
        }
        return object;
    }

    @Override
    public boolean searchesByName() {
        return true;
    }

    private final BiMap<String, VirtualFile> createPredefinedMappings(Project project) {
        BiMap biMap;
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        if (projectDir != null) {
            ImmutableBiMap immutableBiMap = ImmutableBiMap.of((Object)"webpack:///.", (Object)projectDir);
            Intrinsics.checkNotNullExpressionValue((Object)immutableBiMap, (String)"ImmutableBiMap.of(\"webpack:///.\", projectDir)");
            biMap = (BiMap)immutableBiMap;
        } else {
            ImmutableBiMap immutableBiMap = ImmutableBiMap.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableBiMap, (String)"ImmutableBiMap.of()");
            biMap = (BiMap)immutableBiMap;
        }
        return biMap;
    }

    public final boolean isDebuggable(@NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (file2 instanceof HttpVirtualFile) {
            return true;
        }
        if (!this.mappings.isEmpty()) {
            for (VirtualFile current = file2; current != null; current = current.getParent()) {
                if (!this.mappings.containsValue((Object)current)) continue;
                return true;
            }
        }
        if (this.parent instanceof DebuggableFileFinderImpl && ((DebuggableFileFinderImpl)this.parent).isDebuggable(file2, project)) {
            return true;
        }
        String string = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        return RemoteDebuggingFileFinderKt.access$findByName(string, project, null) != null;
    }

    @Override
    public boolean canSetRemoteUrl(@NotNull VirtualFile file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(project)");
        return projectRootManager.getFileIndex().isInContent(file2);
    }

    @Override
    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!(file2 instanceof HttpVirtualFile) && !this.mappings.isEmpty()) {
            BiMap map2 = this.mappings.inverse();
            for (VirtualFile current = file2; current != null; current = current.getParent()) {
                String url = (String)map2.get((Object)current);
                if (url == null) continue;
                if (Intrinsics.areEqual((Object)current, (Object)file2)) {
                    return CollectionsKt.listOf((Object)Urls.newFromIdea((CharSequence)url));
                }
                return CollectionsKt.listOf((Object)Urls.newFromIdea((CharSequence)(url + '/' + VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)current, (char)'/'))));
            }
        }
        if ((object = this.parent) == null || (object = object.getRemoteUrls(file2)) == null) {
            object = CollectionsKt.listOf((Object)Urls.newFromVirtualFile((VirtualFile)file2));
        }
        return object;
    }

    public final boolean updateRemoteUrlMapping(@NotNull List<? extends RemoteUrlMappingBean> mappings) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        BiMap<String, VirtualFile> newMap = RemoteDebuggingFileFinderKt.createUrlToLocalMap(mappings);
        if (Intrinsics.areEqual(newMap, this.mappings) ^ true) {
            this.mappings = newMap;
            return true;
        }
        return false;
    }

    @NotNull
    public String toString() {
        String string = Joiner.on((String)"\n ").withKeyValueSeparator("->").join((Map)this.mappings);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Joiner.on(\"\\n \").withKey\u2026ator(\"->\").join(mappings)");
        return string;
    }

    @Nullable
    public final DebuggableFileFinder getParent$intellij_javascript_debugger() {
        return this.parent;
    }

    public RemoteDebuggingFileFinder(@NotNull BiMap<String, VirtualFile> mappings, @Nullable DebuggableFileFinder parent) {
        Intrinsics.checkNotNullParameter(mappings, (String)"mappings");
        this.parent = parent;
        this.mappings = mappings;
    }

    public /* synthetic */ RemoteDebuggingFileFinder(BiMap biMap, DebuggableFileFinder debuggableFileFinder, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ImmutableBiMap immutableBiMap = ImmutableBiMap.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableBiMap, (String)"ImmutableBiMap.of()");
            biMap = (BiMap)immutableBiMap;
        }
        if ((n & 2) != 0) {
            debuggableFileFinder = null;
        }
        this((BiMap<String, VirtualFile>)biMap, debuggableFileFinder);
    }

    public RemoteDebuggingFileFinder() {
        this(null, null, 3, null);
    }

    @Override
    public boolean isOnlySourceMappedBreakpoints(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return DebuggableFileFinder.DefaultImpls.isOnlySourceMappedBreakpoints(this, file2);
    }
}

