/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.actions;

import com.google.gson.Gson;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.platform.templates.github.DownloadUtil;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.ListWithFilter;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.ZipUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.actions.InstallVSCodePluginAction;
import org.jetbrains.plugins.textmate.actions.Plugin;
import org.jetbrains.plugins.textmate.configuration.BundleConfigBean;
import org.jetbrains.plugins.textmate.configuration.TextMateSettings;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0002J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J$\u0010\u0014\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/textmate/actions/InstallVSCodePluginAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "fetchPlugins", "", "Lorg/jetbrains/plugins/textmate/actions/Plugin;", "install", "project", "Lcom/intellij/openapi/project/Project;", "selectedValue", "popup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "loadPlugins", "reader", "Ljava/io/BufferedReader;", "updateList", "list", "Lcom/intellij/ui/components/JBList;", "model", "Lcom/intellij/ui/SortedListModel;", "intellij.textmate"})
public final class InstallVSCodePluginAction
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        Object object = actionPerformed.model.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            };
        }
        SortedListModel model2 = new SortedListModel(Comparator.comparing((Function)object));
        JBList list = new JBList((ListModel)model2);
        this.updateList((JBList<Plugin>)list, (SortedListModel<Plugin>)model2);
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)list));
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"ScrollPaneFactory.createScrollPane(list)");
        JScrollPane scroll = jScrollPane;
        scroll.setBorder((Border)JBUI.Borders.empty());
        JList jList = (JList)list;
        Object object2 = actionPerformed.pane.1.INSTANCE;
        if (object2 != null) {
            Function1 function1 = object2;
            object2 = new com.intellij.util.Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ Object fun(Object p0) {
                    return this.function.invoke(p0);
                }
            };
        }
        JComponent jComponent = ListWithFilter.wrap((JList)jList, (JScrollPane)scroll, (com.intellij.util.Function)((com.intellij.util.Function)object2));
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"ListWithFilter.wrap(list\u2026scroll, Plugin::toString)");
        JComponent pane2 = jComponent;
        ComponentPopupBuilder componentPopupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder(pane2, (JComponent)list).setMayBeParent(true).setRequestFocus(true).setFocusable(true).setFocusOwners(new Component[]{(Component)list}).setLocateWithinScreenBounds(true).setCancelOnOtherWindowOpen(true).setMovable(true).setResizable(true).setTitle("Install VSCode plugin").setCancelOnWindowDeactivation(false).setCancelOnClickOutside(true).setDimensionServiceKey(project2, "install.vscode.plugin", true).setMinSize(new Dimension(JBUI.scale((int)350), JBUI.scale((int)300))).setCancelButton(new IconButton("Close", AllIcons.Actions.Close, AllIcons.Actions.CloseHovered));
        Intrinsics.checkNotNullExpressionValue((Object)componentPopupBuilder, (String)"JBPopupFactory\n      .ge\u2026ns.Actions.CloseHovered))");
        ComponentPopupBuilder builder = componentPopupBuilder;
        JBPopup jBPopup = builder.createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"builder.createPopup()");
        JBPopup popup = jBPopup;
        list.addKeyListener((KeyListener)new KeyAdapter(this, list, project2, popup){
            final /* synthetic */ InstallVSCodePluginAction this$0;
            final /* synthetic */ JBList $list;
            final /* synthetic */ Project $project;
            final /* synthetic */ JBPopup $popup;

            public void keyPressed(@Nullable KeyEvent e) {
                if (this.$list.getSelectedValue() == null) {
                    return;
                }
                KeyEvent keyEvent = e;
                if (keyEvent != null) {
                    if (keyEvent.getKeyCode() == 10) {
                        e.consume();
                        Object object = this.$list.getSelectedValue();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"list.selectedValue");
                        InstallVSCodePluginAction.access$install(this.this$0, this.$project, (Plugin)object, this.$popup);
                    }
                }
            }
            {
                this.this$0 = this$0;
                this.$list = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$popup = $captured_local_variable$3;
            }
        });
        new DoubleClickListener(this, list, project2, popup){
            final /* synthetic */ InstallVSCodePluginAction this$0;
            final /* synthetic */ JBList $list;
            final /* synthetic */ Project $project;
            final /* synthetic */ JBPopup $popup;

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$list.getSelectedValue() == null) {
                    return true;
                }
                Object object = this.$list.getSelectedValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"list.selectedValue");
                InstallVSCodePluginAction.access$install(this.this$0, this.$project, (Plugin)object, this.$popup);
                return true;
            }
            {
                this.this$0 = this$0;
                this.$list = $captured_local_variable$1;
                this.$project = $captured_local_variable$2;
                this.$popup = $captured_local_variable$3;
            }
        }.installOn((Component)list);
        popup.showCenteredInCurrentWindow(project2);
    }

    private final void updateList(JBList<Plugin> list, SortedListModel<Plugin> model2) {
        list.setPaintBusy(true);
        model2.clear();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(this, model2, list){
            final /* synthetic */ InstallVSCodePluginAction this$0;
            final /* synthetic */ SortedListModel $model;
            final /* synthetic */ JBList $list;

            public final void run() {
                List plugins = InstallVSCodePluginAction.access$fetchPlugins(this.this$0);
                ApplicationManager.getApplication().invokeLater(new Runnable(this, plugins){
                    final /* synthetic */ updateList.1 this$0;
                    final /* synthetic */ List $plugins;

                    public final void run() {
                        this.this$0.$model.addAll((Collection)this.$plugins);
                        this.this$0.$list.setPaintBusy(false);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$plugins = list;
                    }
                });
            }
            {
                this.this$0 = installVSCodePluginAction;
                this.$model = sortedListModel;
                this.$list = jBList;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final List<Plugin> fetchPlugins() {
        void plugins;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = CollectionsKt.emptyList();
        HttpRequests.request((String)"https://vscode.blob.core.windows.net/gallery/index").connect(new HttpRequests.RequestProcessor(this, (Ref.ObjectRef)plugins){
            final /* synthetic */ InstallVSCodePluginAction this$0;
            final /* synthetic */ Ref.ObjectRef $plugins;

            public final void process(@NotNull HttpRequests.Request request) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                BufferedReader bufferedReader = request.getReader();
                Intrinsics.checkNotNullExpressionValue((Object)bufferedReader, (String)"request.reader");
                this.$plugins.element = InstallVSCodePluginAction.access$loadPlugins(this.this$0, bufferedReader);
            }
            {
                this.this$0 = installVSCodePluginAction;
                this.$plugins = objectRef;
            }
        });
        return (List)plugins.element;
    }

    private final List<Plugin> loadPlugins(BufferedReader reader) {
        List list;
        Object results;
        Object v3;
        Object v2;
        boolean bl = false;
        List plugins = new ArrayList();
        Object response = new Gson().fromJson((Reader)reader, Object.class);
        Object object = response;
        if (!(object instanceof Map)) {
            object = null;
        }
        Map map = (Map)object;
        if (map != null) {
            Map map2 = map;
            String string = "results";
            boolean bl2 = false;
            v2 = map2.get(string);
        } else {
            v2 = null;
        }
        if (!((v3 = (results = v2)) instanceof List)) {
            v3 = null;
        }
        if ((list = (List)v3) == null) {
            list = CollectionsKt.emptyList();
        }
        for (Object result : list) {
            List list2;
            Object extensions;
            Object v7;
            Object v6;
            Object e = result;
            if (!(e instanceof Map)) {
                e = null;
            }
            if ((Map)e != null) {
                Map map3;
                String string = "extensions";
                boolean bl3 = false;
                v6 = map3.get(string);
            } else {
                v6 = null;
            }
            if (!((v7 = (extensions = v6)) instanceof List)) {
                v7 = null;
            }
            if ((list2 = (List)v7) == null) {
                list2 = CollectionsKt.emptyList();
            }
            for (Object extension : list2) {
                Object url;
                Object v20;
                Object versions;
                Object v17;
                Object v16;
                Object publisherName;
                Object v14;
                Object publisher;
                Object v13;
                Object v12;
                Object extensionName;
                Object v10;
                String string;
                Object e2 = extension;
                if (!(e2 instanceof Map)) {
                    e2 = null;
                }
                if ((Map)e2 != null) {
                    Map map4;
                    string = "extensionName";
                    boolean bl4 = false;
                    v10 = map4.get(string);
                } else {
                    v10 = null;
                }
                if (!((extensionName = v10) instanceof String)) continue;
                Object e3 = extension;
                if (!(e3 instanceof Map)) {
                    e3 = null;
                }
                if ((Map)e3 != null) {
                    String string2 = "publisher";
                    boolean bl5 = false;
                    v12 = string.get(string2);
                } else {
                    v12 = null;
                }
                if (!((v13 = (publisher = v12)) instanceof Map)) {
                    v13 = null;
                }
                if ((Map)v13 != null) {
                    Map map5;
                    String string3 = "publisherName";
                    boolean bl6 = false;
                    v14 = map5.get(string3);
                } else {
                    v14 = null;
                }
                if (!((publisherName = v14) instanceof String)) continue;
                Object e4 = extension;
                if (!(e4 instanceof Map)) {
                    e4 = null;
                }
                if ((Map)e4 != null) {
                    Map map6;
                    String string4 = "versions";
                    boolean bl7 = false;
                    v16 = map6.get(string4);
                } else {
                    v16 = null;
                }
                if (!((v17 = (versions = v16)) instanceof List)) {
                    v17 = null;
                }
                List list3 = v17;
                Object version = list3 != null ? CollectionsKt.first((List)list3) : null;
                Object object2 = version;
                if (!(object2 instanceof Map)) {
                    object2 = null;
                }
                if ((Map)object2 != null) {
                    Map map7;
                    String string5 = "assetUri";
                    boolean bl8 = false;
                    v20 = map7.get(string5);
                } else {
                    v20 = null;
                }
                if (!((url = v20) instanceof String)) continue;
                plugins.add(new Plugin(extensionName, publisherName, url));
            }
        }
        return plugins;
    }

    private final void install(Project project, Plugin selectedValue, JBPopup popup) {
        popup.closeOk(null);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(selectedValue, project, project, "Installing " + selectedValue, false, PerformInBackgroundOption.ALWAYS_BACKGROUND){
            final /* synthetic */ Plugin $selectedValue;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                indicator.setText("Downloading " + this.$selectedValue + "...");
                File temp = File.createTempFile("vscode", "");
                DownloadUtil.downloadAtomically((ProgressIndicator)indicator, (String)(this.$selectedValue.getUrl() + "/Microsoft.VisualStudio.Services.VSIXPackage"), (File)temp);
                indicator.setText("Unzipping " + this.$selectedValue + "...");
                File extensionDir = PathManager.getConfigDir().resolve("vscode").resolve(this.$selectedValue.getName()).toFile();
                ZipUtil.extract((File)temp, (File)extensionDir, null);
                indicator.setText("Applying " + this.$selectedValue);
                TextMateSettings textMateSettings = TextMateSettings.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)textMateSettings, (String)"TextMateSettings.getInstance()");
                TextMateSettings.TextMateSettingsState textMateSettingsState = textMateSettings.getState();
                if (textMateSettingsState == null) {
                    textMateSettingsState = new TextMateSettings.TextMateSettingsState();
                }
                Intrinsics.checkNotNullExpressionValue((Object)textMateSettingsState, (String)"TextMateSettings.getInst\u2026s.TextMateSettingsState()");
                TextMateSettings.TextMateSettingsState state = textMateSettingsState;
                state.getBundles().add(new BundleConfigBean(this.$selectedValue.toString(), new File(extensionDir, "extension").getPath(), true));
                TextMateService.getInstance().reloadEnabledBundles();
            }
            {
                this.$selectedValue = $captured_local_variable$0;
                this.$project = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    public static final /* synthetic */ void access$install(InstallVSCodePluginAction $this, Project project, Plugin selectedValue, JBPopup popup) {
        $this.install(project, selectedValue, popup);
    }

    public static final /* synthetic */ List access$fetchPlugins(InstallVSCodePluginAction $this) {
        return $this.fetchPlugins();
    }

    public static final /* synthetic */ List access$loadPlugins(InstallVSCodePluginAction $this, BufferedReader reader) {
        return $this.loadPlugins(reader);
    }
}

