/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.jsonProtocol.EventMap;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.RequestInfo;
import org.jetbrains.wip.WipCommandProcessor;
import org.jetbrains.wip.protocol.ProtocolResponseReader;
import org.jetbrains.wip.protocol.network.LoadingFailedEventData;
import org.jetbrains.wip.protocol.network.NetworkKt;
import org.jetbrains.wip.protocol.network.RequestWillBeSentEventData;
import org.jetbrains.wip.protocol.network.ResponseReceivedEventData;
import org.jetbrains.wip.protocol.network.ResponseValue;
import org.jetbrains.wip.protocol.page.FrameDetachedEventData;
import org.jetbrains.wip.protocol.page.FrameNavigatedEventData;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\t2\b\u0010\u0010\u001a\u0004\u0018\u00010\bR\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/wip/WipNetworkManager;", "", "eventMap", "Lorg/jetbrains/jsonProtocol/EventMap;", "Lorg/jetbrains/wip/protocol/ProtocolResponseReader;", "(Lorg/jetbrains/jsonProtocol/EventMap;)V", "idToRequest", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/jetbrains/wip/RequestInfo;", "enable", "Lorg/jetbrains/concurrency/Promise;", "", "commandProcessor", "Lorg/jetbrains/wip/WipCommandProcessor;", "retrieveRequest", "requestId", "intellij.javascript.wip.backend"})
public final class WipNetworkManager {
    private final ConcurrentHashMap<String, RequestInfo> idToRequest;

    @NotNull
    public final Promise<Unit> enable(@NotNull WipCommandProcessor commandProcessor2) {
        Intrinsics.checkNotNullParameter((Object)((Object)commandProcessor2), (String)"commandProcessor");
        return commandProcessor2.send((Request)NetworkKt.Enable$default(null, null, null, 7, null));
    }

    @Nullable
    public final RequestInfo retrieveRequest(@Nullable String requestId) {
        CharSequence charSequence = requestId;
        boolean bl = false;
        boolean bl2 = false;
        return charSequence == null || charSequence.length() == 0 ? null : this.idToRequest.remove(requestId);
    }

    public WipNetworkManager(@NotNull EventMap<ProtocolResponseReader> eventMap) {
        Intrinsics.checkNotNullParameter(eventMap, (String)"eventMap");
        this.idToRequest = new ConcurrentHashMap();
        eventMap.add((EventType)RequestWillBeSentEventData.TYPE, (Function1)new Function1<RequestWillBeSentEventData, Unit>(){

            public final void invoke(@NotNull RequestWillBeSentEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ((Map)idToRequest).put(it.requestId(), new RequestInfo(it.getFrameId(), it.request(), it.initiator(), it.loaderId()));
            }
        });
        eventMap.add((EventType)LoadingFailedEventData.TYPE, (Function1)new Function1<LoadingFailedEventData, Unit>(){

            public final void invoke(@NotNull LoadingFailedEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                RequestInfo request = (RequestInfo)idToRequest.get(it.requestId());
                if (request != null) {
                    request.setFailed$intellij_javascript_wip_backend(true);
                    request.setFailDescription$intellij_javascript_wip_backend(it.errorText());
                }
            }
        });
        eventMap.add((EventType)ResponseReceivedEventData.TYPE, (Function1)new Function1<ResponseReceivedEventData, Unit>(){

            public final void invoke(@NotNull ResponseReceivedEventData it) {
                block3: {
                    block2: {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ResponseValue response = it.response();
                        if (response.headers().isEmpty()) break block2;
                        CharSequence charSequence = response.mimeType();
                        boolean bl = false;
                        if (!(charSequence.length() == 0) && response.getStatus() != 0) break block3;
                    }
                    return;
                }
                idToRequest.remove(it.requestId());
            }
        });
        eventMap.add((EventType)FrameDetachedEventData.TYPE, (Function1)new Function1<FrameDetachedEventData, Unit>(){

            public final void invoke(@NotNull FrameDetachedEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String frameId = it.frameId();
                Iterator iterator = idToRequest.values().iterator();
                while (iterator.hasNext()) {
                    Object v = iterator.next();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"iterator.next()");
                    RequestInfo item = (RequestInfo)v;
                    if (!Intrinsics.areEqual((Object)item.getFrameId(), (Object)frameId)) continue;
                    iterator.remove();
                }
            }
        });
        eventMap.add((EventType)FrameNavigatedEventData.TYPE, (Function1)new Function1<FrameNavigatedEventData, Unit>(){

            public final void invoke(@NotNull FrameNavigatedEventData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String frameId = it.frame().id();
                String loaderId = it.frame().loaderId();
                Iterator iterator = idToRequest.values().iterator();
                while (iterator.hasNext()) {
                    Object v = iterator.next();
                    Intrinsics.checkNotNullExpressionValue(v, (String)"iterator.next()");
                    RequestInfo item = (RequestInfo)v;
                    if (!Intrinsics.areEqual((Object)item.getFrameId(), (Object)frameId) || !(Intrinsics.areEqual((Object)item.getLoaderId(), (Object)loaderId) ^ true)) continue;
                    iterator.remove();
                }
            }
        });
    }
}

