/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u001a\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\"\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0006\u00a2\u0006\u0002\u0010\u0007J+\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\t2\u0012\u0010\u000b\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\f0\u0003\u00a2\u0006\u0002\u0010\rR\u0018\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/ObjectEventData;", "", "values", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "([Lcom/intellij/internal/statistic/eventLog/events/EventPair;)V", "", "(Ljava/util/List;)V", "buildObjectData", "", "", "allowedFields", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "([Lcom/intellij/internal/statistic/eventLog/events/EventField;)Ljava/util/Map;", "intellij.platform.statistics"})
public final class ObjectEventData {
    private final List<EventPair<?>> values;

    @NotNull
    public final Map<String, Object> buildObjectData(@NotNull EventField<?>[] allowedFields) {
        Intrinsics.checkNotNullParameter(allowedFields, (String)"allowedFields");
        FeatureUsageData data = new FeatureUsageData();
        for (EventPair<?> eventPair : this.values) {
            EventField<?> eventField = eventPair.getField();
            if (!ArraysKt.contains((Object[])allowedFields, eventField)) {
                throw (Throwable)new IllegalArgumentException("Field " + eventField.getName() + " is not in allowed object fields");
            }
            eventPair.addData(data);
        }
        return data.build();
    }

    public ObjectEventData(@NotNull List<? extends EventPair<?>> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.values = values;
    }

    public ObjectEventData(EventPair<?> ... values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this(CollectionsKt.listOf((Object[])Arrays.copyOf(values, values.length)));
    }
}

