/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.oracle.psi;

import com.intellij.database.dialects.oracle.model.properties.OraCollectionTypeKind;
import com.intellij.database.dialects.oracle.types.OraNestedTableType;
import com.intellij.database.dialects.oracle.types.OraVaryingArrayType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.oracle.OraTypes;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDasTypeAwareElement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlCompositeElementImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlTypeFactory;
import org.jetbrains.annotations.NotNull;

public class OraCollectionTypeElementImpl
extends SqlCompositeElementImpl
implements SqlTypeElement {
    private volatile DataType myDataType;

    public OraCollectionTypeElementImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            OraCollectionTypeElementImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    public void accept(SqlVisitor visitor) {
        visitor.visitSqlTypeElement((SqlTypeElement)this);
    }

    public void clearCaches() {
        super.clearCaches();
        this.myDataType = null;
    }

    @NotNull
    public DataType getDataType() {
        if (this.myDataType == null) {
            this.myDataType = DataTypeFactory.of((String)"TABLE");
            if (this.myDataType == null) {
                OraCollectionTypeElementImpl.$$$reportNull$$$0(1);
            }
            return this.myDataType;
        }
        DataType dataType = this.myDataType;
        if (dataType == null) {
            OraCollectionTypeElementImpl.$$$reportNull$$$0(2);
        }
        return dataType;
    }

    @NotNull
    public SqlType findSqlType() {
        SqlTypeElement type = (SqlTypeElement)PsiTreeUtil.getChildOfType((PsiElement)this, SqlTypeElement.class);
        if (type != null) {
            SqlTableType sqlTableType = SqlTableTypeBase.ensureTableType((SqlType)type.findSqlType(), (DasType)type.getDasType(), (PsiElement)this, (PsiElement)this).concretize(SqlType.Category.ARRAY);
            if (sqlTableType == null) {
                OraCollectionTypeElementImpl.$$$reportNull$$$0(3);
            }
            return sqlTableType;
        }
        SqlType sqlType = SqlTypeFactory.of((DataType)this.getDataType(), (SqlLanguageDialect)SqlImplUtil.getSqlDialectSafe((PsiElement)this));
        if (sqlType == null) {
            OraCollectionTypeElementImpl.$$$reportNull$$$0(4);
        }
        return sqlType;
    }

    @NotNull
    public OraCollectionTypeKind getKind() {
        IElementType starterType = PsiUtilCore.getElementType((PsiElement)this.getFirstChild());
        if (starterType == OraTypes.ORA_VARYING || starterType == OraTypes.ORA_VARRAY) {
            OraCollectionTypeKind oraCollectionTypeKind = OraCollectionTypeKind.VARIABLE_SIZE_ARRAY;
            if (oraCollectionTypeKind == null) {
                OraCollectionTypeElementImpl.$$$reportNull$$$0(5);
            }
            return oraCollectionTypeKind;
        }
        OraCollectionTypeKind oraCollectionTypeKind = this.findChildByType(OraTypes.ORA_INDEX) != null ? OraCollectionTypeKind.ASSOCIATIVE_ARRAY : OraCollectionTypeKind.NESTED_TABLE;
        if (oraCollectionTypeKind == null) {
            OraCollectionTypeElementImpl.$$$reportNull$$$0(6);
        }
        return oraCollectionTypeKind;
    }

    @NotNull
    public DasType getDasType() {
        DasType dasType = SqlImplUtil.getCacheableDasType((PsiElement)this, () -> {
            SqlDasTypeAwareElement typeElement = (SqlDasTypeAwareElement)PsiTreeUtil.getChildOfAnyType((PsiElement)this, (Class[])new Class[]{SqlTypeElement.class, SqlReferenceExpression.class});
            DasType elementType = typeElement != null ? typeElement.getDasType() : DasType.UNKNOWN;
            switch (this.getKind()) {
                case ASSOCIATIVE_ARRAY: {
                    SqlDasTypeAwareElement indexTypeElement = (SqlDasTypeAwareElement)PsiTreeUtil.getNextSiblingOfType((PsiElement)typeElement, SqlDasTypeAwareElement.class);
                    DasType indexType = indexTypeElement != null ? indexTypeElement.getDasType() : null;
                    return new OraNestedTableType(elementType, indexType);
                }
                case NESTED_TABLE: {
                    return new OraNestedTableType(elementType);
                }
                case VARIABLE_SIZE_ARRAY: {
                    PsiElement maxSizePsi = this.findPsiChildByType((IElementType)SqlCompositeElementTypes.SQL_NUMERIC_LITERAL);
                    int maxSize = StringUtil.parseInt((String)(maxSizePsi != null ? maxSizePsi.getText() : null), (int)0);
                    return new OraVaryingArrayType(maxSize, elementType);
                }
            }
            return DasType.UNKNOWN;
        });
        if (dasType == null) {
            OraCollectionTypeElementImpl.$$$reportNull$$$0(7);
        }
        return dasType;
    }

    public String getDisplayName() {
        return this.getDataType().getSpecification();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/oracle/psi/OraCollectionTypeElementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/oracle/psi/OraCollectionTypeElementImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findSqlType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

