/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.project.dependencies;

import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.util.BooleanBiFunction;
import com.intellij.openapi.externalSystem.util.IteratorUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDependencyNode
implements DependencyNode,
Serializable {
    private final long id;
    @NotNull
    private final List<DependencyNode> dependencies;
    private String resolutionState;

    protected AbstractDependencyNode(long id) {
        this.id = id;
        this.dependencies = new ArrayList<DependencyNode>(0);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    @NotNull
    public List<DependencyNode> getDependencies() {
        List<DependencyNode> list = this.dependencies;
        if (list == null) {
            AbstractDependencyNode.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @Nullable
    public String getResolutionState() {
        return this.resolutionState;
    }

    public void setResolutionState(@Nullable String resolutionState) {
        this.resolutionState = resolutionState;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDependencyNode node = (AbstractDependencyNode)o;
        if (this.id != node.id) {
            return false;
        }
        if (this.resolutionState != null ? !this.resolutionState.equals(node.resolutionState) : node.resolutionState != null) {
            return false;
        }
        if (!this.match(node)) {
            return false;
        }
        return AbstractDependencyNode.match(this.dependencies, node.dependencies);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.dependencies.size();
        result = 31 * result + (this.resolutionState != null ? this.resolutionState.hashCode() : 0);
        return result;
    }

    protected abstract boolean match(AbstractDependencyNode var1);

    private static boolean match(@NotNull Collection<DependencyNode> dependencies1, @NotNull Collection<DependencyNode> dependencies2) {
        if (dependencies1 == null) {
            AbstractDependencyNode.$$$reportNull$$$0(1);
        }
        if (dependencies2 == null) {
            AbstractDependencyNode.$$$reportNull$$$0(2);
        }
        return IteratorUtils.match(new DependenciesIterator(dependencies1), new DependenciesIterator(dependencies2), new BooleanBiFunction<DependencyNode, DependencyNode>(){

            @Override
            public Boolean fun(DependencyNode o1, DependencyNode o2) {
                if (o1 instanceof AbstractDependencyNode && o2 instanceof AbstractDependencyNode) {
                    AbstractDependencyNode o11 = (AbstractDependencyNode)o1;
                    AbstractDependencyNode o21 = (AbstractDependencyNode)o2;
                    if (o11.id != o21.id) {
                        return false;
                    }
                    if (o11.resolutionState != null ? !o11.resolutionState.equals(o21.resolutionState) : o21.resolutionState != null) {
                        return false;
                    }
                    return o11.match(o21);
                }
                return o1 == null ? o2 == null : o1.equals(o2);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/model/project/dependencies/AbstractDependencyNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies1";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencies2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/model/project/dependencies/AbstractDependencyNode";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "match";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DependenciesIterator
    extends IteratorUtils.AbstractObjectGraphIterator<DependencyNode> {
        private DependenciesIterator(Collection<DependencyNode> dependencies) {
            super(dependencies);
        }

        @Override
        public Collection<? extends DependencyNode> getChildren(DependencyNode node) {
            return node.getDependencies();
        }
    }
}

