/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.refactoring;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.refactoring.SqlSubqueryUtils;
import com.intellij.sql.refactoring.SqlSubqueryUtilsCore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlExtractNamedQueryAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SqlExtractNamedQueryAction.$$$reportNull$$$0(0);
        }
        this.invoke(SqlExtractNamedQueryAction.getEditor(e), SqlExtractNamedQueryAction.getPsiFile(e));
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            SqlExtractNamedQueryAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = e.getPresentation();
        Editor editor = SqlExtractNamedQueryAction.getEditor(e);
        PsiFile file = SqlExtractNamedQueryAction.getPsiFile(e);
        boolean visible = editor != null && file != null;
        boolean enabled = visible;
        if (enabled) {
            SqlExpression subquery = SqlSubqueryUtils.smartFindQuery(editor, file);
            SqlExpression query = SqlSubqueryUtilsCore.findEnclosingQueryWithContext((PsiElement)subquery);
            enabled = SqlSubqueryUtils.isSubquery(query, subquery) && SqlSubqueryUtils.isCTESupported(file);
        }
        presentation.setVisible(visible);
        presentation.setEnabled(enabled);
    }

    public void invoke(Editor editor, PsiFile file) {
        if (!SqlSubqueryUtils.isCTESupported(file)) {
            return;
        }
        SqlExpression subquery = SqlSubqueryUtils.smartFindQuery(editor, file);
        SqlExpression query = SqlSubqueryUtilsCore.findEnclosingQueryWithContext((PsiElement)subquery);
        if (!SqlSubqueryUtils.isSubquery(query, subquery)) {
            return;
        }
        if (!SqlSubqueryUtils.canExtractWithoutContextLoss(subquery)) {
            return;
        }
        SqlSubqueryUtils.extractCte(editor.getProject(), editor, file, subquery, query);
    }

    @Nullable
    private static Editor getEditor(@NotNull AnActionEvent e) {
        if (e == null) {
            SqlExtractNamedQueryAction.$$$reportNull$$$0(2);
        }
        return (Editor)e.getData(CommonDataKeys.EDITOR);
    }

    @Nullable
    private static PsiFile getPsiFile(@NotNull AnActionEvent e) {
        if (e == null) {
            SqlExtractNamedQueryAction.$$$reportNull$$$0(3);
        }
        return (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "com/intellij/sql/refactoring/SqlExtractNamedQueryAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

