/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.types.DasType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlJoinConditionClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlLateralAwareExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTokenType;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlBinaryExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlJoinExpressionImpl
extends SqlBinaryExpressionImpl
implements SqlJoinExpression {
    private volatile CachedValue<SqlTableType> myType;

    public SqlJoinExpressionImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    @Override
    public void accept(SqlVisitor visitor2) {
        visitor2.visitSqlJoinExpression((SqlJoinExpression)this);
    }

    @Override
    @NotNull
    public PsiElement getOpSignElement() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType type = child.getElementType();
            if (!(type instanceof SqlKeywordTokenType) && type != SqlCommonTokens.SQL_COMMA) continue;
            PsiElement psiElement = child.getPsi();
            if (psiElement == null) {
                SqlJoinExpressionImpl.$$$reportNull$$$0(1);
            }
            return psiElement;
        }
        throw new AssertionError();
    }

    @Override
    @NotNull
    public IElementType getOpSign() {
        SqlTokenType sqlTokenType = SqlCommonKeywords.SQL_JOIN;
        if (sqlTokenType == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(2);
        }
        return sqlTokenType;
    }

    public boolean isLeft() {
        PsiElement element2 = this.getOpSignElement();
        return PsiTreeUtil.findSiblingForward((PsiElement)element2, (IElementType)SqlCommonKeywords.SQL_LEFT, (boolean)false, null) != null || PsiTreeUtil.findSiblingForward((PsiElement)element2, (IElementType)SqlCommonKeywords.SQL_FULL, (boolean)false, null) != null;
    }

    public boolean isRight() {
        PsiElement element2 = this.getOpSignElement();
        return PsiTreeUtil.findSiblingForward((PsiElement)element2, (IElementType)SqlCommonKeywords.SQL_RIGHT, (boolean)false, null) != null || PsiTreeUtil.findSiblingForward((PsiElement)element2, (IElementType)SqlCommonKeywords.SQL_FULL, (boolean)false, null) != null;
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myType = null;
    }

    @NotNull
    public SqlTableType getSqlType() {
        if (this.myType == null) {
            this.myType = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)this.calcType(null), (Object[])new Object[]{this, DbPsiFacade.getInstance(this.getProject())}), false);
        }
        SqlTableType sqlTableType = (SqlTableType)this.myType.getValue();
        if (sqlTableType == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(3);
        }
        return sqlTableType;
    }

    @Override
    @NotNull
    public DasType getDasType() {
        SqlTableType sqlTableType = this.getSqlType();
        if (sqlTableType == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(4);
        }
        return sqlTableType;
    }

    @NotNull
    public SqlTableType getSqlType(@Nullable PsiElement end2) {
        if (end2 == null || !PsiTreeUtil.isContextAncestor((PsiElement)this, (PsiElement)end2, (boolean)true)) {
            SqlTableType sqlTableType = this.getSqlType();
            if (sqlTableType == null) {
                SqlJoinExpressionImpl.$$$reportNull$$$0(5);
            }
            return sqlTableType;
        }
        SqlTableType sqlTableType = this.calcType(end2);
        if (sqlTableType == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(6);
        }
        return sqlTableType;
    }

    @NotNull
    protected static SqlType getTypeLateralAware(@NotNull SqlExpression expression, @Nullable PsiElement lastToCheck, @Nullable PsiElement end2) {
        if (expression == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(7);
        }
        if (expression instanceof SqlLateralAwareExpression) {
            SqlTableType sqlTableType = ((SqlLateralAwareExpression)expression).getSqlType(end2);
            if (sqlTableType == null) {
                SqlJoinExpressionImpl.$$$reportNull$$$0(8);
            }
            return sqlTableType;
        }
        Object object = expression == lastToCheck ? SqlTableTypeBase.EMPTY_TABLE : expression.getSqlType();
        if (object == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(9);
        }
        return object;
    }

    @NotNull
    protected static DasType getDasTypeLateralAware(@NotNull SqlExpression expression, @Nullable PsiElement lastToCheck, @Nullable PsiElement end2) {
        if (expression == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(10);
        }
        if (expression instanceof SqlLateralAwareExpression) {
            SqlTableType sqlTableType = ((SqlLateralAwareExpression)expression).getSqlType(end2);
            if (sqlTableType == null) {
                SqlJoinExpressionImpl.$$$reportNull$$$0(11);
            }
            return sqlTableType;
        }
        Object object = expression == lastToCheck ? SqlTableTypeBase.EMPTY_TABLE : expression.getDasType();
        if (object == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(12);
        }
        return object;
    }

    @NotNull
    protected SqlTableType calcType(@Nullable PsiElement end2) {
        PsiElement natural;
        SqlUsingClause using;
        SqlTableType expressionType;
        PsiElement lastToCheck = this.getLastToCheck(end2);
        SqlExpression lOperand = this.getLOperand();
        SqlType lType = SqlJoinExpressionImpl.getTypeLateralAware(lOperand, lastToCheck, end2);
        SqlTableType sqlTableType = expressionType = lType instanceof SqlTableType ? (SqlTableType)lType : SqlTableTypeBase.EMPTY_TABLE;
        if (lOperand != lastToCheck) {
            for (PsiElement child = lOperand.getNextSibling(); child != null; child = child.getNextSibling()) {
                if (child instanceof SqlExpression) {
                    SqlExpression operand = (SqlExpression)child;
                    SqlType sqlType = SqlJoinExpressionImpl.getTypeLateralAware(operand, lastToCheck, end2);
                    DasType dasType = SqlJoinExpressionImpl.getDasTypeLateralAware(operand, lastToCheck, end2);
                    expressionType = expressionType.join(SqlTableTypeBase.ensureTableType(sqlType, dasType, (PsiElement)operand, (PsiElement)this));
                }
                if (child == lastToCheck) break;
            }
        }
        if ((using = (SqlUsingClause)PsiTreeUtil.getChildOfType((PsiElement)this, SqlUsingClause.class)) != null) {
            SqlReferenceList refList = using.getReferenceList();
            List list = refList != null ? refList.getReferenceList() : ContainerUtil.emptyList();
            for (SqlReferenceExpression expression : list) {
                PsiElement resolve = expression.resolve();
                if (resolve == null) continue;
                int count = expressionType.getColumnCount();
                ArrayList<PsiElement> unionColumns = new ArrayList<PsiElement>();
                for (int i2 = 0; i2 < count; ++i2) {
                    PsiElement target;
                    PsiElement element2 = expressionType.getColumnElement(i2);
                    PsiElement psiElement = target = element2 instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element2).resolve() : element2;
                    if (!resolve.isEquivalentTo(target)) continue;
                    unionColumns.add(element2);
                    break;
                }
                for (PsiElement element2 : unionColumns) {
                    expressionType = expressionType.subtract(element2);
                }
            }
        }
        if ((natural = this.findPsiChildByType((IElementType)SqlCommonKeywords.SQL_NATURAL)) != null) {
            int count = expressionType.getColumnCount();
            MultiMap map2 = new MultiMap(CollectionFactory.createCaseInsensitiveStringMap());
            for (int i3 = 0; i3 < count; ++i3) {
                String name = expressionType.getColumnName(i3);
                PsiElement element3 = expressionType.getColumnElement(i3);
                map2.putValue((Object)StringUtil.notNullize((String)name), (Object)element3);
            }
            for (Map.Entry entry : map2.entrySet()) {
                Collection value2 = (Collection)entry.getValue();
                if (value2.size() != 2) continue;
                expressionType = expressionType.subtract((PsiElement)ContainerUtil.getFirstItem((Collection)value2));
            }
        }
        SqlTableType sqlTableType2 = expressionType;
        if (sqlTableType2 == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(13);
        }
        return sqlTableType2;
    }

    @Nullable
    protected PsiElement getLastToCheck(@Nullable PsiElement end2) {
        PsiElement lastToCheck;
        for (lastToCheck = end2; lastToCheck != null && lastToCheck.getContext() != this; lastToCheck = lastToCheck.getContext()) {
        }
        return lastToCheck;
    }

    @Override
    public boolean processDeclarations(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        boolean fromAlias;
        if (processor == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(14);
        }
        if (state == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(15);
        }
        if (place == null) {
            SqlJoinExpressionImpl.$$$reportNull$$$0(16);
        }
        if (!super.processDeclarations(processor, state, lastParent, place)) {
            return false;
        }
        if (!PsiTreeUtil.isContextAncestor((PsiElement)this, (PsiElement)place, (boolean)false)) {
            return true;
        }
        boolean bl = fromAlias = lastParent instanceof SqlExpression && lastParent.getParent() == this;
        if (!fromAlias) {
            if (lastParent instanceof SqlUsingClause || lastParent instanceof SqlJoinConditionClause) {
                if (!SqlImplUtil.processDeclarationsInType(this.getLOperand(), processor, state, place)) {
                    return false;
                }
                SqlExpression rOperand = this.getROperand();
                if (rOperand != null && !SqlImplUtil.processDeclarationsInType(rOperand, processor, state, place)) {
                    return false;
                }
            } else if (!SqlImplUtil.processDeclarationsInType(this, processor, state, place)) {
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlJoinExpressionImpl";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlJoinExpressionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpSignElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpSign";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeLateralAware";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasTypeLateralAware";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calcType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTypeLateralAware";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDasTypeLateralAware";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

