/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlAlterInnerElementBlock;
import com.intellij.sql.formatter.model.SqlAlterInstructionBlock;
import com.intellij.sql.formatter.model.SqlAlterTableBlock;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlColumnBlock;
import com.intellij.sql.formatter.model.SqlColumnDefaultBlock;
import com.intellij.sql.formatter.model.SqlColumnNullabilityBlock;
import com.intellij.sql.formatter.model.SqlComma;
import com.intellij.sql.formatter.model.SqlDdlStatementBlock;
import com.intellij.sql.formatter.model.SqlFlowBlock;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlFormattingModelFunKt;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0014J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0010\u00a2\u0006\u0002\b\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/sql/formatter/model/SqlAlterTableBlock;", "Lcom/intellij/sql/formatter/model/SqlDdlStatementBlock;", "()V", "countOfElements", "", "configureFormattingAttributes", "", "countRole", "role", "Lcom/intellij/sql/formatter/model/BlockRole;", "countRole$intellij_database_sql_core_impl", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "determineRole", "node", "Lcom/intellij/lang/ASTNode;", "userRequiresExpand", "", "intellij.database.sql.core.impl"})
public final class SqlAlterTableBlock
extends SqlDdlStatementBlock {
    private int countOfElements;

    @Override
    @NotNull
    public BlockRole determineRole(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)((Object)SqlCompositeElementTypes.SQL_ALTER_INSTRUCTION)) ? BlockRole.ELEMENT : super.determineRole(node);
    }

    @Override
    public void countRole$intellij_database_sql_core_impl(@NotNull BlockRole role) {
        Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
        super.countRole$intellij_database_sql_core_impl(role);
        if (role == BlockRole.ELEMENT) {
            int n = this.countOfElements;
            this.countOfElements = n + 1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void configureFormattingAttributes() {
        void $this$forEach$iv;
        void _true_$iv;
        void $this$choose$iv;
        SqlCodeStyleSettings s2 = this.getContext().getSql();
        boolean toWrap = s2.TABLE_ALTER_INSTRUCTION_WRAP == 1;
        boolean toIndent = s2.TABLE_ALTER_INSTRUCTION_INDENT;
        boolean toAlign = s2.TABLE_ALTER_INSTRUCTION_ALIGN && this.countOfElements >= 2;
        boolean toAlignTypes = s2.TABLE_TYPES_ALIGN && this.countOfElements >= 2;
        boolean toAlignNullabilities = s2.TABLE_NULLABILITIES_ALIGN && this.countOfElements >= 2;
        boolean toAlignDefaults = s2.TABLE_DEFAULTS_ALIGN && this.countOfElements >= 2;
        boolean bl = toIndent;
        Indent indent = SqlFormattingFunKt.getNORMAL_INDENT();
        Indent _false_$iv = SqlFormattingFunKt.getNONE_INDENT();
        boolean $i$f$choose = false;
        Indent i2 = $this$choose$iv != false ? _true_$iv : _false_$iv;
        Wrap w = toWrap ? SqlFlowBlock.makeWrap$default(this, WrapType.ALWAYS, false, 2, null) : null;
        Alignment a2 = toAlign ? SqlFormattingModelFunKt.makeLeftAlignment() : null;
        Alignment aT = toAlignTypes ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
        Alignment aN = toAlignNullabilities ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
        Alignment aD1 = toAlignDefaults ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
        Alignment aD2 = toAlignDefaults ? SqlFormattingModelFunKt.makeLeftAlignmentBS() : null;
        Iterable $this$filter$iv = this.getNestedBlocks();
        boolean $i$f$filter = false;
        Iterable $this$jbi$iv$iv = $this$filter$iv;
        boolean $i$f$getJbi = false;
        JBIterable jBIterable = JBIterable.from((Iterable)$this$jbi$iv$iv);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"JBIterable.from(this)");
        JBIterable jBIterable2 = jBIterable.filter(SqlAlterInstructionBlock.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"this.jbi.filter(B::class.java)");
        $this$filter$iv = (Iterable)jBIterable2;
        boolean $i$f$forEach4 = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void indent$iv;
            void wrap$iv;
            void this_$iv;
            SqlAlterInstructionBlock alterInstructionBlock = (SqlAlterInstructionBlock)element$iv;
            boolean bl2 = false;
            SqlBlock sqlBlock = alterInstructionBlock;
            Wrap wrap2 = w;
            Indent indent2 = i2;
            Alignment align$iv = a2;
            boolean $i$f$setAttributes = false;
            this_$iv.setMyWrap((Wrap)wrap$iv);
            this_$iv.setMyIndent((Indent)indent$iv);
            this_$iv.setMyAlign(align$iv);
            if (!toAlignTypes && !toAlignNullabilities && !toAlignDefaults) continue;
            Iterable $this$filter$iv2 = alterInstructionBlock.getNestedBlocks();
            boolean $i$f$filter2 = false;
            Iterable $this$jbi$iv$iv2 = $this$filter$iv2;
            boolean $i$f$getJbi2 = false;
            JBIterable jBIterable3 = JBIterable.from((Iterable)$this$jbi$iv$iv2);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"JBIterable.from(this)");
            JBIterable jBIterable4 = jBIterable3.filter(SqlAlterInnerElementBlock.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"this.jbi.filter(B::class.java)");
            $this$filter$iv2 = (Iterable)jBIterable4;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                SqlColumnBlock sqlColumnBlock;
                Object v5;
                Object v4;
                block9: {
                    SqlAlterInnerElementBlock innerBlock = (SqlAlterInnerElementBlock)element$iv2;
                    boolean bl3 = false;
                    Iterable $this$find$iv = innerBlock.getNestedBlocks();
                    boolean $i$f$find = false;
                    Iterable iterable = $this$find$iv;
                    boolean bl4 = false;
                    Iterable iterable2 = iterable;
                    boolean bl5 = false;
                    for (Object t : iterable2) {
                        Block it$iv = (Block)t;
                        boolean bl6 = false;
                        if (!(it$iv instanceof SqlColumnBlock)) continue;
                        v4 = t;
                        break block9;
                    }
                    v4 = v5 = null;
                }
                if (!(v4 instanceof SqlColumnBlock)) {
                    v5 = null;
                }
                if ((SqlColumnBlock)((Block)v5) == null) continue;
                boolean bl7 = false;
                boolean bl8 = false;
                SqlColumnBlock columnBlock = sqlColumnBlock;
                boolean bl9 = false;
                boolean nullabilityWas = false;
                Iterable $this$forEach$iv3 = columnBlock.getNestedBlocks();
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    SqlBlock it2 = (SqlBlock)element$iv3;
                    boolean bl10 = false;
                    if (it2.getRole() == BlockRole.TYPE) {
                        it2.setMyAlign(aT);
                        continue;
                    }
                    if (it2 instanceof SqlColumnNullabilityBlock) {
                        nullabilityWas = true;
                        it2.setMyAlign(aN);
                        continue;
                    }
                    if (!(it2 instanceof SqlColumnDefaultBlock)) continue;
                    it2.setMyAlign(nullabilityWas ? aD2 : aD1);
                }
            }
        }
        if (s2.TABLE_TYPES_ALIGN) {
            void $this$forEach$iv4;
            Iterable $this$filter$iv3;
            Alignment columnTypeAlignment = SqlFormattingModelFunKt.makeLeftAlignmentBS();
            Iterable $i$f$forEach4 = this.getNestedBlocks();
            boolean $i$f$filter3 = false;
            Iterable $this$jbi$iv$iv3 = $this$filter$iv3;
            boolean $i$f$getJbi3 = false;
            JBIterable jBIterable5 = JBIterable.from((Iterable)$this$jbi$iv$iv3);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable5, (String)"JBIterable.from(this)");
            JBIterable jBIterable6 = jBIterable5.filter(SqlAlterInstructionBlock.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable6, (String)"this.jbi.filter(B::class.java)");
            JBIterable jBIterable7 = jBIterable6.flatten((Function)configureFormattingAttributes.2.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable7, (String)"nestedBlocks\n        .fi\u2026atten { it.nestedBlocks }");
            $this$filter$iv3 = (Iterable)jBIterable7;
            $i$f$filter3 = false;
            $this$jbi$iv$iv3 = $this$filter$iv3;
            $i$f$getJbi3 = false;
            JBIterable jBIterable8 = JBIterable.from((Iterable)$this$jbi$iv$iv3);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable8, (String)"JBIterable.from(this)");
            JBIterable jBIterable9 = jBIterable8.filter(SqlAlterInnerElementBlock.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable9, (String)"this.jbi.filter(B::class.java)");
            JBIterable jBIterable10 = jBIterable9.flatten((Function)configureFormattingAttributes.3.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable10, (String)"nestedBlocks\n        .fi\u2026atten { it.nestedBlocks }");
            $this$filter$iv3 = (Iterable)jBIterable10;
            $i$f$filter3 = false;
            $this$jbi$iv$iv3 = $this$filter$iv3;
            $i$f$getJbi3 = false;
            JBIterable jBIterable11 = JBIterable.from((Iterable)$this$jbi$iv$iv3);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable11, (String)"JBIterable.from(this)");
            JBIterable jBIterable12 = jBIterable11.filter(SqlColumnBlock.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable12, (String)"this.jbi.filter(B::class.java)");
            JBIterable jBIterable13 = jBIterable12.flatten((Function)configureFormattingAttributes.4.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable13, (String)"nestedBlocks\n        .fi\u2026atten { it.nestedBlocks }");
            $this$filter$iv3 = (Iterable)SqlFormattingModelFunKt.filter((Iterable<? extends SqlBlock>)((Iterable)jBIterable13), BlockRole.BODY);
            boolean $i$f$forEach5 = false;
            for (Object element$iv : $this$forEach$iv4) {
                SqlBlock it3 = (SqlBlock)element$iv;
                boolean bl11 = false;
                it3.setMyAlign(columnTypeAlignment);
            }
        }
    }

    @Override
    public boolean userRequiresExpand() {
        return this.getContext().getSql().TABLE_ALTER_INSTRUCTION_WRAP == 1 || this.getContext().getSql().TABLE_ALTER_INSTRUCTION_WRAP == 0;
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        return block2 instanceof SqlComma ? this.getContext().makeNoSpace(false) : (block2 instanceof SqlAlterInstructionBlock && this.getContext().getSql().TABLE_ALTER_INSTRUCTION_WRAP == 0 ? this.getContext().makeAutoSpacing(true) : super.decideSpacing(block1, block2));
    }
}

