/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.Dbms;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.view.DatabaseViewOptions;
import com.intellij.database.view.structure.DvStructureExtension;
import com.intellij.database.view.structure.DvTreeContext;
import com.intellij.database.view.structure.DvTreeLayer;
import com.intellij.openapi.Disposable;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0004J\b\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J\b\u0010\u0014\u001a\u00020\u000eH\u0016R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/view/structure/DvTreeAbstractLayer;", "Lcom/intellij/database/view/structure/DvTreeLayer;", "Lcom/intellij/openapi/Disposable;", "context", "Lcom/intellij/database/view/structure/DvTreeContext;", "(Lcom/intellij/database/view/structure/DvTreeContext;)V", "vo", "Lcom/intellij/database/view/DatabaseViewOptions;", "getVo", "()Lcom/intellij/database/view/DatabaseViewOptions;", "baseParentOf", "Lcom/intellij/database/model/basic/BasicNode;", "node", "clearAll", "", "dispose", "extension", "Lcom/intellij/database/view/structure/DvStructureExtension;", "dbms", "Lcom/intellij/database/Dbms;", "onViewOptionsChanged", "intellij.database.impl"})
public abstract class DvTreeAbstractLayer
implements DvTreeLayer,
Disposable {
    @JvmField
    @NotNull
    public final DvTreeContext context;

    @NotNull
    protected final DatabaseViewOptions getVo() {
        return this.context.vo;
    }

    @Nullable
    protected final DvStructureExtension extension(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        return DvStructureExtension.Companion.getEP().forDbms(dbms);
    }

    @Nullable
    protected final BasicNode baseParentOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        DvTreeLayer dvTreeLayer = this.getBase();
        if (dvTreeLayer == null) {
            return null;
        }
        DvTreeLayer base = dvTreeLayer;
        BasicNode p2 = base.parentOf(node);
        if (p2 == node) {
            String layerClassName = base.getClass().getSimpleName();
            throw (Throwable)new InternalError("The method " + layerClassName + ".parentOf() works incorrectly for node: " + node + " (node class: " + node.getClass().getSimpleName() + ')');
        }
        return p2;
    }

    public void onViewOptionsChanged() {
    }

    @Override
    public abstract void clearAll();

    public void dispose() {
        this.clearAll();
    }

    public DvTreeAbstractLayer(@NotNull DvTreeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @Override
    public int countChildrenOf(@NotNull BasicNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return DvTreeLayer.DefaultImpls.countChildrenOf(this, node);
    }
}

