/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.Dbms;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.SqlDialects;
import com.intellij.database.view.DatabaseDialogsHelperCore;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.ui.DsUiDefaults;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ObjectUtils;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDialogsHelper
extends DatabaseDialogsHelperCore {
    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull Project project, @NotNull DbDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull String query, boolean isViewer) {
        if (project == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(0);
        }
        if (dataSource2 == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(1);
        }
        if (query == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(2);
        }
        return DatabaseDialogsHelper.createLanguageEditorArea(project, dataSource2.getDbms(), dataSource2, searchPath, query, isViewer);
    }

    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull DatabaseEditorContext context, @Nullable SearchPath searchPath, @NotNull String query) {
        if (context == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(3);
        }
        if (query == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(4);
        }
        return DatabaseDialogsHelper.createLanguageEditorArea(context.getProject(), context.getDbms(), context.getDataSource(), searchPath, query, false);
    }

    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull Project project, @NotNull Dbms dbms, @Nullable DbDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull String query, boolean isViewer) {
        if (project == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(5);
        }
        if (dbms == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(6);
        }
        if (query == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(7);
        }
        Language language = dataSource2 != null ? DbSqlUtil.getLanguage(dataSource2) : DbSqlUtil.getLanguage(dbms);
        return DatabaseDialogsHelper.createLanguageEditorArea(project, language, dataSource2, searchPath, query, isViewer);
    }

    @NotNull
    public static EditorTextField createLanguageEditorArea(@NotNull Project project, @NotNull Language language, @Nullable DbDataSource dataSource2, @Nullable SearchPath searchPath, @NotNull String query, boolean isViewer) {
        if (project == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(8);
        }
        if (language == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(9);
        }
        if (query == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(10);
        }
        String ext = DbSqlUtilCore.isJSLanguage(language) ? "js" : "sql";
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("a." + ext, language, (CharSequence)query);
        psiFile.putUserData(DatabaseDataKeysCore.DATA_SOURCE_KEY, (Object)dataSource2);
        psiFile.putUserData(DatabaseDataKeysCore.SEARCH_PATH_KEY, (Object)searchPath);
        EditorTextField area = DatabaseDialogsHelper.createEditorTextField(psiFile, false, isViewer);
        area.setFontInheritedFromLAF(false);
        area.addSettingsProvider(editor -> {
            editor.getSettings().setWheelFontChangeEnabled(true);
            editor.getSettings().setFoldingOutlineShown(true);
            editor.setHorizontalScrollbarVisible(true);
            editor.setVerticalScrollbarVisible(true);
            editor.getSettings().setAdditionalLinesCount(2);
            editor.getSettings().setUseSoftWraps(true);
        });
        EditorTextField editorTextField2 = area;
        if (editorTextField2 == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(11);
        }
        return editorTextField2;
    }

    @NotNull
    public static EditorTextField createLanguageEditorField(PsiFile psiFile) {
        return DatabaseDialogsHelper.createEditorTextField(psiFile, true, false);
    }

    @NotNull
    public static EditorTextField createEditorTextField(PsiFile psiFile, boolean oneLine, boolean isViewer) {
        Project project = psiFile.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        EditorTextField textField = new EditorTextField(document, project, psiFile.getFileType(), isViewer, oneLine);
        textField.addSettingsProvider(editor -> {
            DatabaseDialogsHelper.setSyntaxHighlighter(project, editor);
            editor.setEmbeddedIntoDialogWrapper(true);
            editor.getSettings().setLineNumbersShown(false);
        });
        EditorTextField editorTextField2 = textField;
        if (editorTextField2 == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(12);
        }
        return editorTextField2;
    }

    private static void setSyntaxHighlighter(Project project, EditorEx editor) {
        VirtualFile file = editor.getVirtualFile();
        if (file == null) {
            file = FileDocumentManager.getInstance().getFile((Document)editor.getDocument());
        }
        SqlLanguageDialect dialect = file == null ? SqlDialects.getGenericDialect() : LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file);
        DatabaseDialogsHelper.setSpecificSyntaxHighlighter(project, (Language)dialect, editor, file);
    }

    public static void setSpecificSyntaxHighlighter(Project project, Language dialect, EditorEx editor, VirtualFile file) {
        SyntaxHighlighter highlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)dialect, (Project)project, (VirtualFile)file);
        editor.setHighlighter((EditorHighlighter)new LexerEditorHighlighter(highlighter, editor.getColorsScheme()));
    }

    public static void setTextFieldLanguage(@NotNull EditorTextField field, @NotNull SqlLanguageDialect dialect) {
        if (field == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(13);
        }
        if (dialect == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(14);
        }
        LightVirtualFile file = new LightVirtualFile("a.sql", (Language)dialect, (CharSequence)field.getText());
        field.setDocument(FileDocumentManager.getInstance().getDocument((VirtualFile)file));
    }

    public static void setupEnclosingScrollPane(@NotNull JScrollPane scrollPane) {
        if (scrollPane == null) {
            DatabaseDialogsHelper.$$$reportNull$$$0(15);
        }
        scrollPane.setBorder(null);
        JComponent view2 = (JComponent)scrollPane.getViewport().getView();
        view2.setBorder(DsUiDefaults.DEFAULT_PANEL_BORDER);
        GridLayoutManager layoutManager = (GridLayoutManager)ObjectUtils.tryCast((Object)view2.getLayout(), GridLayoutManager.class);
        if (layoutManager != null) {
            layoutManager.setHGap(5);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseDialogsHelper";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseDialogsHelper";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createLanguageEditorArea";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditorTextField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLanguageEditorArea";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setTextFieldLanguage";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setupEnclosingScrollPane";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

