/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPackage;
import com.intellij.database.psi.DbRoutine;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerator;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTaskBuilderKt;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseDefinitionHelper {
    @NotNull
    public static StringBuilder generateDefinition(@NotNull DbElement element2, @NotNull StringBuilder sb) {
        if (element2 == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(0);
        }
        if (sb == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(1);
        }
        Project project = element2.getProject();
        BasicElement e = DbImplUtilCore.getMaybeBasicElement(element2);
        if (e != null) {
            CodeStyleSettings settings = SqlCodeStyles.getSettings((Project)project, (String)ScriptingTaskBuilderKt.getCodeStyleName(element2.getDataSource()));
            CharSequence def = DatabaseDefinitionHelper.generateDefinitionUsingScriptingService(project, e, settings);
            sb.append(def);
        } else {
            sb.append("-- Unexpected: ").append(element2.getDelegate().getClass().getSimpleName()).append("\n");
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(2);
        }
        return stringBuilder;
    }

    @NotNull
    public static CharSequence generateDefinitionUsingScriptingService(@NotNull Project project, @NotNull BasicElement element2, @Nullable CodeStyleSettings settings) {
        if (project == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(3);
        }
        if (element2 == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(4);
        }
        ProgressManager.checkCanceled();
        BasicModel model = element2.getModel();
        if (model == null) {
            return "-- no model\n";
        }
        ScriptGenerator scriptGenerator = ScriptGenerators.INSTANCE.byModel(model);
        ScriptingSingleModelTaskBuilder task2 = new ScriptingSingleModelTaskBuilder(model, ScriptCategory.CREATE_DEFINITION);
        task2.getElements().add(element2);
        BasicNamespace namespace = (BasicNamespace)ObjectUtils.tryCast((Object)DbImplUtilCore.getSearchPathObject(DbImplUtilCore.getDatabaseDialect(model.getDbms()), element2), BasicNamespace.class);
        task2.setCurrentNamespace(namespace);
        ScriptingResult result2 = scriptGenerator.makeScript(project, task2.build());
        CharSequence src = DbSrcUtilsCore.formatCompositeText(project, DbSqlUtilCore.getSqlDialect(model.getDbms()), null, result2.getScript(), settings).getText();
        if (src.length() == 0) {
            src = "-- No source text available\n";
        }
        CharSequence charSequence = src;
        if (charSequence == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(5);
        }
        return charSequence;
    }

    @NotNull
    public static StringBuilder loadDefinition(@NotNull DbElement element2, @NotNull StringBuilder sb) throws Exception {
        if (element2 == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(6);
        }
        if (sb == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(7);
        }
        return DatabaseDefinitionHelper.loadDefinition(ConnectionProvider.forElement(element2, DGDepartment.INTROSPECTION), element2, sb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static StringBuilder loadDefinition(@NotNull ConnectionProvider provider, @NotNull DbElement element2, @NotNull StringBuilder sb) throws Exception {
        if (provider == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(9);
        }
        if (sb == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(10);
        }
        if (!provider.acquire()) {
            Exception exception = provider.getLastException();
            if (exception != null) {
                throw exception;
            }
            StringBuilder stringBuilder = sb;
            StringBuilder stringBuilder2 = stringBuilder;
            if (stringBuilder2 == null) {
                DatabaseDefinitionHelper.$$$reportNull$$$0(11);
            }
            return stringBuilder2;
        }
        StringBuilder stringBuilder = DatabaseDefinitionHelper.loadDefinitionImpl(provider, element2, sb);
        StringBuilder stringBuilder3 = stringBuilder;
        if (stringBuilder3 == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(12);
        }
        return stringBuilder3;
        finally {
            provider.release();
        }
    }

    @NotNull
    private static StringBuilder loadDefinitionImpl(@NotNull ConnectionProvider provider, DbElement element2, @NotNull StringBuilder sb) throws Exception {
        ObjectKind kind;
        DbPackage pkg;
        if (provider == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(13);
        }
        if (sb == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(14);
        }
        DbPackage dbPackage = pkg = (kind = element2.getKind()) == ObjectKind.PACKAGE || kind == ObjectKind.BODY || element2.getParent() instanceof DbPackage ? DasUtil.getParentOfClass(element2, DbPackage.class, false) : null;
        if (pkg != null) {
            DbImplUtil.tryLoadPackageDefinition(provider, pkg, kind == ObjectKind.PACKAGE, sb);
        } else if (element2 instanceof DbRoutine) {
            DbImplUtil.tryLoadProcedureDefinition(provider, (DbRoutine)element2, sb);
        } else if (element2 instanceof DbTable) {
            if (kind == ObjectKind.TABLE) {
                DbImplUtil.tryLoadTableDefinition(provider, (DbTable)element2, sb);
            } else if (kind == ObjectKind.VIEW) {
                DbImplUtil.tryLoadViewDefinition(provider, (DbTable)element2, sb);
            } else if (kind == ObjectKind.SEQUENCE) {
                DbImplUtil.tryLoadSequenceDefinition(provider, (DbTable)element2, sb);
            } else if (kind == ObjectKind.SYNONYM) {
                DbImplUtil.tryLoadSynonymDefinition(provider, (DbTable)element2, sb);
            }
        } else {
            throw new IllegalArgumentException("unknown element: " + element2);
        }
        if (sb.length() != 0 && sb.charAt(sb.length() - 1) != '\n') {
            sb.append('\n');
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            DatabaseDefinitionHelper.$$$reportNull$$$0(15);
        }
        return stringBuilder;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/util/DatabaseDefinitionHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/util/DatabaseDefinitionHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDefinition";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDefinitionUsingScriptingService";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefinition";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDefinitionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateDefinition";
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 15: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateDefinitionUsingScriptingService";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadDefinition";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadDefinitionImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 11: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

