/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.properties;

import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DataTypeFactory {
    private static final Pattern INNER_PATTERN = Pattern.compile("^\\s*(\\d+|\\*|max)\\s*(,\\s*(-?\\d+))?\\s*(chars?|bytes?|digits?)?\\s*$", 2);
    private static final ConcurrentMap<DataType, DataType> ourInterner = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
    private static final Set<String> ENUMS_SETS = new THashSet(Arrays.asList("enum", "enum8", "enum16", "set"), (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);

    @NotNull
    public static DataType of(@NotNull String specification) {
        if (specification == null) {
            DataTypeFactory.$$$reportNull$$$0(0);
        }
        return DataTypeFactory.of(specification, 0, false, false, null, false);
    }

    @NotNull
    public static DataType withTypeName(@NotNull DataType type, @NotNull String typeName) {
        if (type == null) {
            DataTypeFactory.$$$reportNull$$$0(1);
        }
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(2);
        }
        return DataTypeFactory.intern(type.withTypeName(typeName));
    }

    @NotNull
    public static DataType of(@NotNull String specification, int jdbcType, boolean custom, boolean hasPackage, @Nullable Variant v, boolean explicitUnits) {
        if (specification == null) {
            DataTypeFactory.$$$reportNull$$$0(3);
        }
        Trio trio = DataTypeFactory.smartSplit(specification);
        if (trio.inner != null) {
            boolean isCustom;
            boolean ok;
            if (v == null && ENUMS_SETS.contains(trio.primary) || v == Variant.ENUM) {
                return DataTypeFactory.createEnumOrRet(specification, custom, hasPackage, jdbcType);
            }
            TypeAsParts packAndName = DataTypeFactory.splitPackAndName(trio.primary, hasPackage);
            Matcher m = v == Variant.VAGUE ? null : INNER_PATTERN.matcher(trio.inner);
            boolean bl = ok = m != null && m.matches();
            boolean bl2 = v == null ? packAndName.schemaName != null : (isCustom = custom);
            if (ok) {
                LengthUnit unit;
                String sizeStr = m.group(1);
                int size = sizeStr.equals("*") ? 0x7FFFFFFE : (sizeStr.equalsIgnoreCase("max") ? Integer.MAX_VALUE : Integer.parseInt(sizeStr));
                int scale = m.group(3) != null ? Integer.parseInt(m.group(3)) : 0;
                LengthUnit lengthUnit = unit = m.group(4) != null ? LengthUnit.of(m.group(4)) : null;
                if (v == null && unit == null && scale != 0) {
                    unit = LengthUnit.DIGIT;
                }
                if (v == null) {
                    explicitUnits = m.group(4) != null;
                }
                return DataTypeFactory.of(packAndName.schemaName, packAndName.packageName, packAndName.typeName, size, scale, unit, trio.suffix, explicitUnits, isCustom, jdbcType);
            }
            if (!trio.inner.isEmpty()) {
                return DataTypeFactory.ofArgs(packAndName.schemaName, packAndName.packageName, packAndName.typeName, trio.inner, custom, jdbcType);
            }
            return DataTypeFactory.of(packAndName.schemaName, packAndName.packageName, packAndName.typeName, -1, 0, null, trio.suffix, false, isCustom, jdbcType);
        }
        TypeAsParts packAndName = DataTypeFactory.splitPackAndName(trio.primary, hasPackage);
        return DataTypeFactory.of(packAndName.schemaName, packAndName.packageName, packAndName.typeName, -1, 0, LengthUnit.NONE, trio.suffix, explicitUnits, v == null ? packAndName.schemaName != null : custom, jdbcType);
    }

    @Contract(pure=true)
    private static Trio smartSplit(@NotNull String specification) {
        if (specification == null) {
            DataTypeFactory.$$$reportNull$$$0(4);
        }
        if (StringUtil.startsWithIgnoreCase((String)specification, (String)"setof ")) {
            Trio res2 = new Trio();
            res2.primary = "setof";
            res2.suffix = StringUtil.trim((String)specification.substring("setof ".length()));
            return res2;
        }
        int n = specification.length();
        int p1 = Integer.MIN_VALUE;
        int p2 = Integer.MIN_VALUE;
        Stack stack = new Stack();
        block5: for (int i2 = 0; i2 < n; ++i2) {
            char x;
            char c2 = specification.charAt(i2);
            char c3 = x = stack.isEmpty() ? (char)'\u0000' : ((Character)stack.peek()).charValue();
            if (c2 == '(' && p1 < 0 && stack.isEmpty()) {
                p1 = i2;
            }
            if (c2 == ')' && p1 >= 0 && p2 < 0 && stack.size() == 1 && x == ')') {
                p2 = i2;
            }
            if (c2 == x) {
                stack.pop();
                if (!stack.isEmpty() || p2 <= 0) continue;
                break;
            }
            switch (c2) {
                case '\"': 
                case '\'': {
                    stack.push((Object)Character.valueOf(c2));
                    continue block5;
                }
                case '[': {
                    stack.push((Object)Character.valueOf(']'));
                    continue block5;
                }
                case '(': {
                    stack.push((Object)Character.valueOf(')'));
                }
            }
        }
        Trio trio = new Trio();
        if (p2 > 0) {
            assert (p1 >= 0);
            trio.primary = specification.substring(0, p1).trim();
            trio.inner = specification.substring(p1 + 1, p2).trim();
            trio.suffix = specification.substring(p2 + 1).trim();
            if (trio.suffix.length() == 0) {
                trio.suffix = null;
            }
        } else {
            trio.primary = specification.trim();
        }
        return trio;
    }

    @NotNull
    private static DataType createEnumOrRet(@NotNull String specification, boolean custom, boolean hasPackage, int jdbcType) {
        if (specification == null) {
            DataTypeFactory.$$$reportNull$$$0(5);
        }
        ArrayList<String> res2 = new ArrayList<String>();
        int start2 = specification.indexOf("(");
        int end2 = StringUtil.lastIndexOf((CharSequence)specification, (char)')', (int)start2, (int)specification.length());
        if (end2 > start2 && start2 > 1) {
            String meat = specification.substring(start2 + 1, end2);
            for (String s2 : StringUtil.split((String)meat, (String)",")) {
                res2.add(StringUtil.trim((String)s2));
            }
            TypeAsParts couple = DataTypeFactory.splitPackAndName(specification.substring(0, start2), hasPackage);
            return DataTypeFactory.ofValues(couple.schemaName, couple.packageName, couple.typeName, (List<String>)ContainerUtil.immutableList(res2), custom, jdbcType);
        }
        DataType dataType = DataType.UNKNOWN;
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(6);
        }
        return dataType;
    }

    @NotNull
    public static DataType ofArgs(@Nullable String schemaName, @NotNull String typeName, @Nullable String vagueArg, boolean custom) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(7);
        }
        return DataTypeFactory.ofArgs(schemaName, null, typeName, vagueArg, custom, 0);
    }

    @NotNull
    private static DataType ofArgs(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, @Nullable String vagueArg, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(8);
        }
        DataType type = new DataType(schemaName, packageName, typeName, vagueArg, custom, jdbcType);
        return DataTypeFactory.intern(type);
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(9);
        }
        return DataTypeFactory.of(schemaName, null, typeName, size, scale, sizeUnit, suffix, sizeUnitExplicit, custom, jdbcType);
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(10);
        }
        return DataTypeFactory.intern(new DataType(schemaName, packageName, typeName, size, scale, sizeUnit, sizeUnitExplicit, suffix, custom, jdbcType));
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, boolean custom) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(11);
        }
        return DataTypeFactory.of(schemaName, typeName, size, scale, sizeUnit, suffix, sizeUnitExplicit, custom, 0);
    }

    @NotNull
    public static DataType of(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, int size, int scale, @Nullable LengthUnit sizeUnit, @Nullable String suffix, boolean sizeUnitExplicit, boolean custom) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(12);
        }
        return DataTypeFactory.of(schemaName, packageName, typeName, size, scale, sizeUnit, suffix, sizeUnitExplicit, custom, 0);
    }

    @NotNull
    public static DataType ofValues(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, @NotNull List<String> values2, boolean custom) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(13);
        }
        if (values2 == null) {
            DataTypeFactory.$$$reportNull$$$0(14);
        }
        DataType type = new DataType(schemaName, packageName, typeName, custom, values2, 0);
        return DataTypeFactory.intern(type);
    }

    @NotNull
    private static DataType ofValues(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, @NotNull List<String> values2, boolean custom, int jdbcType) {
        if (typeName == null) {
            DataTypeFactory.$$$reportNull$$$0(15);
        }
        if (values2 == null) {
            DataTypeFactory.$$$reportNull$$$0(16);
        }
        DataType type = new DataType(schemaName, packageName, typeName, custom, values2, jdbcType);
        return DataTypeFactory.intern(type);
    }

    @NotNull
    private static TypeAsParts splitPackAndName(@NotNull String string, boolean hasPackage) {
        int typeNameStartOffset;
        if (string == null) {
            DataTypeFactory.$$$reportNull$$$0(17);
        }
        if ((typeNameStartOffset = string.lastIndexOf(46)) < 0) {
            return new TypeAsParts(null, null, string.trim());
        }
        String qualifier = string.substring(0, typeNameStartOffset);
        String typeName = string.substring(typeNameStartOffset + 1).trim();
        if (!hasPackage) {
            return new TypeAsParts(qualifier, null, typeName);
        }
        int packageStartOffset = qualifier.lastIndexOf(46);
        if (packageStartOffset < 0) {
            return new TypeAsParts(null, qualifier, typeName);
        }
        String schemaName = qualifier.substring(0, packageStartOffset);
        String packageName = qualifier.substring(packageStartOffset + 1);
        return new TypeAsParts(schemaName, packageName, typeName);
    }

    @NotNull
    private static DataType intern(@NotNull DataType dataType) {
        if (dataType == null) {
            DataTypeFactory.$$$reportNull$$$0(18);
        }
        DataType dataType2 = (DataType)ConcurrencyUtil.cacheOrGet(ourInterner, (Object)dataType, (Object)dataType);
        if (dataType2 == null) {
            DataTypeFactory.$$$reportNull$$$0(19);
        }
        return dataType2;
    }

    @NotNull
    public static String serialize(@NotNull DataType value2) {
        if (value2 == null) {
            DataTypeFactory.$$$reportNull$$$0(20);
        }
        StringBuilder res2 = new StringBuilder();
        res2.append(value2.getSpecification(true, false)).append("|").append(value2.jdbcType);
        if (value2.sizeUnitExplicit) {
            res2.append("u");
        }
        if (value2.custom) {
            res2.append("c");
        }
        if (value2.packageName != null) {
            res2.append("p");
        }
        res2.append(Variant.of((DataType)value2).code);
        String string = res2.toString();
        if (string == null) {
            DataTypeFactory.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public static DataType deserialize(@NotNull String value2) {
        int idx;
        if (value2 == null) {
            DataTypeFactory.$$$reportNull$$$0(22);
        }
        if ((idx = value2.lastIndexOf("|")) != -1) {
            try {
                boolean explicitUnit;
                boolean custom;
                boolean hasPackage;
                int e = value2.length();
                Variant v = Variant.of(value2.charAt(e - 1));
                if (v != null) {
                    --e;
                }
                boolean bl = hasPackage = value2.charAt(e - 1) == 'p';
                if (hasPackage) {
                    --e;
                }
                boolean bl2 = custom = value2.charAt(e - 1) == 'c';
                if (custom) {
                    --e;
                }
                boolean bl3 = explicitUnit = value2.charAt(e - 1) == 'u';
                if (explicitUnit) {
                    --e;
                }
                return DataTypeFactory.of(value2.substring(0, idx), Integer.parseInt(value2.substring(idx + 1, e)), custom, hasPackage, v, explicitUnit);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return DataTypeFactory.of(value2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specification";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 6: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/properties/DataTypeFactory";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataType";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/properties/DataTypeFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnumOrRet";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "serialize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "withTypeName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "smartSplit";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEnumOrRet";
                break;
            }
            case 6: 
            case 19: 
            case 21: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ofArgs";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "ofValues";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "splitPackAndName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum Variant {
        SIZED('s'),
        VAGUE('v'),
        ENUM('e');

        private final char code;

        private Variant(char c2) {
            this.code = c2;
        }

        @Nullable
        static Variant of(char c2) {
            for (Variant v : Variant.values()) {
                if (v.code != c2) continue;
                return v;
            }
            return null;
        }

        @NotNull
        static Variant of(@NotNull DataType dt) {
            if (dt == null) {
                Variant.$$$reportNull$$$0(0);
            }
            if (dt.vagueArg != null) {
                Variant variant = VAGUE;
                if (variant == null) {
                    Variant.$$$reportNull$$$0(1);
                }
                return variant;
            }
            if (dt.enumValues != null) {
                Variant variant = ENUM;
                if (variant == null) {
                    Variant.$$$reportNull$$$0(2);
                }
                return variant;
            }
            Variant variant = SIZED;
            if (variant == null) {
                Variant.$$$reportNull$$$0(3);
            }
            return variant;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dt";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/model/properties/DataTypeFactory$Variant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/model/properties/DataTypeFactory$Variant";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "of";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "of";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class TypeAsParts {
        final String schemaName;
        final String packageName;
        final String typeName;

        TypeAsParts(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName) {
            if (typeName == null) {
                TypeAsParts.$$$reportNull$$$0(0);
            }
            this.schemaName = schemaName;
            this.packageName = packageName;
            this.typeName = typeName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeName", "com/intellij/database/model/properties/DataTypeFactory$TypeAsParts", "<init>"));
        }
    }

    private static class Trio {
        String primary;
        String inner;
        String suffix;

        private Trio() {
        }
    }
}

