/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.meta;

import com.intellij.database.model.meta.BasicMetaType;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.WeakInterner;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BasicMetaPropertyId<T> {
    private static final Interner<BasicMetaPropertyId<?>> ourInterner = new WeakInterner(new HashingStrategy<BasicMetaPropertyId<?>>(){

        public int hashCode(BasicMetaPropertyId<?> o) {
            return Objects.hash(o.name, o.type);
        }

        public boolean equals(BasicMetaPropertyId<?> o1, BasicMetaPropertyId<?> o2) {
            if (o1 == o2) {
                return true;
            }
            if (o2 == null) {
                return false;
            }
            return Objects.equals(o1.name, o2.name) && Objects.equals(o1.type, o2.type);
        }
    });
    public final String name;
    public final BasicMetaType<T> type;

    private BasicMetaPropertyId(String name, BasicMetaType<T> type) {
        this.name = name;
        this.type = type;
    }

    @NotNull
    public Class<T> getValueClass() {
        Class clazz = ReflectionUtil.boxType(this.type.valueClass);
        if (clazz == null) {
            BasicMetaPropertyId.$$$reportNull$$$0(0);
        }
        return clazz;
    }

    @Nullable
    public <U> BasicMetaPropertyId<U> tryCast(@NotNull Class<U> clazz) {
        if (clazz == null) {
            BasicMetaPropertyId.$$$reportNull$$$0(1);
        }
        if (clazz.isAssignableFrom(this.getValueClass())) {
            return this;
        }
        return null;
    }

    public String toString() {
        return this.name + ": " + this.type.toString();
    }

    public static <T> BasicMetaPropertyId<T> create(@NonNls String name, BasicMetaType<T> type) {
        return (BasicMetaPropertyId)ourInterner.intern(new BasicMetaPropertyId<T>(name, type));
    }

    @NotNull
    public static BasicMetaPropertyId<?> fake(@NonNls String name) {
        BasicMetaPropertyId<Boolean> basicMetaPropertyId = BasicMetaPropertyId.create(name, PropertyConverter.T_BOOLEAN);
        if (basicMetaPropertyId == null) {
            BasicMetaPropertyId.$$$reportNull$$$0(2);
        }
        return basicMetaPropertyId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/meta/BasicMetaPropertyId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/meta/BasicMetaPropertyId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "fake";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "tryCast";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

