/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.diff;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.DumpToDdlDataSourceActionKt;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.diff.DbDiffElement;
import com.intellij.database.model.diff.DbDiffRoot;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ScriptGenerators;
import com.intellij.database.script.generator.ScriptingAlterTask;
import com.intellij.database.script.generator.ScriptingAlterTaskBuilder;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.script.generator.ScriptingResult;
import com.intellij.database.script.generator.ScriptingSingleModelTaskBuilder;
import com.intellij.database.script.generator.ScriptingTask;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.view.ui.DatabaseScriptDialog;
import com.intellij.ide.diff.DiffElement;
import com.intellij.ide.diff.DiffType;
import com.intellij.ide.diff.DirDiffModel;
import com.intellij.ide.diff.DirDiffModelHolder;
import com.intellij.ide.diff.DirDiffOperation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.impl.dir.DTree;
import com.intellij.openapi.diff.impl.dir.DirDiffElementImpl;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairConsumer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbMigrationAction
extends IconWithTextAction
implements DirDiffModelHolder {
    private final Direction myDirection;
    private DirDiffModel myModel;

    public DbMigrationAction(Direction direction) {
        super(DatabaseBundle.message(direction == Direction.FORWARD ? "apply.right.to.the.left" : "apply.left.to.the.right", new Object[0]));
        this.getTemplatePresentation().setDisabledIcon(EmptyIcon.ICON_0);
        this.getTemplatePresentation().setIcon(EmptyIcon.ICON_0);
        this.myDirection = direction;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DbMigrationAction.$$$reportNull$$$0(0);
        }
        e.getPresentation().setEnabled(!this.myModel.getElements().isEmpty());
        JComponent component = (JComponent)e.getPresentation().getClientProperty(COMPONENT_KEY);
        if (component != null) {
            component.setToolTipText(e.getPresentation().getDescription());
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DbMigrationAction.$$$reportNull$$$0(1);
        }
        DirDiffModel m = this.myModel;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        try {
            DbMigrationAction.migrate(m, this.myDirection);
        }
        catch (UnsupportedOperationException uoe) {
            Component source = e.getInputEvent().getComponent();
            Messages.showErrorDialog((Component)source, (String)JdbcUtil.getMessage(uoe), (String)DatabaseBundle.message("dialog.title.migration.available", new Object[0]));
        }
    }

    private static BasicModel getModel(DirDiffModel model, boolean src, boolean isPrimary) {
        DbDiffRoot r = ((DbDiffElement)(src ? model.getSourceDir() : model.getTargetDir())).getRoot();
        if (isPrimary) {
            return r.getModel();
        }
        return (BasicModel)ObjectUtils.notNull((Object)r.getAltModel(), (Object)r.getModel());
    }

    private static BasicElement getElement(DTree d2, boolean src, boolean isPrimary) {
        DbDiffElement e = (DbDiffElement)(src ? d2.getSource() : d2.getTarget());
        if (e == null) {
            return null;
        }
        if (isPrimary || e.getRoot().getAltModel() == null) {
            return e.getValue();
        }
        return e.getAltElement();
    }

    public static void migrate(DirDiffModel model, Direction direction) {
        boolean isFromSrc = direction == Direction.FORWARD;
        DbDiffRoot root2 = ((DbDiffElement)(isFromSrc ? model.getSourceDir() : model.getTargetDir())).getRoot();
        SqlDataSource sqlTgt = (SqlDataSource)ObjectUtils.tryCast((Object)root2.getDataSource().getDelegate(), SqlDataSource.class);
        if (sqlTgt != null) {
            DbMigrationAction.performFileMigration(root2.getProject(), model, isFromSrc, sqlTgt);
        } else {
            DbMigrationAction.performAlterMigration(root2.getProject(), model, isFromSrc);
        }
    }

    private static void performFileMigration(@NotNull Project project, DirDiffModel model, boolean isFromSrc, SqlDataSource sqlTgt) {
        if (project == null) {
            DbMigrationAction.$$$reportNull$$$0(2);
        }
        DbMigrationAction.createFileMigration(project, model, isFromSrc, sqlTgt);
    }

    private static void performAlterMigration(final @NotNull Project project, final DirDiffModel model, final boolean isFromSrc) {
        if (project == null) {
            DbMigrationAction.$$$reportNull$$$0(3);
        }
        new Task.Modal(project, DatabaseBundle.message("dialog.title.generating.migration.script", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                AlterScriptGenerator generator = new AlterScriptGenerator(project, model, isFromSrc);
                ScriptingResult initialResult = generator.generate();
                ApplicationManager.getApplication().invokeLater(() -> DbMigrationAction.showAlterScript(initialResult, generator, project, model, isFromSrc));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/model/diff/DbMigrationAction$1", "run"));
            }
        }.queue();
    }

    private static void showAlterScript(final ScriptingResult initialResult, final AlterScriptGenerator generator, Project project, DirDiffModel model, boolean isFromSrc) {
        DiffElement source = isFromSrc ? model.getSourceDir() : model.getTargetDir();
        DiffElement target = isFromSrc ? model.getTargetDir() : model.getSourceDir();
        DbDataSource sourceDataSource = ((DbDiffElement)source).getRoot().getDataSource();
        SearchPath sourceSearchPath = DbMigrationAction.getSearchPath((DbDiffElement)source, sourceDataSource);
        String dialogTitle = DatabaseBundle.message("dialog.title.to.migration", source.getPresentablePath(), target.getPresentablePath());
        DatabaseScriptDialog dialog2 = new DatabaseScriptDialog(project, sourceDataSource, sourceSearchPath, dialogTitle){
            final AlterScriptGenerator myGenerator;
            private ProgressIndicator current;
            {
                super(project, dataSource2, searchPath, title);
                this.myGenerator = generator;
            }

            @Override
            protected void init() {
                super.init();
                this.setOKButtonText(DatabaseBundle.message("dialog.button.migration.script.execute", new Object[0]));
                this.updateText(initialResult);
            }

            @Override
            protected ScriptingTask getTask() {
                return this.myGenerator.createTask();
            }

            @Override
            protected void settingsChanged(ScriptingOptions options) {
                this.myGenerator.setOptions(options);
                this.generate();
            }

            private synchronized void generate() {
                this.loadingPanel.startLoading();
                if (this.current != null) {
                    this.current.cancel();
                }
                this.current = new EmptyProgressIndicator();
                this.generateAsync(this.current);
            }

            private void generateAsync(ProgressIndicator indicator) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    Runnable process2 = () -> {
                        ScriptingResult result2 = this.myGenerator.generate();
                        indicator.checkCanceled();
                        if (Disposer.isDisposed((Disposable)this.myDisposable)) {
                            return;
                        }
                        UIUtil.invokeLaterIfNeeded(() -> {
                            this.updateText(result2);
                            this.loadingPanel.stopLoading();
                        });
                    };
                    ProgressManager.getInstance().runProcess(process2, indicator);
                });
            }
        };
        dialog2.initAndShow();
    }

    @Nullable
    private static SearchPath getSearchPath(DbDiffElement source, DbDataSource sourceDataSource) {
        DasNamespace sourceNamespace = DbImplUtilCore.getSearchPathObjectForSwitch(sourceDataSource, source.getValue());
        return ObjectPaths.searchPathOf((DasObject)ObjectUtils.tryCast((Object)sourceNamespace, BasicNamespace.class));
    }

    @NotNull
    public static ScriptingAlterTask prepareMigrationTask(DirDiffModel model, boolean isFromSrc, ScriptingOptions options) {
        BasicModel src = DbMigrationAction.getModel(model, isFromSrc, true);
        BasicModModel tgt = (BasicModModel)DbMigrationAction.getModel(model, !isFromSrc, false);
        ScriptingAlterTaskBuilder builder = new ScriptingAlterTaskBuilder(src, tgt);
        DbMigrationAction.consumeChanged(model, isFromSrc, (PairConsumer<BasicElement, BasicElement>)((PairConsumer)(srcE, tgtE) -> {
            if (srcE != null || tgtE != null) {
                builder.getCorrespondence().add(ElementDelta.create(srcE, tgtE));
            }
        }));
        builder.setOptions(options);
        ScriptingAlterTask scriptingAlterTask = builder.build();
        if (scriptingAlterTask == null) {
            DbMigrationAction.$$$reportNull$$$0(4);
        }
        return scriptingAlterTask;
    }

    private static void createFileMigration(final @NotNull Project project, DirDiffModel model, boolean isFromSrc, final SqlDataSource sqlTgt) {
        if (project == null) {
            DbMigrationAction.$$$reportNull$$$0(5);
        }
        BasicModModel tgt = (BasicModModel)DbMigrationAction.getModel(model, !isFromSrc, false);
        final ScriptingSingleModelTaskBuilder builder = new ScriptingSingleModelTaskBuilder((BasicModel)tgt, ScriptCategory.CREATE_COMPLETE);
        DbMigrationAction.consumeChanged(model, isFromSrc, (PairConsumer<BasicElement, BasicElement>)((PairConsumer)(srcE, tgtE) -> {
            if (tgtE != null) {
                builder.getElements().add((BasicElement)tgtE);
            }
        }));
        new Task.Modal(project, DatabaseBundle.message("dialog.title.generating.migration.script", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                DumpToDdlDataSourceActionKt.generate(project, sqlTgt, builder, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/model/diff/DbMigrationAction$3", "run"));
            }
        }.queue();
    }

    private static void consumeChanged(DirDiffModel model, boolean isFromSrc, PairConsumer<BasicElement, BasicElement> consumer2) {
        boolean ignoreAlter;
        List elements = model.getElements();
        Map diffs = ContainerUtil.map2Map((Collection)elements, e -> Pair.create((Object)Couple.of((Object)e.getSource(), (Object)e.getTarget()), (Object)e.getOperation()));
        DTree rt = (DTree)JBIterable.generate((Object)((DirDiffElementImpl)elements.get(0)).getNode(), DTree::getParent).last();
        boolean ignoreCreate = !model.getSettings().showNewOnSource;
        boolean ignoreDrop = !model.getSettings().showNewOnTarget;
        boolean bl = ignoreAlter = !model.getSettings().showDifferent;
        if (isFromSrc) {
            boolean tmp2 = ignoreCreate;
            ignoreCreate = ignoreDrop;
            ignoreDrop = tmp2;
        }
        for (DTree e2 : (JBTreeTraverser)JBTreeTraverser.from(DTree::getChildren).withRoot((Object)rt)) {
            if (DbMigrationAction.isIgnored(diffs, e2, isFromSrc)) continue;
            BasicElement srcE = DbMigrationAction.getElement(e2, isFromSrc, true);
            BasicElement tgtE = DbMigrationAction.getElement(e2, !isFromSrc, false);
            if (srcE == null && ignoreCreate || tgtE == null && ignoreDrop || srcE != null && tgtE != null && e2.getType() == DiffType.CHANGED && ignoreAlter) continue;
            consumer2.consume((Object)srcE, (Object)tgtE);
        }
    }

    private static boolean isIgnored(Map<Couple<DiffElement>, DirDiffOperation> diffs, DTree e, boolean isFromSrc) {
        if (DbMigrationAction.getOperation(diffs, e) == DirDiffOperation.NONE) {
            return true;
        }
        if (DbMigrationAction.getOperation(diffs, e) == DirDiffOperation.DELETE && isFromSrc == (e.getSource() == null)) {
            return true;
        }
        Collection children2 = e.getChildren();
        if (ContainerUtil.find((Iterable)children2, c2 -> c2.getType() != DiffType.EQUAL) == null) {
            return false;
        }
        return ContainerUtil.find((Iterable)children2, c2 -> c2.getType() != DiffType.EQUAL && DbMigrationAction.getOperation(diffs, c2) != DirDiffOperation.NONE) == null;
    }

    private static DirDiffOperation getOperation(Map<Couple<DiffElement>, DirDiffOperation> diffs, DTree e) {
        return diffs.get(Pair.create((Object)e.getSource(), (Object)e.getTarget()));
    }

    public void setModel(DirDiffModel model) {
        this.myModel = model;
        String source = this.myModel.getSourceDir().getPresentablePath();
        String target = this.myModel.getTargetDir().getPresentablePath();
        this.getTemplatePresentation().setDescription(DatabaseBundle.message("action.DbMigrationAction.migrate.to.state.description", this.myDirection == Direction.FORWARD ? target : source, this.myDirection == Direction.FORWARD ? source : target));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/diff/DbMigrationAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/diff/DbMigrationAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareMigrationTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performFileMigration";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performAlterMigration";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFileMigration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AlterScriptGenerator {
        final Project project;
        final ScriptingAlterTaskBuilder builder;

        AlterScriptGenerator(Project project, DirDiffModel model, boolean isFromSrc) {
            this.project = project;
            BasicModel src = DbMigrationAction.getModel(model, isFromSrc, true);
            BasicModModel tgt = (BasicModModel)DbMigrationAction.getModel(model, !isFromSrc, false);
            this.builder = new ScriptingAlterTaskBuilder(src, tgt);
            DbMigrationAction.consumeChanged(model, isFromSrc, (PairConsumer<BasicElement, BasicElement>)((PairConsumer)(srcE, tgtE) -> {
                if (srcE != null || tgtE != null) {
                    this.builder.getCorrespondence().add(ElementDelta.create(srcE, tgtE));
                }
            }));
            DiffElement source = isFromSrc ? model.getSourceDir() : model.getTargetDir();
            this.setOptions(((DbDiffElement)source).getRoot().createOptions());
        }

        synchronized ScriptingTask createTask() {
            return this.builder.build();
        }

        synchronized void setOptions(ScriptingOptions options) {
            this.builder.setOptions(options);
        }

        @RequiresBackgroundThread
        ScriptingResult generate() {
            ApplicationManager.getApplication().assertIsNonDispatchThread();
            return ScriptGenerators.INSTANCE.makeScript(this.project, this.createTask());
        }
    }

    public static enum Direction {
        FORWARD,
        BACKWARD;

    }
}

