/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.session.LogView;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class DatabaseStartupActivity
implements StartupActivity.DumbAware {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            DatabaseStartupActivity.$$$reportNull$$$0(0);
        }
        DataEditorConfigurator.configure(project);
        ConsoleConfigurator.configure(project);
        ApplicationManager.getApplication().invokeLater(() -> DatabaseEditorHelper.installEditorFactoryListener(project), project.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseStartupActivity", "runActivity"));
    }

    private static class ConsoleConfigurator {
        private ConsoleConfigurator() {
        }

        public static void configure(@NotNull Project project) {
            if (project == null) {
                ConsoleConfigurator.$$$reportNull$$$0(0);
            }
            project.getMessageBus().connect().subscribe(DbPsiFacade.TOPIC, ds -> {
                DbPsiFacade dbFacade = DbPsiFacade.getInstance(project);
                List<JdbcConsole> allProjectConsoles = JdbcConsole.getActiveConsoles(dbFacade.getProject());
                for (JdbcConsole console : allProjectConsoles) {
                    LogView<DatabaseSessionClientWithFile> view2 = DatabaseSessionViewService.getInstance().getClientViewIfAny(console);
                    if (view2 == null || !console.isValid() || !DataSourceUtil.isDataSourceValid(dbFacade, (DasDataSource)console.getTarget())) continue;
                    String title = console.getDisplayName();
                    view2.setConsoleTitle(title);
                    view2.getContent().setDisplayName(title);
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/editor/DatabaseStartupActivity$ConsoleConfigurator", "configure"));
        }
    }

    public static final class DataEditorConfigurator {
        private static final Key<String> LAUNCH_ID = Key.create((String)"DATABASE_PROJECT_LAUNCH_ID");
        private static final Key<Boolean> SAFE_LOADING_KEY = Key.create((String)"DATA_GRID_SAFE_LOADING_KEY");
        private static final Key<Boolean> LOADING_DELAYED_KEY = Key.create((String)"DATA_GRID_LOADING_DELAYED_KEY");

        private DataEditorConfigurator() {
        }

        public static void configure(@NotNull Project project) {
            if (project == null) {
                DataEditorConfigurator.$$$reportNull$$$0(0);
            }
            SAFE_LOADING_KEY.set((UserDataHolder)project, (Object)true);
            DataEditorConfigurator.initLaunchId(project);
        }

        public static boolean isSafeToLoadData(@NotNull Project project) {
            if (project == null) {
                DataEditorConfigurator.$$$reportNull$$$0(1);
            }
            return Boolean.TRUE.equals(SAFE_LOADING_KEY.get((UserDataHolder)project));
        }

        public static boolean isLoadingDelayed(@NotNull DataGrid grid) {
            if (grid == null) {
                DataEditorConfigurator.$$$reportNull$$$0(2);
            }
            return Boolean.TRUE.equals(LOADING_DELAYED_KEY.get((UserDataHolder)grid));
        }

        public static void delayLoading(@NotNull DataGrid grid) {
            if (grid == null) {
                DataEditorConfigurator.$$$reportNull$$$0(3);
            }
            LOADING_DELAYED_KEY.set((UserDataHolder)grid, (Object)true);
            grid.loadingDelayed();
        }

        public static void disableLoadingDelay(@NotNull DataGrid grid) {
            if (grid == null) {
                DataEditorConfigurator.$$$reportNull$$$0(4);
            }
            LOADING_DELAYED_KEY.set((UserDataHolder)grid, null);
            grid.loadingDelayDisabled();
        }

        @NotNull
        private static String initLaunchId(@NotNull Project project) {
            if (project == null) {
                DataEditorConfigurator.$$$reportNull$$$0(5);
            }
            String restartId = UUID.randomUUID().toString();
            LAUNCH_ID.set((UserDataHolder)project, (Object)restartId);
            String string = restartId;
            if (string == null) {
                DataEditorConfigurator.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public static String getLaunchId(@NotNull Project project) {
            String launchId;
            if (project == null) {
                DataEditorConfigurator.$$$reportNull$$$0(7);
            }
            return (launchId = (String)LAUNCH_ID.get((UserDataHolder)project)) != null ? launchId : DataEditorConfigurator.initLaunchId(project);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "grid";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/editor/DatabaseStartupActivity$DataEditorConfigurator";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/editor/DatabaseStartupActivity$DataEditorConfigurator";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "initLaunchId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "configure";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isSafeToLoadData";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isLoadingDelayed";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "delayLoading";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "disableLoadingDelay";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "initLaunchId";
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getLaunchId";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

