/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ImportEditorContext;
import com.intellij.database.datagrid.AutoValueDescriptor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.DatabaseGridDataHookUp;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.mutating.ColumnDescriptor;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dbimport.ImportEditorState;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.ImportType;
import com.intellij.database.dbimport.ImportUtilCore;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.database.dbimport.ui.ImportDatabaseTableEditor;
import com.intellij.database.dbimport.ui.tree.ImportTargetChooser;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.database.view.models.TableEditorModel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ImportUtil
extends ImportUtilCore {
    private ImportUtil() {
    }

    @NotNull
    public static InputStream getInputStream(@NotNull VirtualFile file) throws IOException {
        VirtualFileSystem system;
        if (file == null) {
            ImportUtil.$$$reportNull$$$0(0);
        }
        InputStream stream = (system = file.getFileSystem()) instanceof JarFileSystem ? ImportUtil.getInputStreamForZip(file) : new FileInputStream(file.getPath());
        InputStream inputStream = CharsetToolkit.inputStreamSkippingBOM((InputStream)stream);
        if (inputStream == null) {
            ImportUtil.$$$reportNull$$$0(1);
        }
        return inputStream;
    }

    @NotNull
    public static AutoValueDescriptor createDescriptor(@NotNull DeColumn column2, boolean mapped) {
        if (column2 == null) {
            ImportUtil.$$$reportNull$$$0(2);
        }
        return new MyDeColumnDescriptor(column2, mapped);
    }

    @NotNull
    public static ImportDatabaseTableEditor<?> createEditor(@NotNull DeTable table, @NotNull List<? extends ColumnDescriptor> descriptors, @NotNull ImportEditorContext context) {
        if (table == null) {
            ImportUtil.$$$reportNull$$$0(3);
        }
        if (descriptors == null) {
            ImportUtil.$$$reportNull$$$0(4);
        }
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(5);
        }
        SqlCodeStyleSettings settings = SqlCodeStyles.getSqlSettings((Project)context.getProject(), (Language)context.getSqlDialect());
        TableEditorModel tableEditorModel = new TableEditorModel(table, new EditorModelsCache(settings));
        ImportEditorState<? extends ColumnDescriptor> state = new ImportEditorState<ColumnDescriptor>(context, descriptors);
        ImportDatabaseTableEditor editor = new ImportDatabaseTableEditor(state, context.getCaps(), tableEditorModel);
        Disposer.register((Disposable)context.getDisposable(), editor);
        ImportDatabaseTableEditor importDatabaseTableEditor = editor;
        if (importDatabaseTableEditor == null) {
            ImportUtil.$$$reportNull$$$0(6);
        }
        return importDatabaseTableEditor;
    }

    @NotNull
    public static List<DataConsumer.Row> getRows(@NotNull DataGrid grid) {
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(7);
        }
        List<DataConsumer.Row> list = grid.getDataModel(DataAccessType.DATABASE_DATA).getRows();
        if (list == null) {
            ImportUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public static DeTable createDeTableFromColumns(@NotNull DeModel model, @NotNull List<? extends ColumnDescriptor> descriptors, @NotNull String name) {
        if (model == null) {
            ImportUtil.$$$reportNull$$$0(9);
        }
        if (descriptors == null) {
            ImportUtil.$$$reportNull$$$0(10);
        }
        if (name == null) {
            ImportUtil.$$$reportNull$$$0(11);
        }
        DeTable table = new DeTable(name, null, model);
        table.columns.clear();
        for (ColumnDescriptor columnDescriptor : descriptors) {
            DeColumn column2 = new DeColumn(columnDescriptor.getName(), table, model);
            column2.dataType = columnDescriptor.getTypeName();
            table.columns.add(column2);
        }
        DeTable deTable = table;
        if (deTable == null) {
            ImportUtil.$$$reportNull$$$0(12);
        }
        return deTable;
    }

    public static void removeUnsupportedObjects(@NotNull DeTable table, @NotNull DatabaseEditorCapabilities.TableEditorCaps caps) {
        if (table == null) {
            ImportUtil.$$$reportNull$$$0(13);
        }
        if (caps == null) {
            ImportUtil.$$$reportNull$$$0(14);
        }
        if (!caps.getComment().isSupported()) {
            table.comment = null;
        }
        if (!caps.getColumnCaps(false).getComment().isSupported()) {
            for (DeColumn column2 : table.columns) {
                column2.comment = null;
            }
        }
    }

    public static void removeUntransferableObjects(@NotNull DeTable table) {
        if (table == null) {
            ImportUtil.$$$reportNull$$$0(15);
        }
        table.foreignKeys.clear();
        for (DeColumn column2 : table.columns) {
            column2.defaultValue = null;
            column2.flags.clear();
        }
        table.keys.clear();
        table.indices.clear();
    }

    @NotNull
    public static DeTable createTable(@NotNull ImportEditorContext context, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<DataConsumer.Row> rows, @NotNull Function<? super ColumnTypePredictorInfo, String> columnTypePredictor) {
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(16);
        }
        if (descriptors == null) {
            ImportUtil.$$$reportNull$$$0(17);
        }
        if (columnTypePredictor == null) {
            ImportUtil.$$$reportNull$$$0(18);
        }
        ImportInfo.Builder builder = context.getBuilder();
        List<? extends ColumnDescriptor> visibleProducers = builder.getVisibleProducers();
        DeModel oldModel = context.getDeModel();
        DeNamespace parent2 = ImportUtil.getSchema(context);
        DeTable table = new DeTable(context.getTableName(), parent2, oldModel);
        List producers = (List)ObjectUtils.chooseNotNull(visibleProducers, descriptors);
        table.columns.addAll(ImportUtil.createDeColumns(context, producers, rows, table, oldModel, columnTypePredictor));
        oldModel.addRoot(table);
        DeTable deTable = table;
        if (deTable == null) {
            ImportUtil.$$$reportNull$$$0(19);
        }
        return deTable;
    }

    @Nullable
    static DeNamespace getSchema(@NotNull ImportEditorContext context) {
        DeNamespace parent2;
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(20);
        }
        if ((parent2 = context.getNamespace()) != null && parent2.getKind() != ObjectKind.SCHEMA) {
            BasicSchema schema;
            assert (parent2.getKind() == ObjectKind.DATABASE) : "Unexpected " + parent2.getKind().code();
            BasicDatabase db = (BasicDatabase)ObjectUtils.tryCast((Object)parent2.unwrap(), BasicDatabase.class);
            BasicSchema basicSchema = schema = db == null ? null : ModelFun.getCurrentSchema(db);
            if (schema == null) {
                DeNamespace sc = new DeNamespace("", ObjectKind.SCHEMA, parent2.model);
                sc.parent = parent2;
                parent2.addLightChild(sc);
                parent2 = sc;
            } else {
                parent2 = (DeNamespace)parent2.model.getExportHelper().exportDeep(schema.getModel(), schema, false);
            }
        }
        return parent2;
    }

    @NotNull
    public static List<DataConsumer.Column> getColumns(@NotNull DataGrid grid) {
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(21);
        }
        List<DataConsumer.Column> columns = grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns();
        List list = ContainerUtil.filter(ImportUtil.unambiguous(grid, columns), (Condition)Conditions.not(DbImplUtilCore::isRowId));
        if (list == null) {
            ImportUtil.$$$reportNull$$$0(22);
        }
        return list;
    }

    @NotNull
    public static List<DataConsumer.Column> getVisibleColumns(@NotNull DataGrid grid) {
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(23);
        }
        ModelIndexSet indices = grid.getVisibleColumns();
        ArrayList<DataConsumer.Column> columns = new ArrayList<DataConsumer.Column>(grid.getDataModel(DataAccessType.DATABASE_DATA).getColumns(indices));
        ContainerUtil.sort(columns, Comparator.comparingInt(c2 -> c2.columnNum));
        List list = ContainerUtil.filter(ImportUtil.unambiguous(grid, columns), (Condition)Conditions.not(DbImplUtilCore::isRowId));
        if (list == null) {
            ImportUtil.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    public static String getPreferredTypeBasedOnContent(@NotNull ColumnTypePredictorInfo info) {
        if (info == null) {
            ImportUtil.$$$reportNull$$$0(25);
        }
        TypeMerger merger = null;
        ImportManager manager = info.context.getManager();
        if (info.rows == null || !(info.column instanceof DataConsumer.Column)) {
            String string = manager.getStringMerger().getName();
            if (string == null) {
                ImportUtil.$$$reportNull$$$0(26);
            }
            return string;
        }
        DataConsumer.Column column2 = (DataConsumer.Column)info.column;
        for (DataConsumer.Row row : info.rows) {
            Object object = column2.getValue(row);
            if (!(object instanceof String)) continue;
            String value2 = (String)object;
            TypeMerger nextMerger = manager.getType(value2);
            merger = merger == null ? nextMerger : merger.merge(nextMerger);
        }
        String string = merger == null ? manager.getStringMerger().getName() : merger.getName();
        if (string == null) {
            ImportUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private static List<DataConsumer.Column> unambiguous(@NotNull DataGrid grid, @NotNull List<DataConsumer.Column> columns) {
        DatabaseGridDataHookUp hookUp;
        SqlTableType type;
        if (grid == null) {
            ImportUtil.$$$reportNull$$$0(28);
        }
        if (columns == null) {
            ImportUtil.$$$reportNull$$$0(29);
        }
        SqlTableType sqlTableType = type = (hookUp = DataGridUtil.getDatabaseHookUp(grid)) == null ? null : hookUp.getTableType();
        if (type == null) {
            List<DataConsumer.Column> list = columns;
            if (list == null) {
                ImportUtil.$$$reportNull$$$0(30);
            }
            return list;
        }
        List<String> names = DbSqlUtil.getUnambiguousColumnNames(DataGridUtil.getProject(grid), DataGridUtil.getDatabaseDialect(grid), type, null);
        ArrayList<DataConsumer.Column> result2 = new ArrayList<DataConsumer.Column>();
        for (DataConsumer.Column column2 : columns) {
            if (column2.columnNum >= names.size()) {
                result2.add(column2);
                continue;
            }
            result2.add(new DataConsumer.Column(column2.columnNum, names.get(column2.columnNum), column2.type, column2.typeName, column2.clazz, column2.precision, column2.scale, column2.catalog, column2.schema, column2.table, column2.attributes));
        }
        ArrayList<DataConsumer.Column> arrayList = result2;
        if (arrayList == null) {
            ImportUtil.$$$reportNull$$$0(31);
        }
        return arrayList;
    }

    @NotNull
    private static List<DeColumn> createDeColumns(@NotNull ImportEditorContext context, @NotNull List<? extends ColumnDescriptor> descriptors, @Nullable List<DataConsumer.Row> rows, @NotNull DeTable table, @NotNull DeModel model, @NotNull Function<? super ColumnTypePredictorInfo, String> columnTypePredictor) {
        if (context == null) {
            ImportUtil.$$$reportNull$$$0(32);
        }
        if (descriptors == null) {
            ImportUtil.$$$reportNull$$$0(33);
        }
        if (table == null) {
            ImportUtil.$$$reportNull$$$0(34);
        }
        if (model == null) {
            ImportUtil.$$$reportNull$$$0(35);
        }
        if (columnTypePredictor == null) {
            ImportUtil.$$$reportNull$$$0(36);
        }
        ArrayList<DeColumn> result2 = new ArrayList<DeColumn>();
        for (ColumnDescriptor columnDescriptor : descriptors) {
            DeColumn deColumn = new DeColumn(columnDescriptor.getName(), table, model);
            deColumn.dataType = (String)columnTypePredictor.fun((Object)new ColumnTypePredictorInfo(context, columnDescriptor, rows));
            result2.add(deColumn);
        }
        ArrayList<DeColumn> arrayList = result2;
        if (arrayList == null) {
            ImportUtil.$$$reportNull$$$0(37);
        }
        return arrayList;
    }

    @NotNull
    private static InputStream getInputStreamForZip(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            ImportUtil.$$$reportNull$$$0(38);
        }
        JarFileSystem instance = JarFileSystem.getInstance();
        VirtualFile jar = instance.getVirtualFileForJar(file);
        VirtualFile root2 = instance.getJarRootForLocalFile(Objects.requireNonNull(jar));
        ZipFile zipFile = new ZipFile(Objects.requireNonNull(jar).getPath());
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)Objects.requireNonNull(root2));
        ZipEntry entry = zipFile.getEntry(relativePath);
        return new MyDelegateInputStream(zipFile.getInputStream(entry), zipFile);
    }

    public static boolean canBeProducer(@Nullable DbElement element2) {
        return element2 != null && DbImplUtilCore.canConnectTo(element2) && DbImplUtilCore.isDataTable(element2.getKind());
    }

    public static boolean canBeConsumer(@Nullable DbElement element2) {
        return ImportUtil.canBeConsumerFast(element2) && ImportUtil.canConnectToAndModify(element2) && !DbImplUtilCore.getDbms(element2).isDocumentOriented();
    }

    public static boolean canBeConsumerFast(@Nullable DasObject element2) {
        return element2 != null && (!(element2 instanceof DasNamespace) && !(element2 instanceof DbDataSource) || DbImplUtilCore.getTopSingleNamespace(element2) != null) && ImportType.of(element2) != null;
    }

    public static boolean canModify(@Nullable DbElement element2) {
        return element2 != null && element2.isWritable() && !DataImporter.isBusy(element2);
    }

    public static boolean canConnectToAndModify(@Nullable DbElement element2) {
        return element2 != null && element2.isWritable() && DbImplUtilCore.canConnectTo(element2) && !DataImporter.isBusy(element2);
    }

    @Nullable
    public static DbElement chooseTarget(@NotNull Project project, @Nullable DbElement producer) {
        if (project == null) {
            ImportUtil.$$$reportNull$$$0(39);
        }
        return new ImportTargetChooser(project, producer).choose(DatabaseBundle.message("Database.ChooseTarget", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/ImportUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 3: 
            case 13: 
            case 15: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 4: 
            case 10: 
            case 17: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 5: 
            case 16: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 21: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 9: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caps";
                break;
            }
            case 18: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnTypePredictor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/ImportUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeTableFromColumns";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createTable";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumns";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleColumns";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredTypeBasedOnContent";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "unambiguous";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 37: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRows";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDeTableFromColumns";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeUnsupportedObjects";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeUntransferableObjects";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createTable";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getSchema";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getColumns";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleColumns";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredTypeBasedOnContent";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "unambiguous";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createDeColumns";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getInputStreamForZip";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "chooseTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 12: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyDeColumnDescriptor
    implements AutoValueDescriptor {
        private final DeColumn myColumn;
        private final boolean myMapped;

        private MyDeColumnDescriptor(@NotNull DeColumn column2, boolean mapped) {
            if (column2 == null) {
                MyDeColumnDescriptor.$$$reportNull$$$0(0);
            }
            this.myColumn = column2;
            this.myMapped = mapped;
        }

        @Override
        public int getScale() {
            return this.myColumn.getDataType().getScale();
        }

        @Override
        public int getSize() {
            return this.myColumn.getDataType().getPrecision();
        }

        @Override
        public int getType() {
            return JdbcUtil.guessJdbcTypeByName(this.myColumn.dataType);
        }

        @Override
        public String getName() {
            return this.myColumn.getName();
        }

        @Override
        public String getTypeName() {
            return this.myColumn.dataType;
        }

        @Override
        public String getJavaClassName() {
            return "";
        }

        @Override
        public boolean isAutogenerated() {
            return !this.myMapped && this.myColumn.flags.contains((Object)DeColumn.Flag.AUTO_INC);
        }

        @Override
        public boolean isComputed() {
            return !this.myMapped && this.myColumn.isComputed();
        }

        @Override
        public boolean hasDefault() {
            return !this.myMapped && this.myColumn.defaultValue != null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dbimport/ImportUtil$MyDeColumnDescriptor", "<init>"));
        }
    }

    private static final class MyDelegateInputStream
    extends InputStream {
        private final InputStream myStream;
        private final Closeable myCloseable;

        private MyDelegateInputStream(@NotNull InputStream stream, @NotNull Closeable closeable) {
            if (stream == null) {
                MyDelegateInputStream.$$$reportNull$$$0(0);
            }
            if (closeable == null) {
                MyDelegateInputStream.$$$reportNull$$$0(1);
            }
            this.myStream = stream;
            this.myCloseable = closeable;
        }

        @Override
        public int read() throws IOException {
            return this.myStream.read();
        }

        @Override
        public int read(@NotNull byte[] b2, int off, int len) throws IOException {
            if (b2 == null) {
                MyDelegateInputStream.$$$reportNull$$$0(2);
            }
            return this.myStream.read(b2, off, len);
        }

        @Override
        public int read(@NotNull byte[] b2) throws IOException {
            if (b2 == null) {
                MyDelegateInputStream.$$$reportNull$$$0(3);
            }
            return this.myStream.read(b2);
        }

        @Override
        public void close() throws IOException {
            this.myStream.close();
            this.myCloseable.close();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "closeable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "b";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dbimport/ImportUtil$MyDelegateInputStream";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ColumnTypePredictorInfo {
        public final ImportEditorContext context;
        public final ColumnDescriptor column;
        public final List<DataConsumer.Row> rows;

        public ColumnTypePredictorInfo(@NotNull ImportEditorContext context, @NotNull ColumnDescriptor column2, @Nullable List<DataConsumer.Row> rows) {
            if (context == null) {
                ColumnTypePredictorInfo.$$$reportNull$$$0(0);
            }
            if (column2 == null) {
                ColumnTypePredictorInfo.$$$reportNull$$$0(1);
            }
            this.context = context;
            this.column = column2;
            this.rows = rows;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "column";
                    break;
                }
            }
            objectArray[1] = "com/intellij/database/dbimport/ImportUtil$ColumnTypePredictorInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

