/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.DomainRegistry;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.GridHelper$WhenMappings;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPaths;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\bf\u0018\u0000 )2\u00020\u0001:\u0001)J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016JJ\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J6\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J6\u0010\u001c\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0014\u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\f\u001a\u00020\rH\u0016J:\u0010\"\u001a\u0004\u0018\u00010#2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0016J\b\u0010$\u001a\u00020#H\u0016J,\u0010%\u001a\u00020&2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010'\u001a\u00020(H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006*"}, d2={"Lcom/intellij/database/datagrid/GridHelper;", "", "dbms", "Lcom/intellij/database/Dbms;", "getDbms", "()Lcom/intellij/database/Dbms;", "createCellCodeFragment", "Lcom/intellij/psi/PsiCodeFragment;", "text", "", "project", "Lcom/intellij/openapi/project/Project;", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "grid", "Lcom/intellij/database/datagrid/CoreGrid;", "Lcom/intellij/database/datagrid/DataConsumer$Row;", "Lcom/intellij/database/datagrid/DataConsumer$Column;", "row", "Lcom/intellij/database/datagrid/ModelIndex;", "column", "createFilterCodeFragment", "filterText", "queryText", "dataSource", "Lcom/intellij/database/psi/DbDataSource;", "table", "Lcom/intellij/database/model/DasTable;", "createSortingCodeFragment", "sortingText", "getAttributes", "", "Lcom/intellij/database/datagrid/DataConsumer$Column$Attribute;", "Lcom/intellij/database/model/DasColumn;", "getCellLanguage", "Lcom/intellij/lang/Language;", "getFilterLanguage", "setFilterText", "", "caretPosition", "", "Companion", "intellij.database.core.impl"})
public interface GridHelper {
    @NotNull
    public static final Companion Companion = com.intellij.database.datagrid.GridHelper$Companion.$$INSTANCE;

    @NotNull
    public Dbms getDbms();

    public void setFilterText(@NotNull CoreGrid<DataConsumer.Row, DataConsumer.Column> var1, @NotNull String var2, int var3);

    @Nullable
    public Language getCellLanguage(@NotNull Domain var1);

    @Nullable
    public Language getCellLanguage(@NotNull CoreGrid<DataConsumer.Row, DataConsumer.Column> var1, @NotNull ModelIndex<DataConsumer.Row> var2, @NotNull ModelIndex<DataConsumer.Column> var3);

    @Nullable
    public PsiCodeFragment createCellCodeFragment(@NotNull String var1, @NotNull Project var2, @NotNull CoreGrid<DataConsumer.Row, DataConsumer.Column> var3, @NotNull ModelIndex<DataConsumer.Row> var4, @NotNull ModelIndex<DataConsumer.Column> var5);

    @Nullable
    public PsiCodeFragment createCellCodeFragment(@NotNull String var1, @NotNull Project var2, @NotNull Domain var3);

    @Nullable
    public PsiCodeFragment createFilterCodeFragment(@NotNull Project var1, @NotNull String var2, @Nullable String var3, @NotNull DbDataSource var4, @Nullable DasTable var5);

    @Nullable
    public PsiCodeFragment createSortingCodeFragment(@NotNull Project var1, @NotNull String var2, @Nullable String var3, @NotNull DbDataSource var4, @Nullable DasTable var5);

    @NotNull
    public Language getFilterLanguage();

    @NotNull
    public Set<DataConsumer.Column.Attribute> getAttributes(@NotNull DasColumn var1);

    @JvmStatic
    @NotNull
    public static GridHelper get(@NotNull Dbms dbms) {
        return Companion.get(dbms);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        public static void setFilterText(@NotNull GridHelper $this, @NotNull CoreGrid<DataConsumer.Row, DataConsumer.Column> grid, @NotNull String text2, int caretPosition) {
            Intrinsics.checkNotNullParameter(grid, (String)"grid");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            grid.setFilterText(text2, caretPosition);
        }

        @Nullable
        public static Language getCellLanguage(@NotNull GridHelper $this, @NotNull Domain domain) {
            Language language;
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            switch (GridHelper$WhenMappings.$EnumSwitchMapping$0[domain.getLogicType().ordinal()]) {
                case 1: {
                    language = Language.findLanguageByID((String)"JSON5");
                    break;
                }
                case 2: {
                    language = Companion.getXML_LANGUAGE();
                    break;
                }
                default: {
                    language = null;
                }
            }
            return language;
        }

        @Nullable
        public static Language getCellLanguage(@NotNull GridHelper $this, @NotNull CoreGrid<DataConsumer.Row, DataConsumer.Column> grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            Language language;
            Intrinsics.checkNotNullParameter(grid, (String)"grid");
            Intrinsics.checkNotNullParameter(row, (String)"row");
            Intrinsics.checkNotNullParameter(column2, (String)"column");
            DomainRegistry domainRegistry = BaseDomainRegistry.get($this.getDbms(), null);
            if (domainRegistry == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)domainRegistry, (String)"BaseDomainRegistry.get(dbms, null) ?: return null");
            DomainRegistry registry = domainRegistry;
            DataConsumer.Column c2 = grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getColumn(column2);
            if (c2 == null) {
                return null;
            }
            Domain domain = registry.getDomain(c2);
            if (domain != null) {
                Domain domain2 = domain;
                boolean bl = false;
                boolean bl2 = false;
                Domain it2 = domain2;
                boolean bl3 = false;
                Domain domain3 = it2;
                Intrinsics.checkNotNullExpressionValue((Object)domain3, (String)"it");
                language = $this.getCellLanguage(domain3);
            } else {
                language = null;
            }
            return language;
        }

        @Nullable
        public static PsiCodeFragment createCellCodeFragment(@NotNull GridHelper $this, @NotNull String text2, @NotNull Project project, @NotNull CoreGrid<DataConsumer.Row, DataConsumer.Column> grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(grid, (String)"grid");
            Intrinsics.checkNotNullParameter(row, (String)"row");
            Intrinsics.checkNotNullParameter(column2, (String)"column");
            return null;
        }

        @Nullable
        public static PsiCodeFragment createCellCodeFragment(@NotNull GridHelper $this, @NotNull String text2, @NotNull Project project, @NotNull Domain domain) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            return null;
        }

        @Nullable
        public static PsiCodeFragment createFilterCodeFragment(@NotNull GridHelper $this, @NotNull Project project, @NotNull String filterText, @Nullable String queryText2, @NotNull DbDataSource dataSource2, @Nullable DasTable table) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)filterText, (String)"filterText");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            if (queryText2 == null) {
                return null;
            }
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect($this.getDbms());
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"DbSqlUtilCore.getSqlDialect(dbms)");
            SqlLanguageDialect sqlDialect = sqlLanguageDialect;
            SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)sqlPsiFacade, (String)"SqlPsiFacade.getInstance(project)");
            SqlPsiFacade psiFacade = sqlPsiFacade;
            DasNamespace nsp = DbImplUtilCore.getSearchPathObject(DbImplUtilCore.getDatabaseDialect(dataSource2), table);
            return (PsiCodeFragment)psiFacade.createExpressionFragment((Language)sqlDialect, dataSource2, ObjectPaths.searchPathOf(nsp), filterText, queryText2);
        }

        @Nullable
        public static PsiCodeFragment createSortingCodeFragment(@NotNull GridHelper $this, @NotNull Project project, @NotNull String sortingText, @Nullable String queryText2, @NotNull DbDataSource dataSource2, @Nullable DasTable table) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)sortingText, (String)"sortingText");
            Intrinsics.checkNotNullParameter((Object)dataSource2, (String)"dataSource");
            if (queryText2 == null) {
                return null;
            }
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect($this.getDbms());
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"DbSqlUtilCore.getSqlDialect(dbms)");
            SqlLanguageDialect sqlDialect = sqlLanguageDialect;
            SqlPsiFacade sqlPsiFacade = SqlPsiFacade.getInstance((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)sqlPsiFacade, (String)"SqlPsiFacade.getInstance(project)");
            SqlPsiFacade psiFacade = sqlPsiFacade;
            DasNamespace nsp = DbImplUtilCore.getSearchPathObject(DbImplUtilCore.getDatabaseDialect(dataSource2), table);
            return (PsiCodeFragment)psiFacade.createOrderByFragment((Language)sqlDialect, dataSource2, ObjectPaths.searchPathOf(nsp), sortingText, queryText2);
        }

        @NotNull
        public static Language getFilterLanguage(@NotNull GridHelper $this) {
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtilCore.getSqlDialect($this.getDbms());
            Intrinsics.checkNotNullExpressionValue((Object)sqlLanguageDialect, (String)"DbSqlUtilCore.getSqlDialect(dbms)");
            return (Language)sqlLanguageDialect;
        }

        @NotNull
        public static Set<DataConsumer.Column.Attribute> getAttributes(@NotNull GridHelper $this, @NotNull DasColumn column2) {
            Intrinsics.checkNotNullParameter((Object)column2, (String)"column");
            return SetsKt.emptySet();
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0018\u0010\b\u001a\t\u0018\u00010\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/database/datagrid/GridHelper$Companion;", "", "()V", "EP", "Lcom/intellij/database/DbmsExtension;", "Lcom/intellij/database/datagrid/GridHelper;", "getEP", "()Lcom/intellij/database/DbmsExtension;", "XML_LANGUAGE", "Lcom/intellij/lang/Language;", "Lorg/jetbrains/annotations/Nullable;", "getXML_LANGUAGE", "()Lcom/intellij/lang/Language;", "get", "dbms", "Lcom/intellij/database/Dbms;", "intellij.database.core.impl"})
    public static final class Companion {
        @Nullable
        private static final Language XML_LANGUAGE;
        @NotNull
        private static final DbmsExtension<GridHelper> EP;
        static final /* synthetic */ Companion $$INSTANCE;

        @Nullable
        public final Language getXML_LANGUAGE() {
            return XML_LANGUAGE;
        }

        @NotNull
        public final DbmsExtension<GridHelper> getEP() {
            return EP;
        }

        @JvmStatic
        @NotNull
        public final GridHelper get(@NotNull Dbms dbms) {
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            GridHelper gridHelper = EP.forDbms(dbms);
            Intrinsics.checkNotNullExpressionValue((Object)gridHelper, (String)"EP.forDbms(dbms)");
            return gridHelper;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            XML_LANGUAGE = Language.findLanguageByID((String)"XML");
            EP = new DbmsExtension("com.intellij.database.gridHelper");
        }
    }
}

