/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.cli;

import com.intellij.database.cli.CliConfiguration;
import com.intellij.database.cli.dump.mysql.MysqldumpConfiguration;
import com.intellij.database.cli.dump.pg.PgDumpConfiguration;
import com.intellij.database.cli.restore.mysql.MysqlConfiguration;
import com.intellij.database.cli.restore.pg.PgRestoreConfiguration;
import com.intellij.database.cli.restore.pg.PsqlConfiguration;
import com.intellij.database.psi.DbElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class CliConfigurationPack {
    public static final CliConfigurationPack MYSQL_DUMP = new CliConfigurationPack("MYSQL_DUMP_CLI_PACK", MysqldumpConfiguration.INSTANCE);
    public static final CliConfigurationPack PG_DUMP = new CliConfigurationPack("PG_DUMP_CLI_PACK", PgDumpConfiguration.INSTANCE);
    public static final CliConfigurationPack MYSQL_RESTORE = new CliConfigurationPack("MYSQL_RESTORE_CLI_PACK", MysqlConfiguration.INSTANCE);
    public static final CliConfigurationPack PG_RESTORE = new CliConfigurationPack("PG_RESTORE_CLI_PACK", PgRestoreConfiguration.INSTANCE, PsqlConfiguration.INSTANCE);
    private final Collection<CliConfiguration> myConfigurations;
    private final String myKey;

    public CliConfigurationPack(@NotNull String key, CliConfiguration ... configurations) {
        if (key == null) {
            CliConfigurationPack.$$$reportNull$$$0(0);
        }
        if (configurations == null) {
            CliConfigurationPack.$$$reportNull$$$0(1);
        }
        this.myConfigurations = Arrays.asList(configurations);
        this.myKey = key;
    }

    @NotNull
    public Collection<CliConfiguration> getConfigurations() {
        Collection<CliConfiguration> collection = this.myConfigurations;
        if (collection == null) {
            CliConfigurationPack.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public String getKey() {
        String string = this.myKey;
        if (string == null) {
            CliConfigurationPack.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public CliConfiguration first() {
        CliConfiguration cliConfiguration = Objects.requireNonNull((CliConfiguration)ContainerUtil.getFirstItem(this.myConfigurations));
        if (cliConfiguration == null) {
            CliConfigurationPack.$$$reportNull$$$0(4);
        }
        return cliConfiguration;
    }

    @NotNull
    public CliConfigurationPack filtered(@NotNull Collection<DbElement> elements) {
        if (elements == null) {
            CliConfigurationPack.$$$reportNull$$$0(5);
        }
        List filtered2 = ContainerUtil.filter(this.myConfigurations, c2 -> c2.getObjectsPreparer().prepare(elements).isValid());
        return new CliConfigurationPack(this.myKey, (CliConfiguration[])ContainerUtil.toArray((Collection)filtered2, CliConfiguration[]::new));
    }

    public boolean isEmpty() {
        return this.myConfigurations.size() == 0;
    }

    public boolean isSingleConfiguration() {
        return this.myConfigurations.size() == 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/cli/CliConfigurationPack";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/cli/CliConfigurationPack";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "first";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filtered";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

