/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutterAction;
import com.intellij.openapi.editor.TextAnnotationGutterProvider;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressPanel;
import com.jetbrains.cidr.execution.debugger.memory.MemoryAddressGutterProvider;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class MemoryViewFileEditorProvider
implements FileEditorProvider,
DumbAware {
    private final FileEditorProvider myDelegate = new PsiAwareTextEditorProvider();

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(1);
        }
        return file instanceof MemoryViewFile;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditor fileEditor;
        if (project == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(3);
        }
        if ((fileEditor = this.myDelegate.createEditor(project, file)) instanceof TextEditor && file instanceof MemoryViewFile) {
            this.setupMemoryViewEditor(project, (MemoryViewFile)file, (TextEditor)fileEditor);
        }
        FileEditor fileEditor2 = fileEditor;
        if (fileEditor2 == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(4);
        }
        return fileEditor2;
    }

    protected void setupMemoryViewEditor(@NotNull Project project, @NotNull MemoryViewFile file, @NotNull TextEditor fileEditor) {
        CidrMemoryDoc<?> memoryDoc;
        if (project == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(5);
        }
        if (file == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(6);
        }
        if (fileEditor == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(7);
        }
        if ((memoryDoc = file.getMemoryDoc()) == null) {
            return;
        }
        Editor editor = fileEditor.getEditor();
        editor.getSettings().setLineNumbersShown(false);
        MemoryAddressGutterProvider gutterProvider = new MemoryAddressGutterProvider(memoryDoc);
        final EditorGutterComponentEx gutter = (EditorGutterComponentEx)editor.getGutter();
        gutter.registerTextAnnotation((TextAnnotationGutterProvider)gutterProvider, (EditorGutterAction)gutterProvider);
        gutter.setCanCloseAnnotations(false);
        final GotoAddressPanel gotoAddressPanel = GotoAddressPanel.createFor(editor, ((EditorImpl)editor).getDisposable(), memoryDoc);
        if (gotoAddressPanel != null) {
            fileEditor.putUserData(GotoAddressPanel.GOTO_ADDRESS_FILE_EDITOR_KEY, (Object)gotoAddressPanel);
            gutter.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    gotoAddressPanel.setSeparatorOffset(gutter.getWhitespaceSeparatorOffset());
                }
            });
            ApplicationManager.getApplication().invokeLater(() -> {
                FileEditorManager.getInstance((Project)project).addTopComponent((FileEditor)fileEditor, (JComponent)((Object)gotoAddressPanel));
                gutter.revalidate();
            });
        }
    }

    @NotNull
    public String getEditorTypeId() {
        return "memory-view";
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project, @NotNull VirtualFile file) {
        if (element == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(8);
        }
        if (project == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(9);
        }
        if (file == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(10);
        }
        FileEditorState fileEditorState = this.myDelegate.readState(element, project, file);
        if (fileEditorState == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(11);
        }
        return fileEditorState;
    }

    public void writeState(@NotNull FileEditorState _state, @NotNull Project project, @NotNull Element element) {
        if (_state == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(12);
        }
        if (project == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(13);
        }
        if (element == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(14);
        }
        this.myDelegate.writeState(_state, project, element);
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(15);
        }
        return fileEditorPolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/memory/MemoryViewFileEditorProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/memory/MemoryViewFileEditorProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: 
            case 11: 
            case 15: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupMemoryViewEditor";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

