/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrAddressBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCleanableBreakpointHandlerBase;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00020\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J8\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0016\u001a\u00020\u00172\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u0002J\u001a\u0010\u0018\u001a\u00020\u00172\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u0014J\"\u0010\u0019\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\u0006\u0010\f\u001a\u00020\u0015H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrAddressBreakpointHandler;", "Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrCleanableBreakpointHandlerBase;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointProperties;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "addCodepointsInBackend", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLCodepoint;", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "breakpoint", "threadId", "", "frameIndex", "", "handleBreakpointUpdated", "", "uiBreakpoint", "newBreakpoint", "Lcom/jetbrains/cidr/execution/debugger/backend/LLBreakpoint;", "isOurBreakpoint", "", "shouldBreakpointBeRemoved", "updateBreakpointPresentation", "intellij.cidr.debugger"})
public final class CidrAddressBreakpointHandler
extends CidrCleanableBreakpointHandlerBase<XLineBreakpoint<XBreakpointProperties<?>>> {
    @Override
    protected boolean shouldBreakpointBeRemoved(@NotNull XLineBreakpoint<XBreakpointProperties<?>> breakpoint) {
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        return this.isOurBreakpoint(breakpoint);
    }

    @Override
    @NotNull
    protected Collection<LLCodepoint> addCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull XLineBreakpoint<XBreakpointProperties<?>> breakpoint, long threadId, int frameIndex) throws ExecutionException {
        LLBreakpoint lLBreakpoint;
        Intrinsics.checkNotNullParameter((Object)driver, (String)"driver");
        Intrinsics.checkNotNullParameter(breakpoint, (String)"breakpoint");
        if (!this.isOurBreakpoint(breakpoint)) {
            return CollectionsKt.emptyList();
        }
        Address address = CidrAddressBreakpointType.Companion.breakpointToAddress(breakpoint);
        if (address == null) {
            return CollectionsKt.emptyList();
        }
        Address address2 = address;
        try {
            LLBreakpoint lLBreakpoint2 = driver.addAddressBreakpoint(address2, this.convertCondition((XBreakpoint<XBreakpointProperties>)((XBreakpoint)breakpoint)));
            Intrinsics.checkNotNullExpressionValue((Object)lLBreakpoint2, (String)"driver.addAddressBreakpo\u2026ertCondition(breakpoint))");
            lLBreakpoint = lLBreakpoint2;
        }
        catch (DebuggerCommandException e) {
            CidrDebugProcess cidrDebugProcess = this.myProcess;
            Intrinsics.checkNotNullExpressionValue((Object)cidrDebugProcess, (String)"myProcess");
            cidrDebugProcess.getSession().setBreakpointInvalid(breakpoint, e.getMessage());
            return CollectionsKt.emptyList();
        }
        LLBreakpoint result2 = lLBreakpoint;
        this.updateBreakpointPresentation(breakpoint, result2);
        return CollectionsKt.listOf((Object)result2);
    }

    public final void handleBreakpointUpdated(@NotNull XLineBreakpoint<XBreakpointProperties<?>> uiBreakpoint, @NotNull LLBreakpoint newBreakpoint) {
        Intrinsics.checkNotNullParameter(uiBreakpoint, (String)"uiBreakpoint");
        Intrinsics.checkNotNullParameter((Object)newBreakpoint, (String)"newBreakpoint");
        this.unregisterCodepointsMapping((XBreakpoint)uiBreakpoint);
        this.registerCodepointsMapping((XBreakpoint)uiBreakpoint, CollectionsKt.listOf((Object)newBreakpoint));
        this.updateBreakpointPresentation(uiBreakpoint, newBreakpoint);
    }

    private final void updateBreakpointPresentation(XLineBreakpoint<XBreakpointProperties<?>> uiBreakpoint, LLBreakpoint breakpoint) {
        if (!breakpoint.isPending()) {
            CidrDebugProcess cidrDebugProcess = this.myProcess;
            Intrinsics.checkNotNullExpressionValue((Object)cidrDebugProcess, (String)"myProcess");
            cidrDebugProcess.getSession().setBreakpointVerified(uiBreakpoint);
        } else {
            CidrDebugProcess cidrDebugProcess = this.myProcess;
            Intrinsics.checkNotNullExpressionValue((Object)cidrDebugProcess, (String)"myProcess");
            cidrDebugProcess.getSession().setBreakpointInvalid(uiBreakpoint, CidrDebuggerBundle.message("debug.breakpoint.line.unresolved.hint", new Object[0]));
        }
    }

    private final boolean isOurBreakpoint(XLineBreakpoint<XBreakpointProperties<?>> breakpoint) {
        XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
        if (xSourcePosition == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)xSourcePosition, (String)"breakpoint.sourcePosition ?: return false");
        XSourcePosition pos = xSourcePosition;
        return this.myProcess.fileToMemoryDoc(pos.getFile()) != null;
    }

    public CidrAddressBreakpointHandler(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        super(process, CidrAddressBreakpointType.class);
    }
}

